class MutableInt {
	public int v;
	public MutableInt(int v) { this.v = v; }
}

public class LockThread extends Thread {
	int id;
	int counter;
	MutableInt accumulator;
	
	LockThread(int id, int c, MutableInt a) {
		this.id = id;
		this.counter = c;
		accumulator = a;
	}
	
	public void run() {
		for (int i=0; i<counter; i++) {
			synchronized (accumulator) { accumulator.v++; } 
		}
	}
	
	public static void main(String[] args) {
		int n = 100;
		int c = 1000;
		MutableInt a = new MutableInt(0);
		
		Thread[] threads = new Thread[n];
		for (int i=0; i<n; i++) threads[i] = new LockThread(i,c,a);
		
		for (int i=0; i<n; i++) threads[i].start();
		
		// wait for all threads to finish
		try {
			for (int i=0; i<n; i++) threads[i].join();
		}
		catch (Exception e) {
			System.out.println(e.getMessage());
		}
		
		System.out.println("accumulator = " + a.v);
	}
}
