import java.util.Random;

class Visitor extends Thread {
	int id;
	Hotel hotel;

	public Visitor(int id, Hotel hotel) {
		this.id = id;
		this.hotel = hotel;
	}

	public void run() {
		boolean inHotel = false;
		while (true) {
			inHotel = hotel.requestRoom();
			if (inHotel) break;
			try {
				synchronized (hotel) { hotel.wait(); }
			} catch (InterruptedException e) {
				System.out.println(e.getMessage());
			}
		}

		System.out.println("Visitor " + id + " in hotel.");

		try {
			Thread.sleep(100);
		} catch (InterruptedException e) {
			System.out.println(e.getMessage());
		}

		hotel.leaveRoom();
		System.out.println("Visitor " + id + " leaves hotel.");
		synchronized (hotel) { hotel.notifyAll(); }
	}

}

public class Hotel {
	int capacity;
	int roomsLeft;

	public Hotel(int capacity) {
		this.capacity = capacity;
		this.roomsLeft = capacity;
	}

	public synchronized boolean requestRoom() {
		if (roomsLeft > 0) {
			roomsLeft--;
			return true;
		}
		return false;
	}

	public synchronized void leaveRoom() {
		roomsLeft++;
	}

	public static void main(String[] args) {
		int capacity = 2;
		int n = 10;

		Hotel hotel = new Hotel(capacity);

		Visitor[] visitors = new Visitor[n];
		for (int i=0; i<n; i++) visitors[i] = new Visitor(i,hotel);
		for (int i=0; i<n; i++) visitors[i].start();
	}

}
