import java.util.Scanner;

/**
 * Contains a string phrase and its translation to pig latin.
 * @author Christie
 *
 */
public class PigLatinPhrase
{
	private String realPhrase;
	private String pigPhrase;
	/**
	 * Constructor for the PigLatinPhrase class
	 * @param s the phrase to be converted to pig latin.
	 * @throws PigException
	 */
	public PigLatinPhrase(String s) throws PigException
	{
		System.out.println("I'm debugging!");
		realPhrase=s;
		realPhrase = realPhrase.toLowerCase();
		pigIt();
		
	}
	/**
	 * Performs conversion to pig latin and modifies
	 * pigPhrase to contain the result.
	 * @throws PigException
	 */
	private void pigIt() throws PigException
	{

		//ex: world-->orldway
		
		//we decided not to allow periods or commas in our pig latin
		//phrase, and we throw an exception when they are found.
	    if (realPhrase.contains(".")|| realPhrase.contains(","))
	    	throw new PigException("No punctuation!");
		String[] temp = realPhrase.split(" ");
		pigPhrase = "";
		for(int i = 0; i<temp.length; i++)
		{
			String wd = temp[i];
			String newWd;
			if(wd.charAt(0)=='a'||wd.charAt(0)=='e'||
					wd.charAt(0)=='i'||wd.charAt(0)=='o'||
					wd.charAt(0)=='u')
				newWd = wd.substring(1)+wd.charAt(0)+"hay";
			else
				newWd = wd.substring(1)+wd.charAt(0)+"ay";
			pigPhrase+=newWd+" ";
		}
	}
	/**
	 * Gets the pig latin phrase.
	 * @return
	 */
	public String getPigPhrase()
	{
		return pigPhrase;
	}

}
/**
 * (Very trivial) example of creating your own exception.
 * The use of "super" means we called the parent constructor.
 * @author Christie
 *
 */
class PigException extends Exception
{
	public PigException(String s)
	{
		super (s);
	}
	
}