package sortGUI;

import java.awt.*;
import java.util.*;
import javax.swing.*;

@SuppressWarnings("serial")
public class SortItem extends JComponent{

	//possible sorts to create
	public static final String[] SORTS={"Quicksort", "Insertion Sort", "Bucket Sort", "Heap Sort", "SelectionSort", "MergeSort"};
	
	//possible data types
	public static final String[] DATA_TYPES={"Random", "Nearly Sorted", "Reversed"};
	
	private static int[] arr;						//array for all sort items to sort
	private static ArrayList <SortItem> sortItems;	//sortItems to display
	private static final int WIDTH=180;				//width of sort item				
	private static final int HEIGHT=140;			//height of sort item
	
	private int h1; 								//high mark
	private int h2;									//low mark
	private String alg;								//algorithm name
	private SortAlgorithm algorithm;				//sort algorithm this item is running
	private Thread thread;							//thread of current sort
	private final int SLEEP_TIME=50;				//interval between operations of sort	
	
	static{
		randomize();
		sortItems=new ArrayList <SortItem> (SORTS.length);
	}//end static
	
	//create sort algorithm and add it to the list
	public SortItem(String alg){

		setSize(new Dimension(WIDTH, HEIGHT));
		this.alg=alg;

		createAlgorithm();

		h1=-1;
		h2=-1;

		setBackground(Color.white);
		sortItems.add(this);
	}//end constructor

	//creates appropriate sort algorithm
	private void createAlgorithm(){
		if(alg.equals(SORTS[0]))
			algorithm=new QuickSortAlgorithm(copy(), this);
		else if(alg.equals(SORTS[1]))
			algorithm=new InsertionSortAlgorithm(copy(), this);
		else if(alg.equals(SORTS[2]))
			algorithm=new BucketSortAlgorithm(copy(), this);
		else if(alg.equals(SORTS[3]))
			algorithm=new HeapSortAlgorithm(copy(), this);
		else if(alg.equals(SORTS[4]))
			algorithm=new SelectionSortAlgorithm(copy(), this);
		else if(alg.equals(SORTS[5]))
			algorithm=new MergeSortAlgorithm(copy(), this);
		else
			throw new IllegalStateException();
		h1=-1;
		h2=-1;
		repaint();
	}//end createAlgorithm
	
	private int[] copy(){
		int[] toRet=new int[arr.length];

		for(int i=0; i<toRet.length; i++)
			toRet[i]=arr[i];
		return toRet;
	}//end copy

	public int getH1(){
		return h1;
	}//end geth1

	public int getH2(){
		return h2;
	}//end geth2

	//pause a while
	public void pause() {
		pause(-1, -1);
	}//end pause

	//pause and draw the high mark
	public void pause(int H1) {
		pause(H1, -1);
	}//end pause

	//pause and draw the high and low marks
	public void pause(int H1, int H2) {
		h1 = H1;
		h2 = H2;

		repaint();

		try {
			Thread.sleep(SLEEP_TIME);
		}catch(InterruptedException e){
		}//end catch
	}//end pause
	
	//paints the current state of the array
	public void paintComponent(Graphics g) {

		int[] a = algorithm.getArray();
		int y=2*(a.length-1);

		// Erase old lines
		g.setColor(Color.lightGray);
		for (int i = a.length; --i >= 0; y -= 2) 
			g.drawLine(a[i], y, getSize().width, y);

		// Draw new lines
		g.setColor(Color.black);
		y=2*(a.length-1);
		for (int i = a.length; --i >= 0; y -= 2) 
			g.drawLine(0, y, a[i], y);

		//draw high and low marks
		if (h1 >= 0) {
			g.setColor(Color.red);
			y = h1 * 2 +1;
			g.drawLine(0, y, getSize().width, y);
		}//end if
		if (h2 >= 0) {
			g.setColor(Color.blue);
			y = h2 * 2 +1;
			g.drawLine(0, y, getSize().width, y);
		}//end if		 
	}//end paintComponent

	public void update(Graphics g) {
		paint(g);
	}//end update
	
	public boolean isRunning(){
		return algorithm.isRunning();
	}//end isRunning
	
	//the deprecated stop method was the only way we could get
	//the thread to stop running
	@SuppressWarnings("deprecation")
	public void sort() {
		if(thread!=null){
			thread.stop();
			createAlgorithm();
		}//end if

		thread=new Thread(algorithm);
		thread.start();
	}//end sort
	
	private static void createInOrderArray(){
		arr = new int[HEIGHT / 2];
		double f = WIDTH / (double) arr.length;
		
		for (int i = arr.length; --i >= 0;) {
			arr[i] = (int)(i * f);
		}//end for
	}//end createInOrderArray
	
	private static void reverseOrderArray(){
		arr = new int[HEIGHT / 2];
		double f = WIDTH / (double) arr.length;
		
		for(int i=0; i<arr.length; i++)
			arr[arr.length-1-i]=(int) (i*f);
	}//end reverseOrderArray
	
	private static void randomize(){
		createInOrderArray();
		
		for (int i = arr.length; --i >= 0;) 
			swap(arr, i, (int)(i * Math.random()));
	}//end randomize
	
	private static void swap(int[] a, int i, int j){
		int temp=a[i];
		a[i]=a[j];
		a[j]=temp;
	}//end swap
	
	private static void nearlySorted(){
		createInOrderArray();
		
		for(int i=0; i<arr.length/5; i++)
			swap(arr, (int)(arr.length * Math.random()), (int)(arr.length * Math.random()));
	}//end nearlySorted

	//changes array to sort based on user preference
	public static void setArrayType(String type){
		if(type.equals(DATA_TYPES[0]))
			randomize();
		else if(type.equals(DATA_TYPES[1]))
			nearlySorted();
		else if(type.equals(DATA_TYPES[2]))
			reverseOrderArray();
		else
			throw new IllegalArgumentException();
		
		for(SortItem si: sortItems)
			si.createAlgorithm();
	}//end setArrayType
	
	public static ArrayList<SortItem> getSortItems() {
		return sortItems;
	}//end getSortItems
}//end SortItem
