/*Class that represents a sorting algorithm*/
package sortGUI;

public abstract class SortAlgorithm implements Runnable{
	
	protected int[] a;					//array to sort
	private SortItem parent;			//GUI represent of sort
	private boolean isRunning=false;	//tells if sort is running
	
	public SortAlgorithm(int[] a, SortItem parent){
		this.a=a;
		this.parent=parent;
	}//end constructor

	//pause for a while
	protected void pause(){
		parent.pause(parent.getH1(), parent.getH2());
	}//end pause

	//pause and draw low mark
	protected void pause(int H1){
		parent.pause(H1, parent.getH2());
	}//end pause
	
	//pause and draw low and high marks
	protected void pause(int H1, int H2){
		parent.pause(H1, H2);
	}//end pause

	//sort the array
	public abstract void sort();
	
	public int[] getArray(){
		return a;
	}//end getArray
	
	public boolean isRunning(){
		return isRunning;
	}//end isRunning
	
	public void run(){
		isRunning=true;
		sort();
		isRunning=false;
	}//end run
}//end SortAlgorithm