/*Class to represent mergesort*/
package sortGUI;

public class MergeSortAlgorithm extends SortAlgorithm{

	public MergeSortAlgorithm(int[] a, SortItem parent){
		super(a, parent);
	}//end constructor
	
	private void sort(int a[], int lo, int hi, int temp[]){
        if (lo >= hi) 
            return;                 
        
        int mid = (lo+hi) / 2;
        
        //sort left and right halves
        sort(a, lo, mid, temp);      
        sort(a, mid+1, hi, temp);    

        int tempLo= lo;
        int tempHi= mid+1;
        
        //Merge sorted sublists
        for (int k = lo; k <= hi; k++) 
            if ((tempLo <= mid) && ((tempHi > hi) || (a[tempLo] < a[tempHi]))) {
                temp[k] = a[tempLo++];
                pause(tempLo, tempHi);
            }//end if
            else {
                temp[k] = a[tempHi++];
                pause(tempLo, tempHi);
            }//end else

        //copy them back
        for (int k = lo; k <= hi; k++) {
            a[k] = temp[k]; 
            pause(k);
        }//end for
    }//end sort

    public void sort(){
        int temp[] = new int[a.length];
        sort(a, 0, a.length-1, temp);
    }//end sort
}//end MergeSortAlgorithm
