/*Class that allows the user what data type to sort*/
package sortGUI;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

@SuppressWarnings("serial")
public class ChooseDataType extends JDialog implements ActionListener, Runnable{
	
	private SortComparisons parent;		//main GUI parent window
	private JRadioButton[] buttons;		//buttons of choices
	
	public ChooseDataType(SortComparisons owner){
		super(owner, true);
		this.parent=owner;
		buttons=new JRadioButton[SortItem.DATA_TYPES.length];
	}//end ChooseDataType
	
	private void createAndShowGUI(){
		setSize(new Dimension(200, SortItem.DATA_TYPES.length*50));
		setTitle("Choose Data Type");
		setLayout(new GridLayout(SortItem.DATA_TYPES.length, 1));
		ButtonGroup bGroup=new ButtonGroup();
		
		//add buttons of choices
		for(int i=0; i<buttons.length; i++){
			JRadioButton temp=new JRadioButton(SortItem.DATA_TYPES[i]);
			bGroup.add(temp);
			add(temp);
			temp.addActionListener(this);
			temp.addActionListener(parent);
			buttons[i]=temp;
		}//end for
		
		setLocationRelativeTo(null);
		setVisible(true);
	}//end createAndShowGUI
	
	@Override
	public void run() {
		createAndShowGUI();
	}//end run
	
	//close window when a choice is selected
	public void actionPerformed(ActionEvent ae){
		dispose();
	}//end actionPerformed
}//end ChooseDataType
