import java.io.File;
import java.io.FileNotFoundException;
import java.util.Scanner;


class BSTNode{
	String key;
	BSTNode left;
	BSTNode right;

	BSTNode(String s){
		key = s;
	}

	String getKey(){
		return key;
	}

	void setKey(String s){
		key=s;
	}
	
	public String toString(){
		return key;
	}
}

public class BinarySearchTree {
	BSTNode root;

	public BinarySearchTree(){
		root = null;
	}

	public void add(String s){
		root = addRecursive(root, s);
	}

	BSTNode addRecursive(BSTNode node, String s){
		if(node == null){
			return new BSTNode(s); 
		}
		if(s.equals(node.getKey())){
			//Our tree implements a set. No duplicates are allowed
			return node;
		}
		if(s.compareTo(node.getKey())<0){
			node.left = addRecursive(node.left, s);
		}
		else{
			node.right = addRecursive(node.right, s);
		}
		return node;
	}

	//Removes a stored string or does nothing if the string does not exist 
	public void remove(String s){
		root = removeRecursive(root, s);
	}

	BSTNode removeRecursive(BSTNode node, String s){
		if(node == null){
			//String not found. 
			//Do nothing (alternatively throw exception)
			return null; 
		}
		if(s.equals(node.getKey())){
			//We found the string. Now check if we are in the hard case
			if (node.left != null && node.right != null){
				BSTNode tmp = node.left;
				while (tmp.right != null)
					tmp = tmp.right;
				String newKey = tmp.getKey();
				node.setKey(newKey);
				node.left = removeRecursive(node.left, newKey);
				return node;
			}//Now the easy cases
			else if (node.left != null){
				return node.left;
			}
			else {
				return node.right;
			}
		}
		if(s.compareTo(node.getKey())<0){
			node.left = removeRecursive(node.left, s);
		}
		else{
			node.right = removeRecursive(node.right, s);
		}
		return node;
	}

	public boolean contains(String s){
		return containsRecursive(root, s);
	}
	
	boolean containsRecursive(BSTNode node, String s){
		if(node == null){
			return false; 
		}
		if(s.equals(node.getKey())){
			return true;
		}
		if(s.compareTo(node.getKey())<0){
			return containsRecursive(node.left, s);
		}
		else{
			return containsRecursive(node.right, s);
		}
	}
	
	public int size(){
		return sizeRecursive(root);
	}
	
	public int sizeRecursive(BSTNode node){
		if (node==null)
			return 0; 
		return 1+sizeRecursive(node.left)+sizeRecursive(node.right);
	}
	
	public int height(){
		return heightRecursive(root);
	}
	
	public int heightRecursive(BSTNode node){
		if (node==null)
			return 0; 
		return 1+Math.max(heightRecursive(node.left),heightRecursive(node.right));
	}
	
	public void printIn(){
		System.out.println("Inorder:");
		printInorder(root);
	}
	
	public void printPost(){
		System.out.println("\nPostorder:");
		printPostorder(root);
		System.out.println("\nExercise: Figure out the structure of the tree from the above");
	}
	
	void printInorder(BSTNode node){
		if(node == null) 
			return;
		printInorder(node.left);
		System.out.print(node+" ");
		printInorder(node.right);
	}
	
	void printPostorder(BSTNode node){
		if(node == null) 
			return;
		printPostorder(node.left);
		printPostorder(node.right);
		System.out.print(node+" ");
	}
	
	public static void main(String[] args){
		Scanner sc = null;
		try {
			sc = new Scanner(new File("words.txt"));
		} catch (FileNotFoundException e) {
			e.printStackTrace();
			return;
		}
		
		BinarySearchTree t = new BinarySearchTree();
		
		while(sc.hasNext()){
			t.add(sc.next());
		}
		
		t.printIn();
		
		t.printPost();
		
		System.out.println("Tree height: "+t.height()+" tree size: "+t.size());
		
		if(t.contains("science")){
			System.out.println("\'science\' is in our set.");
		}
		else{
			System.out.println("\'science\' is not in our set.");
			
		}

		System.out.println("Adding \'science\'.");
		t.add("science");
		
		if(t.contains("science")){
			System.out.println("\'science\' is in our set.");
		}
		else{
			System.out.println("\'science\' is not in our set.");
			
		}
		
		System.out.println("Tree height: "+t.height()+" tree size: "+t.size());
		
		System.out.println("Removing  \'matter\'.");
		t.remove("matter");
		
		System.out.println("Tree height: "+t.height()+" tree size: "+t.size());
		
		t.printIn();
		
	}
	
}