import java.util.Random;


public class AsymptoticComplexity {

	static int maxSubArraySumCubic(int[] values){	
		int currentMax = 0;
		
		for(int i=0; i<values.length; i++){
			for(int j=i; j<values.length; j++){
				int partialSum = 0; 
				for (int k=i; k<=j; k++){
					partialSum += values[k];
				}
				currentMax = Math.max(partialSum,currentMax);
			}
		}
		return currentMax;
	}
	
	static int maxSubArraySumQuadratic(int[] values){
		int[] cumulativeSum = new int[values.length+1];
		
		cumulativeSum[0] = 0;
		for(int i=0; i<values.length; i++){
			cumulativeSum[i+1] = cumulativeSum[i]+values[i];
		}
		
		int currentMax = 0;
		
		for(int i=0; i<values.length; i++){
			for(int j=i; j<values.length; j++){
				currentMax = Math.max(cumulativeSum[j+1]-cumulativeSum[i],currentMax);
			}
		}
		return currentMax;
	}
	
	static int maxSubArraySumLinear(int[] values){
		int maxsofar = 0;
		int maxhere = 0;
		for(int i = 0; i<values.length; i++){
			/* invariant: maxhere and maxsofar are accurate for values[0..i-1] */
			maxhere = Math.max(maxhere + values[i], 0);
			maxsofar = Math.max(maxsofar, maxhere);
		}
		return maxsofar;
	}
	
	static int FibonacciExponential(int n){
		if(n<=1)
			return n;
		else
			return FibonacciExponential(n-1)+FibonacciExponential(n-2);
	}
	
	static int FibonacciLinear(int n){
		int[] fibonacciCache = new int[n+1];
		FibonacciLinear (n, fibonacciCache);
		return fibonacciCache[n];
	}
	
	static int FibonacciLinear(int n, int[] cache){
		if(n<=1)
			return n;
		if(cache[n] == 0){
			cache[n]=FibonacciLinear(n-1, cache)+FibonacciLinear(n-2, cache);
		}
		return cache[n];
	}
	
	public static void main(String[] args){
		Random r = new Random();
		r.setSeed(42);
		int[] numbers= new int[4000];
		for(int i=0; i<4000; i++){
			numbers[i] = r.nextInt()%100 - 25;
		}
		System.out.println("4000 numbers, O(n)  : "+maxSubArraySumLinear(numbers));
		System.out.println("4000 numbers, O(n^2): "+maxSubArraySumQuadratic(numbers));
		System.out.println("4000 numbers, O(n^3): "+maxSubArraySumCubic(numbers));		
		
		System.out.println("Scaling up the problem (and dropping the cubic algorithm)");
		numbers= new int[100000];
		for(int i=0; i<100000; i++){
			numbers[i] = r.nextInt()%100 - 25;
		}
		System.out.println("100000 numbers, O(n)  : "+maxSubArraySumLinear(numbers));
		System.out.println("100000 numbers, O(n^2): "+maxSubArraySumQuadratic(numbers));
		
		System.out.println("Fibonacci Linear     : Fib(40) = "+FibonacciLinear(42));
		System.out.println("Fibonacci Exponential: Fib(40) = "+FibonacciExponential(42));
	}
}
