package doublyLinked;

import java.io.BufferedReader;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.HashMap;

import doublyLinked.DLNode;


public class SortedList 
{	
	private DLNode head, tail;
	public SortedList(String[] names)
	{
		if (names != null && names.length>0)
		{
			head = new DLNode(names[0]);
			tail = head;
		}
		for (int i = 1; i<names.length; i++)
		{
			DLNode newNode = new DLNode(names[i]);
			this.insert(newNode);
		}
	}
	public DLNode findNode(String name)
	{
		DLNode curr = head;
		while(curr!=null)
		{
			if (curr.getValue().equals(name))
				return curr;
			curr = curr.getNext();
		}
		return null;
	}
	public DLNode remove(DLNode n)
	{
		if (n.equals(head))
		{
			head = n.getNext();
		}
		if (n.equals(tail))
		{
			tail = n.getPrev();
		}
		DLNode prev = n.getPrev();
		DLNode next = n.getNext();
		if (prev!=null)
			prev.setNext(next);
		if (next!=null)
			next.setPrev(prev);
		n.setNext(null);
		n.setPrev(null);
		return n;
	}
	public void insert(DLNode newNode)
	{		
		DLNode next = head;
		while(next!=null && newNode.getValue().compareTo(next.getValue())>0)
		{
			next = next.getNext();
		}
		DLNode prev = null;
		if(next == null)
		{
			prev = tail;
			tail = newNode;
		}
		else
		{
			prev = next.getPrev();
			if(next.equals(head))
			{
				prev = null;			
				head = newNode;
			}
		}
		
		if (prev!=null)
			prev.setNext(newNode);
		if(next!=null)
			next.setPrev(newNode);
		newNode.setPrev(prev);
		newNode.setNext(next);
		
	}
	public DLNode getFirst(){
		return head;
	}
	public DLNode getLast(){
		return tail;
	}
	
	public String toString()
	{
		return this.head.getList();
	}
	public static void main(String[] args)
	{
		try{
			//although mildly insane, we will use a list to
			//read a file to write in a list--but it's for convenience.
			//read in file of names.
			ArrayList<String> arr = new ArrayList<String>();
			String nm = "names.txt";
			if (args.length>0)
				nm = args[0];
			BufferedReader rd = new BufferedReader(new FileReader(nm));
			String line = rd.readLine();
			while(line!=null){
				arr.add(line);
				line = rd.readLine();
			}
			
			SortedList lst = new SortedList(arr.toArray(new String[arr.size()]));
			System.out.println(lst);
			DLNode n1 = lst.remove(lst.getFirst());
			System.out.println(lst);
			lst.insert(n1);
			System.out.println(lst);
			DLNode n2 = lst.findNode("Edgar");
			lst.remove(n2);
			System.out.println(lst);
			DLNode n3 = lst.findNode("Cara");
			DLNode n4 = new DLNode("Zavier");
			lst.insert(n4);
			System.out.println(lst);
			DLNode n5 = lst.remove(n1);
			System.out.println(lst);
			lst.insert(n5);
			System.out.println(lst);
		}
		catch(Exception e){
			e.printStackTrace();
		}
	}
}
