package doublyLinked;

public class DLNode 
{
	
	private DLNode prev, next;
	private String value;
	//ignore this--it's just for the GUI.
	
	public DLNode(String value, DLNode prev, DLNode next)
	{
		this.value = value;
		this.prev = prev;
		this.next = next;
		//NOW: this is to ensure our list is consistent.
		//we will ensure that if prev/ null is not null,
		//this is set as prev/next.
		if (prev!=null)
		{
			prev.setNext(this);
		}
		if (next != null)
		{
			next.setPrev(this);
		}
	}
	public DLNode(String value)
	{
		this(value, null, null);
	}

	/*
	 * Setters: note that once a value is initialized, 
	 * that's it--you can't change it.
	 */
	public void setPrev(DLNode prev) {
		this.prev = prev;
	}
	public void setNext(DLNode next) {
		this.next = next;
	}

	/*
	 * Getters
	 */
	public DLNode getPrev() {
		return prev;
	}
	public DLNode getNext() {
		return next;
	}
	public String getValue() {
		return value;
	}
	
	public String toString()
	{
		return "["+value+"]";
	}
	public String getList()
	{
		if (this.next==null)
			return this.toString();
		else
			return this.toString()+"<=>"+this.next.getList();
	}
}
