package doublyLinked;

import java.io.BufferedReader;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.HashMap;

import doublyLinked.DLNode;


public class DLList 
{	
	private DLNode head, tail;
	public DLList(String[] names)
	{
		DLNode curr=null;
		if (names != null && names.length>0)
		{
			head = new DLNode(names[0], null, null);
			curr = head;
		}
		for (int i = 1; i<names.length; i++)
		{
			DLNode newNode = new DLNode(names[i],curr, null);
			curr = newNode;
		}
		tail = curr;
	}
	public void addToFront(DLNode newNode)
	{
		head.setPrev(newNode);
		newNode.setNext(head);
		head = newNode;
	}
	public void addToBack(DLNode newNode)
	{
		tail.setNext(newNode);
		newNode.setPrev(tail);
		tail = newNode;
	}
	public DLNode findNode(String name)
	{
		DLNode curr = head;
		while(curr!=null)
		{
			if (curr.getValue().equals(name))
				return curr;
			curr = curr.getNext();
		}
		return null;
	}
	public DLNode removeFirst()
	{
		DLNode ret = head;
		DLNode newHead = ret.getNext();
		newHead.setPrev(null);
		ret.setNext(null);
		head = newHead;
		return ret;
	}
	public DLNode removeLast()
	{
		DLNode ret = tail;
		DLNode newTail = ret.getPrev();
		newTail.setNext(null);
		ret.setPrev(null);
		tail = newTail;
		return ret;
	}
	public DLNode remove(DLNode n)
	{
		if (n.equals(head))
		{
			return removeFirst();
		}
		if (n.equals(tail))
		{
			return removeLast();
		}
		DLNode prev = n.getPrev();
		DLNode next = n.getNext();
		if (prev!=null)
			prev.setNext(next);
		if (next!=null)
			next.setPrev(prev);
		n.setNext(null);
		n.setPrev(null);
		return n;
	}
	public void insertAfter(DLNode newNode, DLNode listPt)
	{		
		if (listPt.equals(tail))
			tail = newNode;
		DLNode oldNext = listPt.getNext();
		listPt.setNext(newNode);
		newNode.setPrev(listPt);
		newNode.setNext(oldNext);
		if(oldNext!=null)
			oldNext.setPrev(newNode);
		
	}
	public DLNode getFirst(){
		return head;
	}
	public DLNode getLast(){
		return tail;
	}
	
	public String toString()
	{
		return this.head.getList();
	}
	public static void main(String[] args)
	{
		try{
			//although mildly insane, we will use a list to
			//read a file to write in a list--but it's for convenience.
			//read in file of names.
			ArrayList<String> arr = new ArrayList<String>();
			String nm = "names.txt";
			if (args.length>0)
				nm = args[0];
			BufferedReader rd = new BufferedReader(new FileReader(nm));
			String line = rd.readLine();
			while(line!=null){
				arr.add(line);
				line = rd.readLine();
			}
			
			DLList lst = new DLList(arr.toArray(new String[arr.size()]));
			System.out.println(lst);
			DLNode n1 = lst.removeFirst();
			System.out.println(lst);
			lst.addToBack(n1);
			System.out.println(lst);
			DLNode n2 = lst.findNode("Edgar");
			lst.remove(n2);
			System.out.println(lst);
			DLNode n3 = lst.findNode("Cara");
			DLNode n4 = new DLNode("Zavier");
			lst.insertAfter(n4, n3);
			System.out.println(lst);
			DLNode n5 = lst.remove(n1);
			System.out.println(lst);
			lst.insertAfter(n5, lst.getLast());
			System.out.println(lst);
		}
		catch(Exception e){
			e.printStackTrace();
		}
	}
}
