package circularLinked;

import java.io.BufferedReader;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.HashMap;

public class NormalList
{	
	private Node head, tail;
	public NormalList(String[] names)
	{
		Node curr=null;
		if (names != null && names.length>0)
		{
			head = new Node(names[0]);
			curr = head;
		}
		for (int i = 1; i<names.length; i++)
		{
			Node newNode = new Node(names[i]);
			curr.setNext(newNode);
			curr = newNode;
		}
		tail = curr;
	}
	public void addToFront(Node newNode)
	{
		newNode.setNext(head);
		head = newNode;
	}
	public void addToBack(Node newNode)
	{
		tail.setNext(newNode);
		tail = newNode;
	}
	public Node findNode(String name)
	{
		Node curr = head;
		while(curr!=null)
		{
			if (curr.getValue().equals(name))
				return curr;
			curr = curr.getNext();
		}
		return null;
	}
	public Node removeFirst()
	{
		Node ret = head;
		Node newHead = ret.getNext();
		ret.setNext(null);
		head = newHead;
		return ret;
	}
	/**
	 * This is HARD in a singly linked list.
	 * @return
	 */
	public Node removeLast()
	{
		Node ret = tail;
		Node newTail = head;
		while(newTail.getNext()!=tail)
		{
			newTail = newTail.getNext();
		}
		newTail.setNext(null);
		tail = newTail;
		return ret;
	}
	public Node remove(Node n)
	{
		Node next = n.getNext();
		Node prev = head;
		while(prev.getNext()!=n)
		{
			prev = prev.getNext();
		}
		prev.setNext(next);
		n.setNext(null);
		if (n.equals(head))
			head = next;
		if (n.equals(tail))
			tail = prev;
		return n;
	}
	public void insertAfter(Node newNode, Node oldNode)
	{
		Node oldNext = oldNode.getNext();
		oldNode.setNext(newNode);
		newNode.setNext(oldNext);
		if (oldNode.equals(tail))
			tail = newNode;
	}
	
	public String toString()
	{
		return this.head.getList();
	}
	public static void main(String[] args)
	{
		try{
			//although mildly insane, we will use a list to
			//read a file to write in a list--but it's for convenience.
			//read in file of names.
			ArrayList<String> arr = new ArrayList<String>();
			String nm = "names.txt";
			if (args.length>0)
				nm = args[0];
			BufferedReader rd = new BufferedReader(new FileReader(nm));
			String line = rd.readLine();
			while(line!=null){
				arr.add(line);
				line = rd.readLine();
			}
			
			NormalList lst = new NormalList(arr.toArray(new String[arr.size()]));
			System.out.println(lst);
			Node n1 = lst.removeFirst();
			System.out.println(lst);
			lst.addToBack(n1);
			System.out.println(lst);
			Node n2 = lst.findNode("Edgar");
			lst.remove(n2);
			System.out.println(lst);
			Node n3 = lst.findNode("Cara");
			Node n4 = new Node("Zavier");
			lst.insertAfter(n4, n3);
			System.out.println(lst);
		}
		catch(Exception e){
			e.printStackTrace();
		}
	}
}
