package circularLinked;

public class Node 
{
	
	private Node next;
	private String value;
	//ignore this--it's just for the GUI.
	
	public Node(String value, Node next)
	{
		this.value = value;
		this.next = next;
	}
	public Node(String value)
	{
		this(value, null);
	}

	/*
	 * Setters: note that once a value is initialized, 
	 * that's it--you can't change it.
	 */
	public void setNext(Node next) {
		this.next = next;
	}

	/*
	 * Getters
	 */
	public Node getNext() {
		return next;
	}
	public String getValue() {
		return value;
	}
	
	public String toString()
	{
		return "["+value+"]";
	}
	public String getList()
	{
		if (this.next==null)
			return this.toString();
		else
			return this.toString()+"->"+this.next.getList();
	}
}
