package circularLinked;

import java.io.BufferedReader;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.HashMap;

public class CircularList
{	
	private Node pointerIn;
	
	public CircularList(String[] names)
	{
		Node curr=null;
		if (names != null && names.length>0)
		{
			pointerIn = new Node(names[0]);
			curr = pointerIn;
		}
		for (int i = 1; i<names.length; i++)
		{
			Node newNode = new Node(names[i]);
			curr.setNext(newNode);
			curr = newNode;
		}
		curr.setNext(pointerIn);
	}
	public Node findNode(String name)
	{
		if (pointerIn.getValue().equals(name))
			return pointerIn;
		Node curr = pointerIn.getNext();
		
		while(curr!=pointerIn)
		{
			if (curr.getValue().equals(name))
				return curr;
			curr = curr.getNext();
		}
		return null;
	}
	
	public Node remove(Node n)
	{
		Node next = n.getNext();
		Node prev =  pointerIn;
		while(prev.getNext()!=n)
		{
			prev = prev.getNext();
		}
		prev.setNext(next);
		n.setNext(null);
		if (n.equals(pointerIn))
			pointerIn = next;
		return n;
	}
	public void insertAfter(Node newNode, Node oldNode)
	{
		Node oldNext = oldNode.getNext();
		oldNode.setNext(newNode);
		newNode.setNext(oldNext);
	}
	
	public String toString()
	{
		String s = "...->";
		Node curr = pointerIn;
		do{
			s+=curr.toString()+"->";
			curr = curr.getNext();
		}while(curr!=pointerIn);
		s+="...";
		return s;
	}
	public static void main(String[] args)
	{
		try{
			//although mildly insane, we will use a list to
			//read a file to write in a list--but it's for convenience.
			//read in file of names.
			ArrayList<String> arr = new ArrayList<String>();
			String nm = "names.txt";
			if (args.length>0)
				nm = args[0];
			BufferedReader rd = new BufferedReader(new FileReader(nm));
			String line = rd.readLine();
			while(line!=null){
				arr.add(line);
				line = rd.readLine();
			}
			
			CircularList lst = new CircularList(arr.toArray(new String[arr.size()]));
			System.out.println(lst);
			Node n1 = lst.findNode("Alicia");
			lst.remove(n1);
			System.out.println(lst);
			Node n2 = lst.findNode("Edgar");
			lst.remove(n2);
			System.out.println(lst);
			Node n3 = lst.findNode("Cara");
			Node n4 = new Node("Zavier");
			lst.insertAfter(n4, n3);
			System.out.println(lst);
		}
		catch(Exception e){
			e.printStackTrace();
		}
	}
}
