import java.util.Arrays;


public class Chamber 
{
	private Chamber[] passagesTo;
	private String name;
	private boolean isExit;
	
	//ignore this--it's just for the gui.
	private Object visCell;
	/**
	 * constructor, where you can specify the exit.
	 * @param name
	 * @param passagesTo
	 * @param isExit
	 */
	public Chamber(String name, Chamber[] passagesTo, boolean isExit)
	{
		this.passagesTo = passagesTo;
		this.name = name;
		this.isExit = isExit;
	}
	/**
	 * constructor which assumes not an exit--note that this is a good
	 * example of overloading; I have 2 constructors with different signatures.
	 * @param name
	 * @param passagesTo
	 * @param isExit
	 */
	public Chamber(String name, Chamber[] passagesTo)
	{
		this(name, passagesTo, false);
	}
	/**
	 * Returns a _shallow_ copy of the chamber array.
	 * @return
	 */
	public Chamber[] getChambers()
	{
		if (passagesTo==null)
			return null;
		return Arrays.copyOf(passagesTo, passagesTo.length);
	}
	/**
	 * is this cave an exit?
	 * @return
	 */
	public boolean isExit()
	{
		return this.isExit;
	}
	/**
	 * Return the cavern's name.
	 * @return
	 */
	public String getName()
	{
		return name;
	}
	
	/**
	 * Ignore this--it's just for the gui.
	 * @param cell
	 */
	public void setCell(Object cell)
	{
		visCell = cell;
	}
	/**
	 * ignore this, it's just for the gui.
	 * @return
	 */
	public Object getCell()
	{
		return visCell;
	}
}
