import java.util.Random;


public class CaveRecursion {

	private Graphlet frame;
	public CaveRecursion(Graphlet frame)
	{
		this.frame = frame;
	}
	/**
	 * Recursive function to find a string representation
	 * of the path out of the cave.
	 * Finds the first exit in a "depth first search" and returns
	 * a string path to it.
	 * 
	 * Else returns null.
	 * @param ch
	 * @return
	 */
	public String getExitPath(Chamber ch)
	{
		//base cases
		//base case 1: (good base case) found an exit
		if (ch.isExit())
			return ch.getName();
		//base case 2: (bad base case) found a dead end (no more passages to explore)
		if (ch.getChambers()==null || ch.getChambers().length ==0)
			return null;
		//recursive step: check each passage in turn; as soon as one is
		//found which provides an exit, return the path to it.
		for(Chamber subCh: ch.getChambers())
		{
			//try to explore the subchamber.
			
			//ignore this--it's just for the GUI!!
			//we have a GUI--so first show the GUI display(ignore these details)
			this.frame.movePerson(subCh);
			//this is the actual recursion you need to care about
			String s = getExitPath(subCh);
			//remember that we return null if no path is found; else a string to the path.
			if (s!=null)
			{
				return ch.getName()+", "+s;
			}
			//ignore this--it's just for the GUI!!
			//we have a GUI--so first show the GUI display(ignore these details)
			this.frame.movePerson(ch);
		}
		return null;
	}
	public static void main(String[] args)
	{
		System.out.println("You're in Cave 1, when there is a rockfall " +
				"and the entrance collapses!  \n" +
				"Taking your (green?) torch in hand, you bravely explore the caves " +
				"for an exit...");
		
		//adding "true" to any of these makes the chamber an exit,
		//just like our code in class.
		Chamber c10 = new Chamber("10",null,true);
		Chamber c9 = new Chamber("9", null);
		Chamber c8 = new Chamber("8", new Chamber[] {c9,c10});
		Chamber c7 = new Chamber("7",null);
		Chamber c6 = new Chamber("6",null);
		Chamber c5 = new Chamber("5",null);
		Chamber c4 = new Chamber("4",new Chamber[] {c5,c6,c7});
		Chamber c3 = new Chamber("3",new Chamber[]{c4,c8});
		Chamber c2 = new Chamber("2",null);
		Chamber c1 = new Chamber("1",new Chamber[]{c2,c3});
		Graphlet frame = new Graphlet(c1);
		CaveRecursion cave = new CaveRecursion(frame);
		String s = cave.getExitPath(c1);
		if (s!=null)
			System.out.println("You've escaped! "+s);
		if (s==null)
			System.out.println("Oh no! No exit! You're stuck in here FOREVER!");
		
	}
}
