/*
 * Decompiled with CFR 0.152.
 */
package com.mxgraph.view;

import com.mxgraph.model.mxGeometry;
import com.mxgraph.model.mxGraphModel;
import com.mxgraph.model.mxIGraphModel;
import com.mxgraph.util.mxConstants;
import com.mxgraph.util.mxEventObject;
import com.mxgraph.util.mxEventSource;
import com.mxgraph.util.mxPoint;
import com.mxgraph.util.mxRectangle;
import com.mxgraph.util.mxUndoableEdit;
import com.mxgraph.util.mxUtils;
import com.mxgraph.view.mxCellState;
import com.mxgraph.view.mxConnectionConstraint;
import com.mxgraph.view.mxEdgeStyle;
import com.mxgraph.view.mxGraph;
import com.mxgraph.view.mxPerimeter;
import com.mxgraph.view.mxStyleRegistry;
import java.awt.geom.Line2D;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;

public class mxGraphView
extends mxEventSource {
    private static mxPoint EMPTY_POINT = new mxPoint();
    protected mxGraph graph;
    protected Object currentRoot = null;
    protected mxRectangle graphBounds = new mxRectangle();
    protected double scale = 1.0;
    protected mxPoint translate = new mxPoint(0.0, 0.0);
    protected Hashtable<Object, mxCellState> states = new Hashtable();

    public mxGraphView(mxGraph graph) {
        this.graph = graph;
    }

    public mxGraph getGraph() {
        return this.graph;
    }

    public Hashtable<Object, mxCellState> getStates() {
        return this.states;
    }

    public void setStates(Hashtable<Object, mxCellState> states) {
        this.states = states;
    }

    public mxRectangle getGraphBounds() {
        return this.graphBounds;
    }

    public void setGraphBounds(mxRectangle value) {
        this.graphBounds = value;
    }

    public Object getCurrentRoot() {
        return this.currentRoot;
    }

    public Object setCurrentRoot(Object root) {
        if (this.currentRoot != root) {
            mxCurrentRootChange change = new mxCurrentRootChange(this, root);
            change.execute();
            mxUndoableEdit edit = new mxUndoableEdit(this, false);
            edit.add(change);
            this.fireEvent(new mxEventObject("undo", "edit", edit));
        }
        return root;
    }

    public void scaleAndTranslate(double scale, double dx, double dy) {
        double previousScale = this.scale;
        Object previousTranslate = this.translate.clone();
        if (scale != this.scale || dx != this.translate.getX() || dy != this.translate.getY()) {
            this.scale = scale;
            this.translate = new mxPoint(dx, dy);
            if (this.isEventsEnabled()) {
                this.revalidate();
            }
        }
        this.fireEvent(new mxEventObject("scaleAndTranslate", "scale", scale, "previousScale", previousScale, "translate", this.translate, "previousTranslate", previousTranslate));
    }

    public double getScale() {
        return this.scale;
    }

    public void setScale(double value) {
        double previousScale = this.scale;
        if (this.scale != value) {
            this.scale = value;
            if (this.isEventsEnabled()) {
                this.revalidate();
            }
        }
        this.fireEvent(new mxEventObject("scale", "scale", this.scale, "previousScale", previousScale));
    }

    public mxPoint getTranslate() {
        return this.translate;
    }

    public void setTranslate(mxPoint value) {
        Object previousTranslate = this.translate.clone();
        if (value != null && (value.getX() != this.translate.getX() || value.getY() != this.translate.getY())) {
            this.translate = value;
            if (this.isEventsEnabled()) {
                this.revalidate();
            }
        }
        this.fireEvent(new mxEventObject("translate", "translate", this.translate, "previousTranslate", previousTranslate));
    }

    public mxRectangle getBounds(Object[] cells) {
        return this.getBounds(cells, false);
    }

    public mxRectangle getBoundingBox(Object[] cells) {
        return this.getBounds(cells, true);
    }

    public mxRectangle getBounds(Object[] cells, boolean boundingBox) {
        mxRectangle result = null;
        if (cells != null && cells.length > 0) {
            mxIGraphModel model = this.graph.getModel();
            int i = 0;
            while (i < cells.length) {
                mxCellState state;
                if ((model.isVertex(cells[i]) || model.isEdge(cells[i])) && (state = this.getState(cells[i])) != null) {
                    mxRectangle tmp;
                    mxRectangle mxRectangle2 = tmp = boundingBox ? state.getBoundingBox() : state;
                    if (tmp != null) {
                        if (result == null) {
                            result = new mxRectangle(tmp);
                        } else {
                            result.add(tmp);
                        }
                    }
                }
                ++i;
            }
        }
        return result;
    }

    public void reload() {
        this.states.clear();
        this.validate();
    }

    public void revalidate() {
        this.invalidate();
        this.validate();
    }

    public void invalidate() {
        this.invalidate(null);
    }

    public void clear(Object cell, boolean force, boolean recurse) {
        this.removeState(cell);
        if (recurse && (force || cell != this.currentRoot)) {
            mxIGraphModel model = this.graph.getModel();
            int childCount = model.getChildCount(cell);
            int i = 0;
            while (i < childCount) {
                this.clear(model.getChildAt(cell, i), force, recurse);
                ++i;
            }
        } else {
            this.invalidate(cell);
        }
    }

    public void invalidate(Object cell) {
        mxIGraphModel model = this.graph.getModel();
        mxCellState state = this.getState(cell = cell != null ? cell : model.getRoot());
        if (state == null || !state.isInvalid()) {
            if (state != null) {
                state.setInvalid(true);
            }
            int childCount = model.getChildCount(cell);
            int i = 0;
            while (i < childCount) {
                Object child = model.getChildAt(cell, i);
                this.invalidate(child);
                ++i;
            }
            int edgeCount = model.getEdgeCount(cell);
            int i2 = 0;
            while (i2 < edgeCount) {
                this.invalidate(model.getEdgeAt(cell, i2));
                ++i2;
            }
        }
    }

    public void validate() {
        Object cell;
        Object object = cell = this.currentRoot != null ? this.currentRoot : this.graph.getModel().getRoot();
        if (cell != null) {
            this.validateBounds(null, cell);
            mxRectangle bounds = this.validatePoints(null, cell);
            if (bounds == null) {
                bounds = new mxRectangle();
            }
            this.setGraphBounds(bounds);
        }
    }

    public void validateBounds(mxCellState parentState, Object cell) {
        mxIGraphModel model = this.graph.getModel();
        mxCellState state = this.getState(cell, true);
        if (state != null && state.isInvalid()) {
            if (!this.graph.isCellVisible(cell)) {
                this.removeState(cell);
            } else if (cell != this.currentRoot && parentState != null) {
                state.getAbsoluteOffset().setX(0.0);
                state.getAbsoluteOffset().setY(0.0);
                state.setOrigin(new mxPoint(parentState.getOrigin()));
                mxGeometry geo = this.graph.getCellGeometry(cell);
                if (geo != null) {
                    if (!model.isEdge(cell)) {
                        mxPoint origin = state.getOrigin();
                        mxPoint offset = geo.getOffset();
                        if (offset == null) {
                            offset = EMPTY_POINT;
                        }
                        if (geo.isRelative()) {
                            origin.setX(origin.getX() + geo.getX() * parentState.getWidth() / this.scale + offset.getX());
                            origin.setY(origin.getY() + geo.getY() * parentState.getHeight() / this.scale + offset.getY());
                        } else {
                            state.setAbsoluteOffset(new mxPoint(this.scale * offset.getX(), this.scale * offset.getY()));
                            origin.setX(origin.getX() + geo.getX());
                            origin.setY(origin.getY() + geo.getY());
                        }
                    }
                    state.setX(this.scale * (this.translate.getX() + state.getOrigin().getX()));
                    state.setY(this.scale * (this.translate.getY() + state.getOrigin().getY()));
                    state.setWidth(this.scale * geo.getWidth());
                    state.setHeight(this.scale * geo.getHeight());
                    if (model.isVertex(cell)) {
                        this.updateVertexLabelOffset(state);
                    }
                }
            }
            mxPoint offset = this.graph.getChildOffsetForCell(cell);
            if (offset != null) {
                state.getOrigin().setX(state.getOrigin().getX() + offset.getX());
                state.getOrigin().setY(state.getOrigin().getY() + offset.getY());
            }
        }
        if (!(state == null || this.graph.isCellCollapsed(cell) && cell != this.currentRoot)) {
            int childCount = model.getChildCount(cell);
            int i = 0;
            while (i < childCount) {
                this.validateBounds(state, model.getChildAt(cell, i));
                ++i;
            }
        }
    }

    public void updateVertexLabelOffset(mxCellState state) {
        String horizontal = mxUtils.getString(state.getStyle(), mxConstants.STYLE_LABEL_POSITION, "center");
        if (horizontal.equals("left")) {
            state.absoluteOffset.setX(state.absoluteOffset.getX() - state.getWidth());
        } else if (horizontal.equals("right")) {
            state.absoluteOffset.setX(state.absoluteOffset.getX() + state.getWidth());
        }
        String vertical = mxUtils.getString(state.getStyle(), mxConstants.STYLE_VERTICAL_LABEL_POSITION, "middle");
        if (vertical.equals("top")) {
            state.absoluteOffset.setY(state.absoluteOffset.getY() - state.getHeight());
        } else if (vertical.equals("bottom")) {
            state.absoluteOffset.setY(state.absoluteOffset.getY() + state.getHeight());
        }
    }

    public mxRectangle validatePoints(mxCellState parentState, Object cell) {
        mxIGraphModel model = this.graph.getModel();
        mxCellState state = this.getState(cell);
        mxRectangle bbox = null;
        if (state != null) {
            if (state.isInvalid()) {
                mxPoint origin;
                mxGeometry geo = this.graph.getCellGeometry(cell);
                if (geo != null && model.isEdge(cell)) {
                    mxCellState target;
                    mxCellState source = this.getState(this.getVisibleTerminal(cell, true));
                    if (source != null && model.isEdge(source.getCell()) && !model.isAncestor(source, cell)) {
                        mxCellState tmp = this.getState(model.getParent(source.getCell()));
                        this.validatePoints(tmp, source);
                    }
                    if ((target = this.getState(this.getVisibleTerminal(cell, false))) != null && model.isEdge(target.getCell()) && !model.isAncestor(target, cell)) {
                        mxCellState tmp = this.getState(model.getParent(target.getCell()));
                        this.validatePoints(tmp, target);
                    }
                    this.updateFixedTerminalPoints(state, source, target);
                    this.updatePoints(state, geo.getPoints(), source, target);
                    this.updateFloatingTerminalPoints(state, source, target);
                    this.updateEdgeBounds(state);
                    state.setAbsoluteOffset(this.getPoint(state, geo));
                } else if (geo != null && geo.isRelative() && parentState != null && model.isEdge(parentState.getCell()) && (origin = this.getPoint(parentState, geo)) != null) {
                    state.setX(origin.getX());
                    state.setY(origin.getY());
                    origin.setX(origin.getX() / this.scale - this.translate.getX());
                    origin.setY(origin.getY() / this.scale - this.translate.getY());
                    state.setOrigin(origin);
                    this.childMoved(parentState, state);
                }
                state.setInvalid(false);
            }
            if (model.isEdge(cell) || model.isVertex(cell)) {
                this.updateLabelBounds(state);
                bbox = new mxRectangle(this.updateBoundingBox(state));
            }
        }
        if (!(state == null || this.graph.isCellCollapsed(cell) && cell != this.currentRoot)) {
            int childCount = model.getChildCount(cell);
            int i = 0;
            while (i < childCount) {
                Object child = model.getChildAt(cell, i);
                mxRectangle bounds = this.validatePoints(state, child);
                if (bounds != null) {
                    if (bbox == null) {
                        bbox = bounds;
                    } else {
                        bbox.add(bounds);
                    }
                }
                ++i;
            }
        }
        return bbox;
    }

    protected void childMoved(mxCellState parent, mxCellState child) {
        Object cell = child.getCell();
        if (!this.graph.isCellCollapsed(cell) || cell == this.currentRoot) {
            mxIGraphModel model = this.graph.getModel();
            int childCount = model.getChildCount(cell);
            int i = 0;
            while (i < childCount) {
                this.validateBounds(child, model.getChildAt(cell, i));
                ++i;
            }
        }
    }

    public void updateLabelBounds(mxCellState state) {
        Object cell = state.getCell();
        Map<String, Object> style = state.getStyle();
        if (mxUtils.getString(style, mxConstants.STYLE_OVERFLOW, "").equals("fill")) {
            state.setLabelBounds(new mxRectangle(state));
        } else {
            String label = this.graph.getLabel(cell);
            mxCellState vertexBounds = !this.graph.getModel().isEdge(cell) ? state : null;
            state.setLabelBounds(mxUtils.getLabelPaintBounds(label, style, this.graph.isHtmlLabel(cell), state.getAbsoluteOffset(), vertexBounds, this.scale));
        }
    }

    public mxRectangle updateBoundingBox(mxCellState state) {
        mxRectangle rect = new mxRectangle(state);
        Map<String, Object> style = state.getStyle();
        double strokeWidth = Math.max(1L, Math.round((double)mxUtils.getInt(style, mxConstants.STYLE_STROKEWIDTH, 1) * this.scale));
        strokeWidth -= Math.max(1.0, strokeWidth / 2.0);
        if (this.graph.getModel().isEdge(state.getCell())) {
            int ms = 0;
            if (style.containsKey(mxConstants.STYLE_ENDARROW) || style.containsKey(mxConstants.STYLE_STARTARROW)) {
                ms = (int)Math.round((double)mxConstants.DEFAULT_MARKERSIZE * this.scale);
            }
            rect.grow((double)ms + strokeWidth);
            if (mxUtils.getString(style, mxConstants.STYLE_SHAPE, "").equals("arrow")) {
                rect.grow(mxConstants.ARROW_WIDTH / 2);
            }
        } else {
            rect.grow(strokeWidth);
        }
        if (mxUtils.isTrue(style, mxConstants.STYLE_SHADOW)) {
            rect.setWidth(rect.getWidth() + (double)mxConstants.SHADOW_OFFSETX);
            rect.setHeight(rect.getHeight() + (double)mxConstants.SHADOW_OFFSETY);
        }
        if (mxUtils.getString(style, mxConstants.STYLE_SHAPE, "").equals("label") && mxUtils.getString(style, mxConstants.STYLE_IMAGE) != null) {
            double w = (double)mxUtils.getInt(style, mxConstants.STYLE_IMAGE_WIDTH, mxConstants.DEFAULT_IMAGESIZE) * this.scale;
            double h = (double)mxUtils.getInt(style, mxConstants.STYLE_IMAGE_HEIGHT, mxConstants.DEFAULT_IMAGESIZE) * this.scale;
            double x = state.getX();
            double y = 0.0;
            String imgAlign = mxUtils.getString(style, mxConstants.STYLE_IMAGE_ALIGN, "left");
            String imgValign = mxUtils.getString(style, mxConstants.STYLE_IMAGE_VERTICAL_ALIGN, "middle");
            if (imgAlign.equals("right")) {
                x += state.getWidth() - w;
            } else if (imgAlign.equals("center")) {
                x += (state.getWidth() - w) / 2.0;
            }
            y = imgValign.equals("top") ? state.getY() : (imgValign.equals("bottom") ? state.getY() + state.getHeight() - h : state.getY() + (state.getHeight() - h) / 2.0);
            rect.add(new mxRectangle(x, y, w, h));
        }
        double rotation = mxUtils.getDouble(style, mxConstants.STYLE_ROTATION);
        mxRectangle bbox = mxUtils.getBoundingBox(rect, rotation);
        rect.add(bbox);
        if (!this.graph.isLabelClipped(state.getCell())) {
            rect.add(state.getLabelBounds());
        }
        state.setBoundingBox(rect);
        return rect;
    }

    public void updateFixedTerminalPoints(mxCellState edge, mxCellState source, mxCellState target) {
        this.updateFixedTerminalPoint(edge, source, true, this.graph.getConnectionConstraint(edge, source, true));
        this.updateFixedTerminalPoint(edge, target, false, this.graph.getConnectionConstraint(edge, target, false));
    }

    public void updateFixedTerminalPoint(mxCellState edge, mxCellState terminal, boolean source, mxConnectionConstraint constraint) {
        mxPoint pt = null;
        if (constraint != null) {
            pt = this.graph.getConnectionPoint(terminal, constraint);
        }
        if (pt == null && terminal == null) {
            mxPoint orig = edge.getOrigin();
            mxGeometry geo = this.graph.getCellGeometry(edge.cell);
            pt = geo.getTerminalPoint(source);
            if (pt != null) {
                pt = new mxPoint(this.scale * (this.translate.getX() + pt.getX() + orig.getX()), this.scale * (this.translate.getY() + pt.getY() + orig.getY()));
            }
        }
        edge.setAbsoluteTerminalPoint(pt, source);
    }

    public void updatePoints(mxCellState edge, List<mxPoint> points, mxCellState source, mxCellState target) {
        if (edge != null) {
            ArrayList<mxPoint> pts = new ArrayList<mxPoint>();
            pts.add(edge.getAbsolutePoint(0));
            mxEdgeStyle.mxEdgeStyleFunction edgeStyle = this.getEdgeStyle(edge, points, source, target);
            if (edgeStyle != null) {
                mxCellState src = this.getTerminalPort(edge, source, true);
                mxCellState trg = this.getTerminalPort(edge, target, false);
                edgeStyle.apply(edge, src, trg, points, pts);
            } else if (points != null) {
                int i = 0;
                while (i < points.size()) {
                    pts.add(this.transformControlPoint(edge, points.get(i)));
                    ++i;
                }
            }
            pts.add(edge.getAbsolutePoint(edge.getAbsolutePointCount() - 1));
            edge.setAbsolutePoints(pts);
        }
    }

    public mxPoint transformControlPoint(mxCellState state, mxPoint pt) {
        mxPoint origin = state.getOrigin();
        return new mxPoint(this.scale * (pt.getX() + this.translate.getX() + origin.getX()), this.scale * (pt.getY() + this.translate.getY() + origin.getY()));
    }

    public mxEdgeStyle.mxEdgeStyleFunction getEdgeStyle(mxCellState edge, List<mxPoint> points, Object source, Object target) {
        Object edgeStyle = null;
        if (source != null && source == target) {
            edgeStyle = edge.getStyle().get(mxConstants.STYLE_LOOP);
            if (edgeStyle == null) {
                edgeStyle = this.graph.getDefaultLoopStyle();
            }
        } else if (!mxUtils.isTrue(edge.getStyle(), mxConstants.STYLE_NOEDGESTYLE, false)) {
            edgeStyle = edge.getStyle().get(mxConstants.STYLE_EDGE);
        }
        if (edgeStyle instanceof String) {
            String str = String.valueOf(edgeStyle);
            Object tmp = mxStyleRegistry.getValue(str);
            if (tmp == null) {
                tmp = mxUtils.eval(str);
            }
            edgeStyle = tmp;
        }
        if (edgeStyle instanceof mxEdgeStyle.mxEdgeStyleFunction) {
            return (mxEdgeStyle.mxEdgeStyleFunction)edgeStyle;
        }
        return null;
    }

    public void updateFloatingTerminalPoints(mxCellState state, mxCellState source, mxCellState target) {
        mxPoint p0 = state.getAbsolutePoint(0);
        mxPoint pe = state.getAbsolutePoint(state.getAbsolutePointCount() - 1);
        if (pe == null && target != null) {
            this.updateFloatingTerminalPoint(state, target, source, false);
        }
        if (p0 == null && source != null) {
            this.updateFloatingTerminalPoint(state, source, target, true);
        }
    }

    public void updateFloatingTerminalPoint(mxCellState edge, mxCellState start, mxCellState end, boolean source) {
        start = this.getTerminalPort(edge, start, source);
        mxPoint next = this.getNextPoint(edge, end, source);
        double border = mxUtils.getDouble(edge.getStyle(), mxConstants.STYLE_PERIMETER_SPACING);
        mxPoint pt = this.getPerimeterPoint(start, next, this.graph.isOrthogonal(edge), border += mxUtils.getDouble(edge.getStyle(), source ? mxConstants.STYLE_SOURCE_PERIMETER_SPACING : mxConstants.STYLE_TARGET_PERIMETER_SPACING));
        edge.setAbsoluteTerminalPoint(pt, source);
    }

    public mxCellState getTerminalPort(mxCellState state, mxCellState terminal, boolean source) {
        mxCellState tmp;
        String key = source ? mxConstants.STYLE_SOURCE_PORT : mxConstants.STYLE_TARGET_PORT;
        String id = mxUtils.getString(state.style, key);
        if (id != null && this.graph.getModel() instanceof mxGraphModel && (tmp = this.getState(((mxGraphModel)this.graph.getModel()).getCell(id))) != null) {
            terminal = tmp;
        }
        return terminal;
    }

    public mxPoint getPerimeterPoint(mxCellState terminal, mxPoint next, boolean orthogonal) {
        return this.getPerimeterPoint(terminal, next, orthogonal, 0.0);
    }

    public mxPoint getPerimeterPoint(mxCellState terminal, mxPoint next, boolean orthogonal, double border) {
        mxPoint point = null;
        if (terminal != null) {
            mxRectangle bounds;
            mxPerimeter.mxPerimeterFunction perimeter = this.getPerimeterFunction(terminal);
            if (perimeter != null && next != null && ((bounds = this.getPerimeterBounds(terminal, border)).getWidth() > 0.0 || bounds.getHeight() > 0.0)) {
                point = perimeter.apply(bounds, terminal, next, orthogonal);
            }
            if (point == null) {
                point = this.getPoint(terminal);
            }
        }
        return point;
    }

    public double getRoutingCenterX(mxCellState state) {
        float f = state.getStyle() != null ? mxUtils.getFloat(state.getStyle(), mxConstants.STYLE_ROUTING_CENTER_X) : 0.0f;
        return state.getCenterX() + (double)f * state.getWidth();
    }

    public double getRoutingCenterY(mxCellState state) {
        float f = state.getStyle() != null ? mxUtils.getFloat(state.getStyle(), mxConstants.STYLE_ROUTING_CENTER_Y) : 0.0f;
        return state.getCenterY() + (double)f * state.getHeight();
    }

    public mxRectangle getPerimeterBounds(mxCellState terminal, double border) {
        if (terminal != null) {
            border += mxUtils.getDouble(terminal.getStyle(), mxConstants.STYLE_PERIMETER_SPACING);
        }
        return terminal.getPerimeterBounds(border * this.scale);
    }

    public mxPerimeter.mxPerimeterFunction getPerimeterFunction(mxCellState state) {
        Object perimeter = state.getStyle().get(mxConstants.STYLE_PERIMETER);
        if (perimeter instanceof String) {
            String str = String.valueOf(perimeter);
            Object tmp = mxStyleRegistry.getValue(str);
            if (tmp == null) {
                tmp = mxUtils.eval(str);
            }
            perimeter = tmp;
        }
        if (perimeter instanceof mxPerimeter.mxPerimeterFunction) {
            return (mxPerimeter.mxPerimeterFunction)perimeter;
        }
        return null;
    }

    public mxPoint getNextPoint(mxCellState edge, mxCellState opposite, boolean source) {
        List<mxPoint> pts = edge.getAbsolutePoints();
        mxPoint point = null;
        if (pts != null && (source || pts.size() > 2 || opposite == null)) {
            int count = pts.size();
            int index = source ? Math.min(1, count - 1) : Math.max(0, count - 2);
            point = pts.get(index);
        }
        if (point == null && opposite != null) {
            point = new mxPoint(opposite.getCenterX(), opposite.getCenterY());
        }
        return point;
    }

    public Object getVisibleTerminal(Object edge, boolean source) {
        Object result;
        mxIGraphModel model = this.graph.getModel();
        Object best = result = model.getTerminal(edge, source);
        while (result != null && result != this.currentRoot) {
            if (!this.graph.isCellVisible(best) || this.graph.isCellCollapsed(result)) {
                best = result;
            }
            result = model.getParent(result);
        }
        if (model.getParent(best) == model.getRoot()) {
            best = null;
        }
        return best;
    }

    public void updateEdgeBounds(mxCellState state) {
        List<mxPoint> points = state.getAbsolutePoints();
        if (points != null && points.size() > 0) {
            mxPoint p0 = points.get(0);
            mxPoint pe = points.get(points.size() - 1);
            if (p0 == null || pe == null) {
                this.removeState(state.getCell());
            } else {
                if (p0.getX() != pe.getX() || p0.getY() != pe.getY()) {
                    double dx = pe.getX() - p0.getX();
                    double dy = pe.getY() - p0.getY();
                    state.setTerminalDistance(Math.sqrt(dx * dx + dy * dy));
                } else {
                    state.setTerminalDistance(0.0);
                }
                double length = 0.0;
                double[] segments = new double[points.size() - 1];
                mxPoint pt = p0;
                double minX = pt.getX();
                double minY = pt.getY();
                double maxX = minX;
                double maxY = minY;
                int i = 1;
                while (i < points.size()) {
                    mxPoint tmp = points.get(i);
                    if (tmp != null) {
                        double segment;
                        double dx = pt.getX() - tmp.getX();
                        double dy = pt.getY() - tmp.getY();
                        segments[i - 1] = segment = Math.sqrt(dx * dx + dy * dy);
                        length += segment;
                        pt = tmp;
                        minX = Math.min(pt.getX(), minX);
                        minY = Math.min(pt.getY(), minY);
                        maxX = Math.max(pt.getX(), maxX);
                        maxY = Math.max(pt.getY(), maxY);
                    }
                    ++i;
                }
                state.setLength(length);
                state.setSegments(segments);
                double markerSize = 1.0;
                state.setX(minX);
                state.setY(minY);
                state.setWidth(Math.max(markerSize, maxX - minX));
                state.setHeight(Math.max(markerSize, maxY - minY));
            }
        }
    }

    public mxPoint getPoint(mxCellState state) {
        return this.getPoint(state, null);
    }

    public mxPoint getPoint(mxCellState state, mxGeometry geometry) {
        mxPoint offset;
        double x = state.getCenterX();
        double y = state.getCenterY();
        if (state.getSegments() != null && (geometry == null || geometry.isRelative())) {
            double gx = geometry != null ? geometry.getX() / 2.0 : 0.0;
            int pointCount = state.getAbsolutePointCount();
            double dist = (gx + 0.5) * state.getLength();
            double[] segments = state.getSegments();
            double segment = segments[0];
            double length = 0.0;
            int index = 1;
            while (dist > length + segment && index < pointCount - 1) {
                length += segment;
                segment = segments[index++];
            }
            if (segment != 0.0) {
                double factor = (dist - length) / segment;
                mxPoint p0 = state.getAbsolutePoint(index - 1);
                mxPoint pe = state.getAbsolutePoint(index);
                if (p0 != null && pe != null) {
                    double gy = 0.0;
                    double offsetX = 0.0;
                    double offsetY = 0.0;
                    if (geometry != null) {
                        gy = geometry.getY();
                        mxPoint offset2 = geometry.getOffset();
                        if (offset2 != null) {
                            offsetX = offset2.getX();
                            offsetY = offset2.getY();
                        }
                    }
                    double dx = pe.getX() - p0.getX();
                    double dy = pe.getY() - p0.getY();
                    double nx = dy / segment;
                    double ny = dx / segment;
                    x = p0.getX() + dx * factor + (nx * gy + offsetX) * this.scale;
                    y = p0.getY() + dy * factor - (ny * gy - offsetY) * this.scale;
                }
            }
        } else if (geometry != null && (offset = geometry.getOffset()) != null) {
            x += offset.getX();
            y += offset.getY();
        }
        return new mxPoint(x, y);
    }

    public mxPoint getRelativePoint(mxCellState edgeState, double x, double y) {
        mxIGraphModel model = this.graph.getModel();
        mxGeometry geometry = model.getGeometry(edgeState.getCell());
        if (geometry != null) {
            int pointCount = edgeState.getAbsolutePointCount();
            if (geometry.isRelative() && pointCount > 1) {
                double totalLength = edgeState.getLength();
                double[] segments = edgeState.getSegments();
                mxPoint p0 = edgeState.getAbsolutePoint(0);
                mxPoint pe = edgeState.getAbsolutePoint(1);
                Line2D.Double line = new Line2D.Double(p0.getPoint(), pe.getPoint());
                double minDist = line.ptSegDistSq(x, y);
                int index = 0;
                double tmp = 0.0;
                double length = 0.0;
                int i = 2;
                while (i < pointCount) {
                    tmp += segments[i - 2];
                    pe = edgeState.getAbsolutePoint(i);
                    line = new Line2D.Double(p0.getPoint(), pe.getPoint());
                    double dist = line.ptSegDistSq(x, y);
                    if (dist < minDist) {
                        minDist = dist;
                        index = i - 1;
                        length = tmp;
                    }
                    p0 = pe;
                    ++i;
                }
                double seg = segments[index];
                p0 = edgeState.getAbsolutePoint(index);
                pe = edgeState.getAbsolutePoint(index + 1);
                double x2 = p0.getX();
                double y2 = p0.getY();
                double x1 = pe.getX();
                double y1 = pe.getY();
                double px = x;
                double py = y;
                double xSegment = x2 - x1;
                double ySegment = y2 - y1;
                px -= x1;
                py -= y1;
                double projlenSq = 0.0;
                double dotprod = (px = xSegment - px) * xSegment + (py = ySegment - py) * ySegment;
                projlenSq = dotprod <= 0.0 ? 0.0 : dotprod * dotprod / (xSegment * xSegment + ySegment * ySegment);
                double projlen = Math.sqrt(projlenSq);
                if (projlen > seg) {
                    projlen = seg;
                }
                double yDistance = Line2D.ptLineDist(p0.getX(), p0.getY(), pe.getX(), pe.getY(), x, y);
                int direction = Line2D.relativeCCW(p0.getX(), p0.getY(), pe.getX(), pe.getY(), x, y);
                if (direction == -1) {
                    yDistance = -yDistance;
                }
                return new mxPoint(Math.round((totalLength / 2.0 - length - projlen) / totalLength * -2.0), Math.round(yDistance / this.scale));
            }
        }
        return new mxPoint();
    }

    public mxCellState[] getCellStates(Object[] cells) {
        ArrayList<mxCellState> result = new ArrayList<mxCellState>(cells.length);
        int i = 0;
        while (i < cells.length) {
            mxCellState state = this.getState(cells[i]);
            if (state != null) {
                result.add(state);
            }
            ++i;
        }
        mxCellState[] resultArray = new mxCellState[result.size()];
        return result.toArray(resultArray);
    }

    public mxCellState getState(Object cell) {
        return this.getState(cell, false);
    }

    public mxCellState getState(Object cell, boolean create) {
        mxCellState state = null;
        if (cell != null && (state = this.states.get(cell)) == null && create && this.graph.isCellVisible(cell)) {
            state = this.createState(cell);
            this.states.put(cell, state);
        }
        return state;
    }

    public mxCellState removeState(Object cell) {
        return cell != null ? this.states.remove(cell) : null;
    }

    public mxCellState createState(Object cell) {
        return new mxCellState(this, cell, this.graph.getCellStyle(cell));
    }

    public static class mxCurrentRootChange
    implements mxUndoableEdit.mxUndoableChange {
        protected mxGraphView view;
        protected Object root;
        protected Object previous;
        protected boolean up;

        public mxCurrentRootChange(mxGraphView view, Object root) {
            this.view = view;
            this.previous = this.root = root;
            boolean bl = this.up = root == null;
            if (!this.up) {
                Object tmp = view.getCurrentRoot();
                mxIGraphModel model = view.graph.getModel();
                while (tmp != null) {
                    if (tmp == root) {
                        this.up = true;
                        break;
                    }
                    tmp = model.getParent(tmp);
                }
            }
        }

        public mxGraphView getView() {
            return this.view;
        }

        public Object getRoot() {
            return this.root;
        }

        public Object getPrevious() {
            return this.previous;
        }

        public boolean isUp() {
            return this.up;
        }

        @Override
        public void execute() {
            Object tmp = this.view.getCurrentRoot();
            this.view.currentRoot = this.previous;
            this.previous = tmp;
            mxPoint translate = this.view.graph.getTranslateForRoot(this.view.getCurrentRoot());
            if (translate != null) {
                this.view.translate = new mxPoint(-translate.getX(), translate.getY());
            }
            this.view.reload();
            this.up = !this.up;
            String eventName = this.up ? "up" : "down";
            this.view.fireEvent(new mxEventObject(eventName, "root", this.view.currentRoot, "previous", this.previous));
        }
    }
}

