/*
 * Decompiled with CFR 0.152.
 */
package com.mxgraph.view;

import com.mxgraph.model.mxGeometry;
import com.mxgraph.model.mxIGraphModel;
import com.mxgraph.util.mxConstants;
import com.mxgraph.util.mxPoint;
import com.mxgraph.util.mxUtils;
import com.mxgraph.view.mxCellState;
import com.mxgraph.view.mxGraph;
import com.mxgraph.view.mxGraphView;
import java.util.List;

public class mxEdgeStyle {
    public static mxEdgeStyleFunction EntityRelation = new mxEdgeStyleFunction(){

        @Override
        public void apply(mxCellState state, mxCellState source, mxCellState target, List<mxPoint> points, List<mxPoint> result) {
            mxGraphView view = state.getView();
            mxIGraphModel model = view.getGraph().getModel();
            double segment = mxUtils.getDouble(state.getStyle(), mxConstants.STYLE_SEGMENT, mxConstants.ENTITY_SEGMENT) * state.view.getScale();
            mxPoint p0 = state.getAbsolutePoint(0);
            mxPoint pe = state.getAbsolutePoint(state.getAbsolutePointCount() - 1);
            boolean isSourceLeft = false;
            if (p0 != null) {
                source = new mxCellState();
                source.setX(p0.getX());
                source.setY(p0.getY());
            } else if (source != null) {
                mxGeometry sourceGeometry = model.getGeometry(source.cell);
                if (sourceGeometry.isRelative()) {
                    isSourceLeft = sourceGeometry.getX() <= 0.5;
                } else if (target != null) {
                    isSourceLeft = target.getX() + target.getWidth() < source.getX();
                }
            }
            boolean isTargetLeft = true;
            if (pe != null) {
                target = new mxCellState();
                target.setX(pe.getX());
                target.setY(pe.getY());
            } else if (target != null) {
                mxGeometry targetGeometry = model.getGeometry(target.cell);
                if (targetGeometry.isRelative()) {
                    isTargetLeft = targetGeometry.getX() <= 0.5;
                } else if (source != null) {
                    boolean bl = isTargetLeft = source.getX() + source.getWidth() < target.getX();
                }
            }
            if (source != null && target != null) {
                double x0 = isSourceLeft ? source.getX() : source.getX() + source.getWidth();
                double y0 = view.getRoutingCenterY(source);
                double xe = isTargetLeft ? target.getX() : target.getX() + target.getWidth();
                double ye = view.getRoutingCenterY(target);
                double seg = segment;
                double dx = isSourceLeft ? -seg : seg;
                mxPoint dep = new mxPoint(x0 + dx, y0);
                result.add(dep);
                dx = isTargetLeft ? -seg : seg;
                mxPoint arr = new mxPoint(xe + dx, ye);
                if (isSourceLeft == isTargetLeft) {
                    double x = isSourceLeft ? Math.min(x0, xe) - segment : Math.max(x0, xe) + segment;
                    result.add(new mxPoint(x, y0));
                    result.add(new mxPoint(x, ye));
                } else if (dep.getX() < arr.getX() == isSourceLeft) {
                    double midY = y0 + (ye - y0) / 2.0;
                    result.add(new mxPoint(dep.getX(), midY));
                    result.add(new mxPoint(arr.getX(), midY));
                }
                result.add(arr);
            }
        }
    };
    public static mxEdgeStyleFunction Loop = new mxEdgeStyleFunction(){

        @Override
        public void apply(mxCellState state, mxCellState source, mxCellState target, List<mxPoint> points, List<mxPoint> result) {
            if (source != null) {
                mxPoint pt;
                mxGraphView view = state.getView();
                mxGraph graph = view.getGraph();
                mxPoint mxPoint2 = pt = points != null && points.size() > 0 ? points.get(0) : null;
                if (pt != null && source.contains((pt = view.transformControlPoint(state, pt)).getX(), pt.getY())) {
                    pt = null;
                }
                double x = 0.0;
                double dx = 0.0;
                double y = 0.0;
                double dy = 0.0;
                double seg = mxUtils.getDouble(state.getStyle(), mxConstants.STYLE_SEGMENT, graph.getGridSize()) * view.getScale();
                String dir = mxUtils.getString(state.getStyle(), mxConstants.STYLE_DIRECTION, "west");
                if (dir.equals("north") || dir.equals("south")) {
                    x = view.getRoutingCenterX(source);
                    dx = seg;
                } else {
                    y = view.getRoutingCenterY(source);
                    dy = seg;
                }
                if (pt == null || pt.getX() < source.getX() || pt.getX() > source.getX() + source.getWidth()) {
                    if (pt != null) {
                        x = pt.getX();
                        dy = Math.max(Math.abs(y - pt.getY()), dy);
                    } else if (dir.equals("north")) {
                        y = source.getY() - 2.0 * dx;
                    } else if (dir.equals("south")) {
                        y = source.getY() + source.getHeight() + 2.0 * dx;
                    } else {
                        x = dir.equals("east") ? source.getX() - 2.0 * dy : source.getX() + source.getWidth() + 2.0 * dy;
                    }
                } else {
                    x = view.getRoutingCenterX(source);
                    dx = Math.max(Math.abs(x - pt.getX()), dy);
                    y = pt.getY();
                    dy = 0.0;
                }
                result.add(new mxPoint(x - dx, y - dy));
                result.add(new mxPoint(x + dx, y + dy));
            }
        }
    };
    public static mxEdgeStyleFunction ElbowConnector = new mxEdgeStyleFunction(){

        @Override
        public void apply(mxCellState state, mxCellState source, mxCellState target, List<mxPoint> points, List<mxPoint> result) {
            mxPoint pt = points != null && points.size() > 0 ? points.get(0) : null;
            boolean vertical = false;
            boolean horizontal = false;
            if (source != null && target != null) {
                if (pt != null) {
                    double left = Math.min(source.getX(), target.getX());
                    double right = Math.max(source.getX() + source.getWidth(), target.getX() + target.getWidth());
                    double top = Math.min(source.getY(), target.getY());
                    double bottom = Math.max(source.getY() + source.getHeight(), target.getY() + target.getHeight());
                    pt = state.getView().transformControlPoint(state, pt);
                    vertical = pt.getY() < top || pt.getY() > bottom;
                    horizontal = pt.getX() < left || pt.getX() > right;
                } else {
                    double right;
                    double left = Math.max(source.getX(), target.getX());
                    boolean bl = vertical = left == (right = Math.min(source.getX() + source.getWidth(), target.getX() + target.getWidth()));
                    if (!vertical) {
                        double bottom;
                        double top = Math.max(source.getY(), target.getY());
                        boolean bl2 = horizontal = top == (bottom = Math.min(source.getY() + source.getHeight(), target.getY() + target.getHeight()));
                    }
                }
            }
            if (!horizontal && (vertical || mxUtils.getString(state.getStyle(), mxConstants.STYLE_ELBOW, "").equals("vertical"))) {
                TopToBottom.apply(state, source, target, points, result);
            } else {
                SideToSide.apply(state, source, target, points, result);
            }
        }
    };
    public static mxEdgeStyleFunction SideToSide = new mxEdgeStyleFunction(){

        @Override
        public void apply(mxCellState state, mxCellState source, mxCellState target, List<mxPoint> points, List<mxPoint> result) {
            mxGraphView view = state.getView();
            mxPoint pt = points != null && points.size() > 0 ? points.get(0) : null;
            mxPoint p0 = state.getAbsolutePoint(0);
            mxPoint pe = state.getAbsolutePoint(state.getAbsolutePointCount() - 1);
            if (pt != null) {
                pt = view.transformControlPoint(state, pt);
            }
            if (p0 != null) {
                source = new mxCellState();
                source.setX(p0.getX());
                source.setY(p0.getY());
            }
            if (pe != null) {
                target = new mxCellState();
                target.setX(pe.getX());
                target.setY(pe.getY());
            }
            if (source != null && target != null) {
                double l = Math.max(source.getX(), target.getX());
                double r = Math.min(source.getX() + source.getWidth(), target.getX() + target.getWidth());
                double x = pt != null ? pt.getX() : r + (l - r) / 2.0;
                double y1 = view.getRoutingCenterY(source);
                double y2 = view.getRoutingCenterY(target);
                if (pt != null) {
                    if (pt.getY() >= source.getY() && pt.getY() <= source.getY() + source.getHeight()) {
                        y1 = pt.getY();
                    }
                    if (pt.getY() >= target.getY() && pt.getY() <= target.getY() + target.getHeight()) {
                        y2 = pt.getY();
                    }
                }
                if (!target.contains(x, y1) && !source.contains(x, y1)) {
                    result.add(new mxPoint(x, y1));
                }
                if (!target.contains(x, y2) && !source.contains(x, y2)) {
                    result.add(new mxPoint(x, y2));
                }
                if (result.size() == 1) {
                    if (pt != null) {
                        result.add(new mxPoint(x, pt.getY()));
                    } else {
                        double t = Math.max(source.getY(), target.getY());
                        double b = Math.min(source.getY() + source.getHeight(), target.getY() + target.getHeight());
                        result.add(new mxPoint(x, t + (b - t) / 2.0));
                    }
                }
            }
        }
    };
    public static mxEdgeStyleFunction TopToBottom = new mxEdgeStyleFunction(){

        @Override
        public void apply(mxCellState state, mxCellState source, mxCellState target, List<mxPoint> points, List<mxPoint> result) {
            mxGraphView view = state.getView();
            mxPoint pt = points != null && points.size() > 0 ? points.get(0) : null;
            mxPoint p0 = state.getAbsolutePoint(0);
            mxPoint pe = state.getAbsolutePoint(state.getAbsolutePointCount() - 1);
            if (pt != null) {
                pt = view.transformControlPoint(state, pt);
            }
            if (p0 != null) {
                source = new mxCellState();
                source.setX(p0.getX());
                source.setY(p0.getY());
            }
            if (pe != null) {
                target = new mxCellState();
                target.setX(pe.getX());
                target.setY(pe.getY());
            }
            if (source != null && target != null) {
                double y;
                double t = Math.max(source.getY(), target.getY());
                double b = Math.min(source.getY() + source.getHeight(), target.getY() + target.getHeight());
                double x = view.getRoutingCenterX(source);
                if (pt != null && pt.getX() >= source.getX() && pt.getX() <= source.getX() + source.getWidth()) {
                    x = pt.getX();
                }
                double d = y = pt != null ? pt.getY() : b + (t - b) / 2.0;
                if (!target.contains(x, y) && !source.contains(x, y)) {
                    result.add(new mxPoint(x, y));
                }
                if (!target.contains(x = pt != null && pt.getX() >= target.getX() && pt.getX() <= target.getX() + target.getWidth() ? pt.getX() : view.getRoutingCenterX(target), y) && !source.contains(x, y)) {
                    result.add(new mxPoint(x, y));
                }
                if (result.size() == 1) {
                    if (pt != null) {
                        result.add(new mxPoint(pt.getX(), y));
                    } else {
                        double l = Math.max(source.getX(), target.getX());
                        double r = Math.min(source.getX() + source.getWidth(), target.getX() + target.getWidth());
                        result.add(new mxPoint(l + (r - l) / 2.0, y));
                    }
                }
            }
        }
    };

    public static interface mxEdgeStyleFunction {
        public void apply(mxCellState var1, mxCellState var2, mxCellState var3, List<mxPoint> var4, List<mxPoint> var5);
    }
}

