/*
 * Decompiled with CFR 0.152.
 */
package com.mxgraph.util;

import com.mxgraph.io.mxCodecRegistry;
import com.mxgraph.model.mxCellPath;
import com.mxgraph.model.mxICell;
import com.mxgraph.model.mxIGraphModel;
import com.mxgraph.util.mxBase64;
import com.mxgraph.util.mxConstants;
import com.mxgraph.util.mxLightweightLabel;
import com.mxgraph.util.mxPoint;
import com.mxgraph.util.mxRectangle;
import com.mxgraph.view.mxCellState;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Formatter;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.TreeSet;
import javax.imageio.ImageIO;
import javax.swing.text.html.HTMLDocument;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class mxUtils {
    public static boolean IS_MAC = System.getProperty("os.name").toLowerCase().indexOf("mac") >= 0;
    protected static transient Graphics fontGraphics;

    static {
        try {
            fontGraphics = new BufferedImage(1, 1, 1).getGraphics();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static mxRectangle getLabelSize(String label, Map<String, Object> style, boolean isHtml, int width) {
        mxRectangle size = isHtml ? mxUtils.getSizeForHtml(mxUtils.getBodyMarkup(label, true), style) : mxUtils.getSizeForString(label, mxUtils.getFont(style), width);
        return size;
    }

    public static String getBodyMarkup(String markup, boolean replaceLinefeeds) {
        int bodyEnd;
        String lowerCase = markup.toLowerCase();
        int bodyStart = lowerCase.indexOf("<body>");
        if (bodyStart >= 0 && (bodyEnd = lowerCase.lastIndexOf("</body>")) > (bodyStart += 7)) {
            markup = markup.substring(bodyStart, bodyEnd).trim();
        }
        if (replaceLinefeeds) {
            markup = markup.replaceAll("\n", "<br>");
        }
        return markup;
    }

    public static mxRectangle getLabelPaintBounds(String label, Map<String, Object> style, boolean isHtml, mxPoint offset, mxRectangle vertexBounds, double scale) {
        boolean horizontal = mxUtils.isTrue(style, mxConstants.STYLE_HORIZONTAL, true);
        int w = 0;
        if (vertexBounds != null && mxUtils.getString(style, mxConstants.STYLE_WHITE_SPACE, "nowrap").equals("wrap")) {
            w = horizontal ? (int)(vertexBounds.getWidth() / scale - (double)(2 * mxConstants.LABEL_INSET) - 2.0 * mxUtils.getDouble(style, mxConstants.STYLE_SPACING) - mxUtils.getDouble(style, mxConstants.STYLE_SPACING_LEFT) - mxUtils.getDouble(style, mxConstants.STYLE_SPACING_RIGHT)) : (int)(vertexBounds.getHeight() / scale - (double)(2 * mxConstants.LABEL_INSET) - 2.0 * mxUtils.getDouble(style, mxConstants.STYLE_SPACING) - mxUtils.getDouble(style, mxConstants.STYLE_SPACING_TOP) + mxUtils.getDouble(style, mxConstants.STYLE_SPACING_BOTTOM));
        }
        mxRectangle size = mxUtils.getLabelSize(label, style, isHtml, w);
        double x = offset.getX();
        double y = offset.getY();
        double width = 0.0;
        double height = 0.0;
        if (vertexBounds != null) {
            x += vertexBounds.getX();
            y += vertexBounds.getY();
            if (mxUtils.getString(style, mxConstants.STYLE_SHAPE, "").equals("swimlane")) {
                double start = mxUtils.getDouble(style, mxConstants.STYLE_STARTSIZE, mxConstants.DEFAULT_STARTSIZE) * scale;
                if (horizontal) {
                    width += vertexBounds.getWidth();
                    height += start;
                } else {
                    width += start;
                    height += vertexBounds.getHeight();
                }
            } else {
                width += vertexBounds.getWidth();
                height += vertexBounds.getHeight();
            }
        }
        return mxUtils.getScaledLabelBounds(x, y, size, width, height, style, scale);
    }

    public static mxRectangle getScaledLabelBounds(double x, double y, mxRectangle size, double outerWidth, double outerHeight, Map<String, Object> style, double scale) {
        double inset = (double)mxConstants.LABEL_INSET * scale;
        double width = size.getWidth() * scale + 2.0 * inset;
        double height = size.getHeight() * scale + 2.0 * inset;
        boolean horizontal = mxUtils.isTrue(style, mxConstants.STYLE_HORIZONTAL, true);
        int spacing = (int)((double)mxUtils.getInt(style, mxConstants.STYLE_SPACING) * scale);
        String align = mxUtils.getString(style, mxConstants.STYLE_ALIGN, "center");
        String valign = mxUtils.getString(style, mxConstants.STYLE_VERTICAL_ALIGN, "middle");
        int top = (int)((double)mxUtils.getInt(style, mxConstants.STYLE_SPACING_TOP) * scale);
        int bottom = (int)((double)mxUtils.getInt(style, mxConstants.STYLE_SPACING_BOTTOM) * scale);
        int left = (int)((double)mxUtils.getInt(style, mxConstants.STYLE_SPACING_LEFT) * scale);
        int right = (int)((double)mxUtils.getInt(style, mxConstants.STYLE_SPACING_RIGHT) * scale);
        if (!horizontal) {
            int tmp = top;
            top = right;
            right = bottom;
            bottom = left;
            left = tmp;
            double tmp2 = width;
            width = height;
            height = tmp2;
        }
        x = horizontal && align.equals("center") || !horizontal && valign.equals("middle") ? (x += (outerWidth - width) / 2.0 + (double)left - (double)right) : (horizontal && align.equals("right") || !horizontal && valign.equals("bottom") ? (x += outerWidth - width - (double)spacing - (double)right) : (x += (double)(spacing + left)));
        y = !horizontal && align.equals("center") || horizontal && valign.equals("middle") ? (y += (outerHeight - height) / 2.0 + (double)top - (double)bottom) : (!horizontal && align.equals("left") || horizontal && valign.equals("bottom") ? (y += outerHeight - height - (double)spacing - (double)bottom) : (y += (double)(spacing + top)));
        return new mxRectangle(x, y, width, height);
    }

    public static FontMetrics getFontMetrics(Font font) {
        if (fontGraphics != null) {
            return fontGraphics.getFontMetrics(font);
        }
        return null;
    }

    public static mxRectangle getSizeForString(String text, Font font, int width) {
        FontRenderContext frc = new FontRenderContext(null, false, false);
        FontMetrics metrics = null;
        if (fontGraphics != null) {
            metrics = fontGraphics.getFontMetrics(font);
        }
        double lineHeight = mxConstants.LINESPACING;
        lineHeight = metrics != null ? (lineHeight += (double)metrics.getHeight()) : (lineHeight += (double)font.getSize2D() * 1.27);
        String[] lines = width > 0 ? mxUtils.wordWrap(text, metrics, (int)((double)width * mxConstants.LABEL_SCALE_BUFFER)) : text.split("\n");
        Rectangle2D boundingBox = null;
        int i = 0;
        while (i < lines.length) {
            Rectangle2D bounds = font.getStringBounds(lines[i], frc);
            if (boundingBox == null) {
                boundingBox = bounds;
            } else {
                boundingBox.setFrame(0.0, 0.0, Math.max(boundingBox.getWidth(), bounds.getWidth()), boundingBox.getHeight() + lineHeight);
            }
            ++i;
        }
        return new mxRectangle(boundingBox);
    }

    public static String[] wordWrap(String text, FontMetrics metrics, int width) {
        ArrayList<String> result = new ArrayList<String>();
        String[] lines = text.split("\n");
        int i = 0;
        while (i < lines.length) {
            int lineWidth = 0;
            int charCount = 0;
            StringBuilder currentLine = new StringBuilder();
            String[] words = lines[i].split("\\s+");
            Stack<String> wordStack = new Stack<String>();
            int j = words.length - 1;
            while (j >= 0) {
                wordStack.push(words[j]);
                --j;
            }
            block2: while (!wordStack.isEmpty()) {
                double wordLength;
                String word = (String)wordStack.pop();
                int whitespaceCount = 0;
                if (word.length() > 0) {
                    char firstWordLetter = word.charAt(0);
                    int letterIndex = lines[i].indexOf(firstWordLetter, charCount);
                    String whitespace = lines[i].substring(charCount, letterIndex);
                    whitespaceCount = whitespace.length();
                    word = whitespace.concat(word);
                }
                if ((double)lineWidth + (wordLength = lineWidth > 0 ? (double)metrics.stringWidth(word) : (double)metrics.stringWidth(word.trim())) > (double)width) {
                    if (lineWidth > 0) {
                        result.add(currentLine.toString());
                        currentLine = new StringBuilder();
                        wordStack.push(word.trim());
                        lineWidth = 0;
                        continue;
                    }
                    word = word.trim();
                    int j2 = 1;
                    while (j2 <= word.length()) {
                        wordLength = metrics.stringWidth(word.substring(0, j2));
                        if ((double)lineWidth + wordLength > (double)width) {
                            j2 = j2 > 1 ? j2 - 1 : j2;
                            String chars = word.substring(0, j2);
                            currentLine = currentLine.append(chars);
                            wordStack.push(word.substring(j2, word.length()));
                            result.add(currentLine.toString());
                            currentLine = new StringBuilder();
                            lineWidth = 0;
                            charCount = charCount + chars.length() + whitespaceCount;
                            continue block2;
                        }
                        ++j2;
                    }
                    continue;
                }
                currentLine = lineWidth > 0 ? currentLine.append(word) : currentLine.append(word.trim());
                lineWidth = (int)((double)lineWidth + wordLength);
                charCount += word.length();
            }
            if (currentLine.length() > 0 || result.isEmpty()) {
                result.add(currentLine.toString());
            }
            ++i;
        }
        return result.toArray(new String[result.size()]);
    }

    public static mxRectangle getSizeForHtml(String markup, Map<String, Object> style) {
        mxLightweightLabel textRenderer = mxLightweightLabel.getSharedInstance();
        if (textRenderer != null) {
            textRenderer.setText(mxUtils.createHtmlDocument(style, markup));
            Dimension size = textRenderer.getPreferredSize();
            return new mxRectangle(0.0, 0.0, size.width, size.height);
        }
        return mxUtils.getSizeForString(markup, mxUtils.getFont(style), 0);
    }

    public static mxRectangle getBoundingBox(mxRectangle rect, double rotation) {
        mxRectangle result = null;
        if (rect != null && rotation != 0.0) {
            double rad = Math.toRadians(rotation);
            double cos = Math.cos(rad);
            double sin = Math.sin(rad);
            mxPoint cx = new mxPoint(rect.getX() + rect.getWidth() / 2.0, rect.getY() + rect.getHeight() / 2.0);
            mxPoint p1 = new mxPoint(rect.getX(), rect.getY());
            mxPoint p2 = new mxPoint(rect.getX() + rect.getWidth(), rect.getY());
            mxPoint p3 = new mxPoint(p2.getX(), rect.getY() + rect.getHeight());
            mxPoint p4 = new mxPoint(rect.getX(), p3.getY());
            p1 = mxUtils.getRotatedPoint(p1, cos, sin, cx);
            p2 = mxUtils.getRotatedPoint(p2, cos, sin, cx);
            p3 = mxUtils.getRotatedPoint(p3, cos, sin, cx);
            p4 = mxUtils.getRotatedPoint(p4, cos, sin, cx);
            Rectangle tmp = new Rectangle((int)p1.getX(), (int)p1.getY(), 0, 0);
            tmp.add(p2.getPoint());
            tmp.add(p3.getPoint());
            tmp.add(p4.getPoint());
            result = new mxRectangle(tmp);
        } else if (rect != null) {
            result = (mxRectangle)rect.clone();
        }
        return result;
    }

    public static mxPoint getRotatedPoint(mxPoint pt, double cos, double sin) {
        return mxUtils.getRotatedPoint(pt, cos, sin, new mxPoint());
    }

    public static int findNearestSegment(mxCellState state, double x, double y) {
        int index = -1;
        if (state.getAbsolutePointCount() > 0) {
            mxPoint last = state.getAbsolutePoint(0);
            double min = Double.MAX_VALUE;
            int i = 1;
            while (i < state.getAbsolutePointCount()) {
                mxPoint current = state.getAbsolutePoint(i);
                double dist = new Line2D.Double(last.x, last.y, current.x, current.y).ptSegDistSq(x, y);
                if (dist < min) {
                    min = dist;
                    index = i - 1;
                }
                last = current;
                ++i;
            }
        }
        return index;
    }

    public static mxPoint getRotatedPoint(mxPoint pt, double cos, double sin, mxPoint c) {
        double x = pt.getX() - c.getX();
        double y = pt.getY() - c.getY();
        double x1 = x * cos - y * sin;
        double y1 = y * cos + x * sin;
        return new mxPoint(x1 + c.getX(), y1 + c.getY());
    }

    public static void drawImageClip(Graphics g, BufferedImage image, ImageObserver observer) {
        Rectangle clip = g.getClipBounds();
        if (clip != null) {
            int w = image.getWidth();
            int h = image.getHeight();
            int x = Math.max(0, Math.min(clip.x, w));
            int y = Math.max(0, Math.min(clip.y, h));
            w = Math.min(clip.width, w - x);
            h = Math.min(clip.height, h - y);
            if (w > 0 && h > 0) {
                g.drawImage(image.getSubimage(x, y, w, h), clip.x, clip.y, observer);
            }
        } else {
            g.drawImage(image, 0, 0, observer);
        }
    }

    public static void fillClippedRect(Graphics g, int x, int y, int width, int height) {
        Rectangle bg = new Rectangle(x, y, width, height);
        try {
            if (g.getClipBounds() != null) {
                bg = bg.intersection(g.getClipBounds());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        g.fillRect(bg.x, bg.y, bg.width, bg.height);
    }

    public static List<mxPoint> translatePoints(List<mxPoint> pts, double dx, double dy) {
        ArrayList<mxPoint> result = null;
        if (pts != null) {
            result = new ArrayList<mxPoint>(pts.size());
            Iterator<mxPoint> it = pts.iterator();
            while (it.hasNext()) {
                mxPoint point = (mxPoint)it.next().clone();
                point.setX(point.getX() + dx);
                point.setY(point.getY() + dy);
                result.add(point);
            }
        }
        return result;
    }

    public static mxPoint intersection(double x0, double y0, double x1, double y1, double x2, double y2, double x3, double y3) {
        double denom = (y3 - y2) * (x1 - x0) - (x3 - x2) * (y1 - y0);
        double nume_a = (x3 - x2) * (y0 - y2) - (y3 - y2) * (x0 - x2);
        double nume_b = (x1 - x0) * (y0 - y2) - (y1 - y0) * (x0 - x2);
        double ua = nume_a / denom;
        double ub = nume_b / denom;
        if (ua >= 0.0 && ua <= 1.0 && ub >= 0.0 && ub <= 1.0) {
            double intersectionX = x0 + ua * (x1 - x0);
            double intersectionY = y0 + ua * (y1 - y0);
            return new mxPoint(intersectionX, intersectionY);
        }
        return null;
    }

    public static Object[] sortCells(Object[] cells, boolean ascending) {
        return mxUtils.sortCells(Arrays.asList(cells), ascending).toArray();
    }

    public static Collection<Object> sortCells(Collection<Object> cells, final boolean ascending) {
        TreeSet<Object> result = new TreeSet<Object>(new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                int comp = mxCellPath.compare(mxCellPath.create((mxICell)o1), mxCellPath.create((mxICell)o2));
                return comp == 0 ? 0 : (comp > 0 == ascending ? 1 : -1);
            }
        });
        result.addAll(cells);
        return result;
    }

    public static boolean contains(Object[] array, Object obj) {
        return mxUtils.indexOf(array, obj) >= 0;
    }

    public static int indexOf(Object[] array, Object obj) {
        if (obj != null && array != null) {
            int i = 0;
            while (i < array.length) {
                if (array[i] == obj) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    public static String getStylename(String style) {
        String[] pairs;
        String stylename;
        if (style != null && (stylename = (pairs = style.split(";"))[0]).indexOf("=") < 0) {
            return stylename;
        }
        return "";
    }

    public static String[] getStylenames(String style) {
        ArrayList<String> result = new ArrayList<String>();
        if (style != null) {
            String[] pairs = style.split(";");
            int i = 0;
            while (i < pairs.length) {
                if (pairs[i].indexOf("=") < 0) {
                    result.add(pairs[i]);
                }
                ++i;
            }
        }
        return result.toArray(new String[result.size()]);
    }

    public static int indexOfStylename(String style, String stylename) {
        if (style != null && stylename != null) {
            String[] tokens = style.split(";");
            int pos = 0;
            int i = 0;
            while (i < tokens.length) {
                if (tokens[i].equals(stylename)) {
                    return pos;
                }
                pos += tokens[i].length() + 1;
                ++i;
            }
        }
        return -1;
    }

    public String addStylename(String style, String stylename) {
        if (mxUtils.indexOfStylename(style, stylename) < 0) {
            if (style == null) {
                style = "";
            } else if (style.length() > 0 && style.charAt(style.length() - 1) != ';') {
                style = String.valueOf(style) + ';';
            }
            style = String.valueOf(style) + stylename;
        }
        return style;
    }

    public String removeStylename(String style, String stylename) {
        StringBuffer buffer = new StringBuffer();
        if (style != null) {
            String[] tokens = style.split(";");
            int i = 0;
            while (i < tokens.length) {
                if (!tokens[i].equals(stylename)) {
                    buffer.append(String.valueOf(tokens[i]) + ";");
                }
                ++i;
            }
        }
        return buffer.length() > 1 ? buffer.substring(0, buffer.length() - 1) : buffer.toString();
    }

    public static String removeAllStylenames(String style) {
        StringBuffer buffer = new StringBuffer();
        if (style != null) {
            String[] tokens = style.split(";");
            int i = 0;
            while (i < tokens.length) {
                if (tokens[i].indexOf(61) >= 0) {
                    buffer.append(String.valueOf(tokens[i]) + ";");
                }
                ++i;
            }
        }
        return buffer.length() > 1 ? buffer.substring(0, buffer.length() - 1) : buffer.toString();
    }

    public static void setCellStyles(mxIGraphModel model, Object[] cells, String key, String value) {
        if (cells != null && cells.length > 0) {
            model.beginUpdate();
            try {
                int i = 0;
                while (i < cells.length) {
                    if (cells[i] != null) {
                        String style = mxUtils.setStyle(model.getStyle(cells[i]), key, value);
                        model.setStyle(cells[i], style);
                    }
                    ++i;
                }
            }
            finally {
                model.endUpdate();
            }
        }
    }

    public static String setStyle(String style, String key, String value) {
        boolean isValue;
        boolean bl = isValue = value != null && value.length() > 0;
        if (style == null || style.length() == 0) {
            if (isValue) {
                style = String.valueOf(key) + "=" + value;
            }
        } else {
            int index = style.indexOf(String.valueOf(key) + "=");
            if (index < 0) {
                if (isValue) {
                    String sep = style.endsWith(";") ? "" : ";";
                    style = String.valueOf(style) + sep + key + '=' + value;
                }
            } else {
                String tmp = isValue ? String.valueOf(key) + "=" + value : "";
                int cont = style.indexOf(";", index);
                if (!isValue) {
                    ++cont;
                }
                style = String.valueOf(style.substring(0, index)) + tmp + (cont > index ? style.substring(cont) : "");
            }
        }
        return style;
    }

    public static void setCellStyleFlags(mxIGraphModel model, Object[] cells, String key, int flag, Boolean value) {
        if (cells != null && cells.length > 0) {
            model.beginUpdate();
            try {
                int i = 0;
                while (i < cells.length) {
                    if (cells[i] != null) {
                        String style = mxUtils.setStyleFlag(model.getStyle(cells[i]), key, flag, value);
                        model.setStyle(cells[i], style);
                    }
                    ++i;
                }
            }
            finally {
                model.endUpdate();
            }
        }
    }

    public static String setStyleFlag(String style, String key, int flag, Boolean value) {
        if (style == null || style.length() == 0) {
            style = value == null || value.booleanValue() ? String.valueOf(key) + "=" + flag : String.valueOf(key) + "=0";
        } else {
            int index = style.indexOf(String.valueOf(key) + "=");
            if (index < 0) {
                String sep;
                String string = sep = style.endsWith(";") ? "" : ";";
                style = value == null || value.booleanValue() ? String.valueOf(style) + sep + key + "=" + flag : String.valueOf(style) + sep + key + "=0";
            } else {
                int cont = style.indexOf(";", index);
                String tmp = "";
                int result = 0;
                tmp = cont < 0 ? style.substring(index + key.length() + 1) : style.substring(index + key.length() + 1, cont);
                result = value == null ? Integer.parseInt(tmp) ^ flag : (value != false ? Integer.parseInt(tmp) | flag : Integer.parseInt(tmp) & ~flag);
                style = String.valueOf(style.substring(0, index)) + key + "=" + result + (cont >= 0 ? style.substring(cont) : "");
            }
        }
        return style;
    }

    public static boolean intersectsHotspot(mxCellState state, int x, int y, double hotspot) {
        return mxUtils.intersectsHotspot(state, x, y, hotspot, 0, 0);
    }

    public static boolean intersectsHotspot(mxCellState state, int x, int y, double hotspot, int min, int max) {
        if (hotspot > 0.0) {
            int cx = (int)Math.round(state.getCenterX());
            int cy = (int)Math.round(state.getCenterY());
            int width = (int)Math.round(state.getWidth());
            int height = (int)Math.round(state.getHeight());
            if (mxUtils.getString(state.getStyle(), mxConstants.STYLE_SHAPE, "").equals("swimlane")) {
                int start = mxUtils.getInt(state.getStyle(), mxConstants.STYLE_STARTSIZE, mxConstants.DEFAULT_STARTSIZE);
                if (mxUtils.isTrue(state.getStyle(), mxConstants.STYLE_HORIZONTAL, true)) {
                    cy = (int)Math.round(state.getY() + (double)(start / 2));
                    height = start;
                } else {
                    cx = (int)Math.round(state.getX() + (double)(start / 2));
                    width = start;
                }
            }
            int w = (int)Math.max((double)min, (double)width * hotspot);
            int h = (int)Math.max((double)min, (double)height * hotspot);
            if (max > 0) {
                w = Math.min(w, max);
                h = Math.min(h, max);
            }
            Rectangle rect = new Rectangle(Math.round(cx - w / 2), Math.round(cy - h / 2), w, h);
            return rect.contains(x, y);
        }
        return true;
    }

    public static boolean isTrue(Map<String, Object> dict, String key) {
        return mxUtils.isTrue(dict, key, false);
    }

    public static boolean isTrue(Map<String, Object> dict, String key, boolean defaultValue) {
        Object value = dict.get(key);
        if (value == null) {
            return defaultValue;
        }
        return value.equals("1") || value.toString().toLowerCase().equals("true");
    }

    public static int getInt(Map<String, Object> dict, String key) {
        return mxUtils.getInt(dict, key, 0);
    }

    public static int getInt(Map<String, Object> dict, String key, int defaultValue) {
        Object value = dict.get(key);
        if (value == null) {
            return defaultValue;
        }
        return (int)Float.parseFloat(value.toString());
    }

    public static float getFloat(Map<String, Object> dict, String key) {
        return mxUtils.getFloat(dict, key, 0.0f);
    }

    public static float getFloat(Map<String, Object> dict, String key, float defaultValue) {
        Object value = dict.get(key);
        if (value == null) {
            return defaultValue;
        }
        return Float.parseFloat(value.toString());
    }

    public static float[] getFloatArray(Map<String, Object> dict, String key, float[] defaultValue) {
        Object value = dict.get(key);
        if (value == null) {
            return defaultValue;
        }
        String[] floatChars = value.toString().split(",");
        float[] result = new float[floatChars.length];
        int i = 0;
        while (i < floatChars.length) {
            result[i] = Float.parseFloat(floatChars[i]);
            ++i;
        }
        return result;
    }

    public static double getDouble(Map<String, Object> dict, String key) {
        return mxUtils.getDouble(dict, key, 0.0);
    }

    public static double getDouble(Map<String, Object> dict, String key, double defaultValue) {
        Object value = dict.get(key);
        if (value == null) {
            return defaultValue;
        }
        return Double.parseDouble(value.toString());
    }

    public static String getString(Map<String, Object> dict, String key) {
        return mxUtils.getString(dict, key, null);
    }

    public static String getString(Map<String, Object> dict, String key, String defaultValue) {
        Object value = dict.get(key);
        if (value == null) {
            return defaultValue;
        }
        return value.toString();
    }

    public static Color getColor(Map<String, Object> dict, String key) {
        return mxUtils.getColor(dict, key, null);
    }

    public static Color getColor(Map<String, Object> dict, String key, Color defaultValue) {
        Object value = dict.get(key);
        if (value == null) {
            return defaultValue;
        }
        return mxUtils.parseColor(value.toString());
    }

    public static Font getFont(Map<String, Object> style) {
        return mxUtils.getFont(style, 1.0);
    }

    public static Font getFont(Map<String, Object> style, double scale) {
        String fontFamily = mxUtils.getString(style, mxConstants.STYLE_FONTFAMILY, mxConstants.DEFAULT_FONTFAMILY);
        int fontSize = mxUtils.getInt(style, mxConstants.STYLE_FONTSIZE, mxConstants.DEFAULT_FONTSIZE);
        int fontStyle = mxUtils.getInt(style, mxConstants.STYLE_FONTSTYLE);
        int swingFontStyle = (fontStyle & 1) == 1 ? 1 : 0;
        return new Font(fontFamily, swingFontStyle += (fontStyle & 2) == 2 ? 2 : 0, (int)((double)fontSize * scale));
    }

    public static String hexString(Color color) {
        int r = color.getRed();
        int g = color.getGreen();
        int b = color.getBlue();
        return String.format("#%02X%02X%02X", r, g, b);
    }

    public static Color parseColor(String colorString) throws NumberFormatException {
        int value;
        if (colorString.equalsIgnoreCase("white")) {
            return Color.white;
        }
        if (colorString.equalsIgnoreCase("black")) {
            return Color.black;
        }
        if (colorString.equalsIgnoreCase("red")) {
            return Color.red;
        }
        if (colorString.equalsIgnoreCase("green")) {
            return Color.green;
        }
        if (colorString.equalsIgnoreCase("blue")) {
            return Color.blue;
        }
        if (colorString.equalsIgnoreCase("orange")) {
            return Color.orange;
        }
        if (colorString.equalsIgnoreCase("yellow")) {
            return Color.yellow;
        }
        if (colorString.equalsIgnoreCase("pink")) {
            return Color.pink;
        }
        if (colorString.equalsIgnoreCase("turqoise")) {
            return new Color(0, 255, 255);
        }
        if (colorString.equalsIgnoreCase("gray")) {
            return Color.gray;
        }
        if (colorString.equalsIgnoreCase("none")) {
            return null;
        }
        try {
            value = (int)Long.parseLong(colorString, 16);
        }
        catch (NumberFormatException nfe) {
            value = Long.decode(colorString).intValue();
        }
        return new Color(value);
    }

    public static String getHexColorString(Color color) {
        return Integer.toHexString(color.getRGB() & 0xFFFFFF | color.getAlpha() << 24);
    }

    public static String readFile(String filename) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(filename)));
        StringBuffer result = new StringBuffer();
        String tmp = reader.readLine();
        while (tmp != null) {
            result.append(String.valueOf(tmp) + "\n");
            tmp = reader.readLine();
        }
        reader.close();
        return result.toString();
    }

    public static void writeFile(String contents, String filename) throws IOException {
        FileWriter fw = new FileWriter(filename);
        fw.write(contents);
        fw.flush();
        fw.close();
    }

    public static String getMd5Hash(String text) {
        StringBuffer result = new StringBuffer(32);
        try {
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            md5.update(text.getBytes());
            Formatter f = new Formatter(result);
            byte[] digest = md5.digest();
            int i = 0;
            while (i < digest.length) {
                f.format("%02x", new Byte(digest[i]));
                ++i;
            }
        }
        catch (NoSuchAlgorithmException ex) {
            ex.printStackTrace();
        }
        return result.toString();
    }

    public static boolean isNode(Object value, String nodeName) {
        return mxUtils.isNode(value, nodeName, null, null);
    }

    public static boolean isNode(Object value, String nodeName, String attributeName, String attributeValue) {
        if (value instanceof Element) {
            Element element = (Element)value;
            if (nodeName == null || element.getNodeName().equalsIgnoreCase(nodeName)) {
                String tmp;
                String string = tmp = attributeName != null ? element.getAttribute(attributeName) : null;
                return attributeName == null || tmp != null && tmp.equals(attributeValue);
            }
        }
        return false;
    }

    public static void setAntiAlias(Graphics2D g, boolean antiAlias, boolean textAntiAlias) {
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, antiAlias ? RenderingHints.VALUE_ANTIALIAS_ON : RenderingHints.VALUE_ANTIALIAS_OFF);
        g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, textAntiAlias ? RenderingHints.VALUE_TEXT_ANTIALIAS_ON : RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
    }

    public static void clearRect(Graphics2D g, Rectangle rect, Color background) {
        if (background != null) {
            g.setColor(background);
            g.fillRect(rect.x, rect.y, rect.width, rect.height);
        } else {
            g.setComposite(AlphaComposite.getInstance(1, 0.0f));
            g.fillRect(rect.x, rect.y, rect.width, rect.height);
            g.setComposite(AlphaComposite.SrcOver);
        }
    }

    public static BufferedImage createBufferedImage(int w, int h, Color background) throws OutOfMemoryError {
        BufferedImage result = null;
        if (w > 0 && h > 0) {
            Runtime runtime = Runtime.getRuntime();
            long maxMemory = runtime.maxMemory();
            long allocatedMemory = runtime.totalMemory();
            int bytes = 4;
            long memoryRequired = w * h * bytes / 1024;
            long freeMemory = runtime.freeMemory();
            long totalFreeMemory = (freeMemory + (maxMemory - allocatedMemory)) / 1024L;
            if (memoryRequired <= totalFreeMemory) {
                int type = background != null ? 1 : 2;
                result = new BufferedImage(w, h, type);
                if (background != null) {
                    Graphics2D g2 = result.createGraphics();
                    mxUtils.clearRect(g2, new Rectangle(w, h), background);
                    g2.dispose();
                }
            } else {
                throw new OutOfMemoryError("Not enough memory for image (" + w + " x " + h + ")");
            }
        }
        return result;
    }

    public static BufferedImage loadImage(String url) {
        BufferedImage img = null;
        if (url != null) {
            if (url.startsWith("data:image/")) {
                try {
                    int comma = url.indexOf(44);
                    byte[] data = mxBase64.decode(url.substring(comma + 1));
                    ByteArrayInputStream is = new ByteArrayInputStream(data);
                    img = ImageIO.read(is);
                }
                catch (Exception comma) {}
            } else {
                URL realUrl = null;
                try {
                    realUrl = new URL(url);
                }
                catch (Exception e) {
                    realUrl = mxUtils.class.getResource(url);
                }
                if (realUrl != null) {
                    try {
                        img = ImageIO.read(realUrl);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        return img;
    }

    public static Element createTable(Document document, String text, int x, int y, int w, int h, double scale, Map<String, Object> style) {
        Element table = document.createElement("table");
        if (text != null && text.length() > 0) {
            float opacity;
            String border;
            String background;
            Element tr = document.createElement("tr");
            Element td = document.createElement("td");
            table.setAttribute("cellspacing", "0");
            table.setAttribute("border", "0");
            td.setAttribute("align", mxUtils.getString(style, mxConstants.STYLE_ALIGN, "center"));
            String fontColor = mxUtils.getString(style, mxConstants.STYLE_FONTCOLOR, "black");
            String fontFamily = mxUtils.getString(style, mxConstants.STYLE_FONTFAMILY, mxConstants.DEFAULT_FONTFAMILIES);
            int fontSize = (int)((double)mxUtils.getInt(style, mxConstants.STYLE_FONTSIZE, mxConstants.DEFAULT_FONTSIZE) * scale);
            String s = "position:absolute;left:" + String.valueOf(x) + "px;" + "top:" + String.valueOf(y) + "px;" + "width:" + String.valueOf(w) + "px;" + "height:" + String.valueOf(h) + "px;" + "font-size:" + String.valueOf(fontSize) + "px;" + "font-family:" + fontFamily + ";" + "color:" + fontColor + ";";
            if (mxUtils.getString(style, mxConstants.STYLE_WHITE_SPACE, "nowrap").equals("wrap")) {
                s = String.valueOf(s) + "whiteSpace:wrap;";
            }
            if ((background = mxUtils.getString(style, mxConstants.STYLE_LABEL_BACKGROUNDCOLOR)) != null) {
                s = String.valueOf(s) + "background:" + background + ";";
            }
            if ((border = mxUtils.getString(style, mxConstants.STYLE_LABEL_BORDERCOLOR)) != null) {
                s = String.valueOf(s) + "border:" + border + " solid 1pt;";
            }
            if ((opacity = mxUtils.getFloat(style, mxConstants.STYLE_TEXT_OPACITY, 100.0f)) < 100.0f) {
                s = String.valueOf(s) + "filter:alpha(opacity=" + opacity + ");";
                s = String.valueOf(s) + "opacity:" + opacity / 100.0f + ";";
            }
            td.setAttribute("style", s);
            String[] lines = text.split("\n");
            int i = 0;
            while (i < lines.length) {
                td.appendChild(document.createTextNode(lines[i]));
                td.appendChild(document.createElement("br"));
                ++i;
            }
            tr.appendChild(td);
            table.appendChild(tr);
        }
        return table;
    }

    public static Document createDocument() {
        Document result = null;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder parser = factory.newDocumentBuilder();
            result = parser.newDocument();
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
        return result;
    }

    public static Document createSvgDocument(int width, int height) {
        Document document = mxUtils.createDocument();
        Element root = document.createElement("svg");
        String w = String.valueOf(width);
        String h = String.valueOf(height);
        root.setAttribute("width", w);
        root.setAttribute("height", h);
        root.setAttribute("viewBox", "0 0 " + w + " " + h);
        root.setAttribute("version", "1.1");
        root.setAttribute("xmlns", mxConstants.NS_SVG);
        root.setAttribute("xmlns:xlink", mxConstants.NS_XLINK);
        document.appendChild(root);
        return document;
    }

    public static Document createVmlDocument() {
        Document document = mxUtils.createDocument();
        Element root = document.createElement("html");
        root.setAttribute("xmlns:v", "urn:schemas-microsoft-com:vml");
        root.setAttribute("xmlns:o", "urn:schemas-microsoft-com:office:office");
        document.appendChild(root);
        Element head = document.createElement("head");
        Element style = document.createElement("style");
        style.setAttribute("type", "text/css");
        style.appendChild(document.createTextNode("<!-- v\\:* {behavior: url(#default#VML);} -->"));
        head.appendChild(style);
        root.appendChild(head);
        Element body = document.createElement("body");
        root.appendChild(body);
        return document;
    }

    public static Document createHtmlDocument() {
        Document document = mxUtils.createDocument();
        Element root = document.createElement("html");
        document.appendChild(root);
        Element head = document.createElement("head");
        root.appendChild(head);
        Element body = document.createElement("body");
        root.appendChild(body);
        return document;
    }

    public static String createHtmlDocument(Map<String, Object> style, String text) {
        return mxUtils.createHtmlDocument(style, text, 1.0);
    }

    public static String createHtmlDocument(Map<String, Object> style, String text, double scale) {
        String align;
        int fontStyle;
        StringBuffer css = new StringBuffer();
        css.append("font-family:" + mxUtils.getString(style, mxConstants.STYLE_FONTFAMILY, mxConstants.DEFAULT_FONTFAMILIES) + ";");
        css.append("font-size:" + (int)((double)mxUtils.getInt(style, mxConstants.STYLE_FONTSIZE, mxConstants.DEFAULT_FONTSIZE) * scale) + " pt;");
        String color = mxUtils.getString(style, mxConstants.STYLE_FONTCOLOR);
        if (color != null) {
            css.append("color:" + color + ";");
        }
        if (((fontStyle = mxUtils.getInt(style, mxConstants.STYLE_FONTSTYLE)) & 1) == 1) {
            css.append("font-weight:bold;");
        }
        if ((fontStyle & 2) == 2) {
            css.append("font-style:italic;");
        }
        if ((fontStyle & 4) == 4) {
            css.append("text-decoration:underline;");
        }
        if ((align = mxUtils.getString(style, mxConstants.STYLE_ALIGN, "left")).equals("center")) {
            css.append("text-align:center;");
        } else if (align.equals("right")) {
            css.append("text-align:right;");
        }
        return "<html><body style=\"" + css.toString() + "\">" + text + "</body></html>";
    }

    public static HTMLDocument createHtmlDocumentObject(Map<String, Object> style, double scale) {
        String align;
        int fontStyle;
        HTMLDocument document = new HTMLDocument();
        StringBuffer rule = new StringBuffer("body {");
        rule.append(" font-family: " + mxUtils.getString(style, mxConstants.STYLE_FONTFAMILY, mxConstants.DEFAULT_FONTFAMILIES) + " ; ");
        rule.append(" font-size: " + (int)((double)mxUtils.getInt(style, mxConstants.STYLE_FONTSIZE, mxConstants.DEFAULT_FONTSIZE) * scale) + " pt ;");
        String color = mxUtils.getString(style, mxConstants.STYLE_FONTCOLOR);
        if (color != null) {
            rule.append("color: " + color + " ; ");
        }
        if (((fontStyle = mxUtils.getInt(style, mxConstants.STYLE_FONTSTYLE)) & 1) == 1) {
            rule.append(" font-weight: bold ; ");
        }
        if ((fontStyle & 2) == 2) {
            rule.append(" font-style: italic ; ");
        }
        if ((fontStyle & 4) == 4) {
            rule.append(" text-decoration: underline ; ");
        }
        if ((align = mxUtils.getString(style, mxConstants.STYLE_ALIGN, "left")).equals("center")) {
            rule.append(" text-align: center ; ");
        } else if (align.equals("right")) {
            rule.append(" text-align: right ; ");
        }
        rule.append(" } ");
        document.getStyleSheet().addRule(rule.toString());
        return document;
    }

    public static Document loadDocument(String uri) {
        try {
            DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
            return docBuilder.parse(uri);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Document parse(String xml) {
        return mxUtils.parseXml(xml);
    }

    public static Document parseXml(String xml) {
        try {
            DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
            return docBuilder.parse(new InputSource(new StringReader(xml)));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Object eval(String expression) {
        Class<?> clazz;
        int dot = expression.lastIndexOf(".");
        if (dot > 0 && (clazz = mxCodecRegistry.getClassForName(expression.substring(0, dot))) != null) {
            try {
                return clazz.getField(expression.substring(dot + 1)).get(null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return expression;
    }

    public static Node findNode(Node node, String attr, String value) {
        String tmp;
        String string = tmp = node instanceof Element ? ((Element)node).getAttribute(attr) : null;
        if (tmp != null && tmp.equals(value)) {
            return node;
        }
        node = node.getFirstChild();
        while (node != null) {
            Node result = mxUtils.findNode(node, attr, value);
            if (result != null) {
                return result;
            }
            node = node.getNextSibling();
        }
        return null;
    }

    public static Node selectSingleNode(Document doc, String expression) {
        try {
            XPath xpath = XPathFactory.newInstance().newXPath();
            return (Node)xpath.evaluate(expression, doc, XPathConstants.NODE);
        }
        catch (XPathExpressionException xPathExpressionException) {
            return null;
        }
    }

    public static String htmlEntities(String text) {
        return text.replaceAll("&", "&amp;").replaceAll("\"", "&quot;").replaceAll("'", "&prime;").replaceAll("<", "&lt;").replaceAll(">", "&gt;");
    }

    public static String getXml(Node node) {
        try {
            Transformer tf = TransformerFactory.newInstance().newTransformer();
            tf.setOutputProperty("omit-xml-declaration", "yes");
            tf.setOutputProperty("encoding", "UTF-8");
            StreamResult dest = new StreamResult(new StringWriter());
            tf.transform(new DOMSource(node), dest);
            return dest.getWriter().toString();
        }
        catch (Exception exception) {
            return "";
        }
    }

    public static String getPrettyXml(Node node) {
        return mxUtils.getPrettyXml(node, "  ", "");
    }

    public static String getPrettyXml(Node node, String tab, String indent) {
        StringBuffer result = new StringBuffer();
        if (node != null) {
            if (node.getNodeType() == 3) {
                result.append(node.getNodeValue());
            } else {
                Node tmp;
                result.append(String.valueOf(indent) + "<" + node.getNodeName());
                NamedNodeMap attrs = node.getAttributes();
                if (attrs != null) {
                    int i = 0;
                    while (i < attrs.getLength()) {
                        String value = attrs.item(i).getNodeValue();
                        value = mxUtils.htmlEntities(value);
                        result.append(" " + attrs.item(i).getNodeName() + "=\"" + value + "\"");
                        ++i;
                    }
                }
                if ((tmp = node.getFirstChild()) != null) {
                    result.append(">\n");
                    while (tmp != null) {
                        result.append(mxUtils.getPrettyXml(tmp, tab, String.valueOf(indent) + tab));
                        tmp = tmp.getNextSibling();
                    }
                    result.append(String.valueOf(indent) + "</" + node.getNodeName() + ">\n");
                } else {
                    result.append("/>\n");
                }
            }
        }
        return result.toString();
    }
}

