/*
 * Decompiled with CFR 0.152.
 */
package com.mxgraph.util;

import java.util.Arrays;

public class mxSpline1D {
    protected double[] len;
    protected double[] pos1D;
    protected double[] a;
    protected double[] b;
    protected double[] c;
    protected double[] d;
    private int storageIndex = 0;

    public mxSpline1D(double[] controlPointProportions, double[] positions1D) {
        this.setValues(controlPointProportions, positions1D);
    }

    public void setValues(double[] controlPointProportions, double[] positions1D) {
        this.len = controlPointProportions;
        this.pos1D = positions1D;
        if (this.len.length > 1) {
            this.calculateCoefficients();
        }
    }

    public double getValue(double x) {
        if (this.len.length == 0) {
            return Double.NaN;
        }
        if (this.len.length == 1) {
            if (this.len[0] == x) {
                return this.pos1D[0];
            }
            return Double.NaN;
        }
        int index = Arrays.binarySearch(this.len, x);
        if (index > 0) {
            return this.pos1D[index];
        }
        if ((index = -(index + 1) - 1) < 0) {
            return this.pos1D[0];
        }
        return this.a[index] + this.b[index] * (x - this.len[index]) + this.c[index] * Math.pow(x - this.len[index], 2.0) + this.d[index] * Math.pow(x - this.len[index], 3.0);
    }

    public double getFastValue(double x) {
        if (this.storageIndex <= -1 || this.storageIndex >= this.len.length - 1 || !(x > this.len[this.storageIndex]) || !(x < this.len[this.storageIndex + 1])) {
            int index = Arrays.binarySearch(this.len, x);
            if (index > 0) {
                return this.pos1D[index];
            }
            this.storageIndex = index = -(index + 1) - 1;
        }
        if (this.storageIndex < 0) {
            return this.pos1D[0];
        }
        double value = x - this.len[this.storageIndex];
        return this.a[this.storageIndex] + this.b[this.storageIndex] * value + this.c[this.storageIndex] * (value * value) + this.d[this.storageIndex] * (value * value * value);
    }

    public double getDx(double x) {
        if (this.len.length == 0 || this.len.length == 1) {
            return 0.0;
        }
        int index = Arrays.binarySearch(this.len, x);
        if (index < 0) {
            index = -(index + 1) - 1;
        }
        return this.b[index] + 2.0 * this.c[index] * (x - this.len[index]) + 3.0 * this.d[index] * Math.pow(x - this.len[index], 2.0);
    }

    private void calculateCoefficients() {
        int N = this.pos1D.length;
        this.a = new double[N];
        this.b = new double[N];
        this.c = new double[N];
        this.d = new double[N];
        if (N == 2) {
            this.a[0] = this.pos1D[0];
            this.b[0] = this.pos1D[1] - this.pos1D[0];
            return;
        }
        double[] h = new double[N - 1];
        int i = 0;
        while (i < N - 1) {
            this.a[i] = this.pos1D[i];
            h[i] = this.len[i + 1] - this.len[i];
            if (h[i] == 0.0) {
                h[i] = 0.01;
            }
            ++i;
        }
        this.a[N - 1] = this.pos1D[N - 1];
        double[][] A = new double[N - 2][N - 2];
        double[] y = new double[N - 2];
        int i2 = 0;
        while (i2 < N - 2) {
            y[i2] = 3.0 * ((this.pos1D[i2 + 2] - this.pos1D[i2 + 1]) / h[i2 + 1] - (this.pos1D[i2 + 1] - this.pos1D[i2]) / h[i2]);
            A[i2][i2] = 2.0 * (h[i2] + h[i2 + 1]);
            if (i2 > 0) {
                A[i2][i2 - 1] = h[i2];
            }
            if (i2 < N - 3) {
                A[i2][i2 + 1] = h[i2 + 1];
            }
            ++i2;
        }
        this.solve(A, y);
        i2 = 0;
        while (i2 < N - 2) {
            this.c[i2 + 1] = y[i2];
            this.b[i2] = (this.a[i2 + 1] - this.a[i2]) / h[i2] - (2.0 * this.c[i2] + this.c[i2 + 1]) / 3.0 * h[i2];
            this.d[i2] = (this.c[i2 + 1] - this.c[i2]) / (3.0 * h[i2]);
            ++i2;
        }
        this.b[N - 2] = (this.a[N - 1] - this.a[N - 2]) / h[N - 2] - (2.0 * this.c[N - 2] + this.c[N - 1]) / 3.0 * h[N - 2];
        this.d[N - 2] = (this.c[N - 1] - this.c[N - 2]) / (3.0 * h[N - 2]);
    }

    public void solve(double[][] A, double[] b) {
        int n = b.length;
        int i = 1;
        while (i < n) {
            A[i][i - 1] = A[i][i - 1] / A[i - 1][i - 1];
            A[i][i] = A[i][i] - A[i - 1][i] * A[i][i - 1];
            b[i] = b[i] - A[i][i - 1] * b[i - 1];
            ++i;
        }
        b[n - 1] = b[n - 1] / A[n - 1][n - 1];
        i = b.length - 2;
        while (i >= 0) {
            b[i] = (b[i] - A[i][i + 1] * b[i + 1]) / A[i][i];
            --i;
        }
    }
}

