/*
 * Decompiled with CFR 0.152.
 */
package com.mxgraph.util;

import com.mxgraph.util.mxPoint;
import com.mxgraph.util.mxSpline1D;
import java.util.List;

public class mxSpline {
    private double[] t;
    private mxSpline1D splineX;
    private mxSpline1D splineY;
    private double length;

    public mxSpline(List<mxPoint> points) {
        if (points != null) {
            double[] x = new double[points.size()];
            double[] y = new double[points.size()];
            int i = 0;
            for (mxPoint point : points) {
                x[i] = point.getX();
                y[i++] = point.getY();
            }
            this.init(x, y);
        }
    }

    public void Spline2D(double[] x, double[] y) {
        this.init(x, y);
    }

    protected void init(double[] x, double[] y) {
        if (x.length != y.length) {
            return;
        }
        if (x.length < 2) {
            return;
        }
        this.t = new double[x.length];
        this.t[0] = 0.0;
        this.length = 0.0;
        int i = 1;
        while (i < this.t.length) {
            double lx = x[i] - x[i - 1];
            double ly = y[i] - y[i - 1];
            this.t[i] = 0.0 == lx ? Math.abs(ly) : (0.0 == ly ? Math.abs(lx) : Math.sqrt(lx * lx + ly * ly));
            this.length += this.t[i];
            int n = i;
            this.t[n] = this.t[n] + this.t[i - 1];
            ++i;
        }
        int j = 1;
        while (j < this.t.length - 1) {
            this.t[j] = this.t[j] / this.length;
            ++j;
        }
        this.t[this.t.length - 1] = 1.0;
        this.splineX = new mxSpline1D(this.t, x);
        this.splineY = new mxSpline1D(this.t, y);
    }

    public mxPoint getPoint(double t) {
        mxPoint result = new mxPoint(this.splineX.getValue(t), this.splineY.getValue(t));
        return result;
    }

    public boolean checkValues() {
        return this.splineX.len.length > 1 && this.splineY.len.length > 1;
    }

    public double getDx(double t) {
        return this.splineX.getDx(t);
    }

    public double getDy(double t) {
        return this.splineY.getDx(t);
    }

    public mxSpline1D getSplineX() {
        return this.splineX;
    }

    public mxSpline1D getSplineY() {
        return this.splineY;
    }

    public double getLength() {
        return this.length;
    }
}

