/*
 * Decompiled with CFR 0.152.
 */
package com.mxgraph.swing;

import com.mxgraph.swing.mxGraphComponent;
import com.mxgraph.util.mxEventObject;
import com.mxgraph.util.mxEventSource;
import com.mxgraph.util.mxPoint;
import com.mxgraph.util.mxRectangle;
import com.mxgraph.util.mxUtils;
import com.mxgraph.view.mxGraphView;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;
import javax.swing.JScrollBar;

public class mxGraphOutline
extends JComponent {
    private static final long serialVersionUID = -2521103946905154267L;
    public static Color DEFAULT_ZOOMHANDLE_FILL = new Color(0, 255, 255);
    protected mxGraphComponent graphComponent;
    protected BufferedImage tripleBuffer;
    protected Graphics2D tripleBufferGraphics;
    protected boolean repaintBuffer = false;
    protected mxRectangle repaintClip = null;
    protected boolean tripleBuffered = true;
    protected Rectangle finderBounds = new Rectangle();
    protected Point zoomHandleLocation = null;
    protected boolean finderVisible = true;
    protected boolean zoomHandleVisible = true;
    protected boolean useScaledInstance = false;
    protected boolean antiAlias = false;
    protected boolean drawLabels = false;
    protected boolean fitPage = true;
    protected int outlineBorder = 10;
    protected MouseTracker tracker = new MouseTracker();
    protected double scale = 1.0;
    protected Point translate = new Point();
    protected transient boolean zoomGesture = false;
    protected mxEventSource.mxIEventListener repaintHandler = new mxEventSource.mxIEventListener(){

        @Override
        public void invoke(Object source, mxEventObject evt) {
            mxGraphOutline.this.updateScaleAndTranslate();
            mxRectangle dirty = (mxRectangle)evt.getProperty("region");
            if (dirty != null) {
                mxGraphOutline.this.repaintClip = new mxRectangle(dirty);
            } else {
                mxGraphOutline.this.repaintBuffer = true;
            }
            if (dirty != null) {
                mxGraphOutline.this.updateFinder(true);
                dirty.grow(1.0 / mxGraphOutline.this.scale);
                dirty.setX(dirty.getX() * mxGraphOutline.this.scale + (double)mxGraphOutline.this.translate.x);
                dirty.setY(dirty.getY() * mxGraphOutline.this.scale + (double)mxGraphOutline.this.translate.y);
                dirty.setWidth(dirty.getWidth() * mxGraphOutline.this.scale);
                dirty.setHeight(dirty.getHeight() * mxGraphOutline.this.scale);
                mxGraphOutline.this.repaint(dirty.getRectangle());
            } else {
                mxGraphOutline.this.updateFinder(false);
                mxGraphOutline.this.repaint();
            }
        }
    };
    protected ComponentListener componentHandler = new ComponentAdapter(){

        @Override
        public void componentResized(ComponentEvent e) {
            if (mxGraphOutline.this.updateScaleAndTranslate()) {
                mxGraphOutline.this.repaintBuffer = true;
                mxGraphOutline.this.updateFinder(false);
                mxGraphOutline.this.repaint();
            } else {
                mxGraphOutline.this.updateFinder(true);
            }
        }
    };
    protected AdjustmentListener adjustmentHandler = new AdjustmentListener(){

        @Override
        public void adjustmentValueChanged(AdjustmentEvent e) {
            if (mxGraphOutline.this.updateScaleAndTranslate()) {
                mxGraphOutline.this.repaintBuffer = true;
                mxGraphOutline.this.updateFinder(false);
                mxGraphOutline.this.repaint();
            } else {
                mxGraphOutline.this.updateFinder(true);
            }
        }
    };

    public mxGraphOutline(mxGraphComponent graphComponent) {
        this.addComponentListener(this.componentHandler);
        this.addMouseMotionListener(this.tracker);
        this.addMouseListener(this.tracker);
        this.setGraphComponent(graphComponent);
        this.setEnabled(true);
        this.setOpaque(true);
    }

    public void setTripleBuffered(boolean tripleBuffered) {
        boolean oldValue = this.tripleBuffered;
        this.tripleBuffered = tripleBuffered;
        if (!tripleBuffered) {
            this.destroyTripleBuffer();
        }
        this.firePropertyChange("tripleBuffered", oldValue, tripleBuffered);
    }

    public boolean isTripleBuffered() {
        return this.tripleBuffered;
    }

    public void setDrawLabels(boolean drawLabels) {
        boolean oldValue = this.drawLabels;
        this.drawLabels = drawLabels;
        this.repaintTripleBuffer(null);
        this.firePropertyChange("drawLabels", oldValue, drawLabels);
    }

    public boolean isDrawLabels() {
        return this.drawLabels;
    }

    public void setAntiAlias(boolean antiAlias) {
        boolean oldValue = this.antiAlias;
        this.antiAlias = antiAlias;
        this.repaintTripleBuffer(null);
        this.firePropertyChange("antiAlias", oldValue, antiAlias);
    }

    public boolean isAntiAlias() {
        return this.antiAlias;
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (!visible) {
            this.destroyTripleBuffer();
        }
    }

    public void setFinderVisible(boolean visible) {
        this.finderVisible = visible;
    }

    public void setZoomHandleVisible(boolean visible) {
        this.zoomHandleVisible = visible;
    }

    public void setFitPage(boolean fitPage) {
        boolean oldValue = this.fitPage;
        this.fitPage = fitPage;
        if (this.updateScaleAndTranslate()) {
            this.repaintBuffer = true;
            this.updateFinder(false);
        }
        this.firePropertyChange("fitPage", oldValue, fitPage);
    }

    public boolean isFitPage() {
        return this.fitPage;
    }

    public mxGraphComponent getGraphComponent() {
        return this.graphComponent;
    }

    public void setGraphComponent(mxGraphComponent graphComponent) {
        mxGraphComponent oldValue = this.graphComponent;
        if (this.graphComponent != null) {
            this.graphComponent.getGraph().removeListener(this.repaintHandler);
            this.graphComponent.getGraphControl().removeComponentListener(this.componentHandler);
            this.graphComponent.getHorizontalScrollBar().removeAdjustmentListener(this.adjustmentHandler);
            this.graphComponent.getVerticalScrollBar().removeAdjustmentListener(this.adjustmentHandler);
        }
        this.graphComponent = graphComponent;
        if (this.graphComponent != null) {
            this.graphComponent.getGraph().addListener("repaint", this.repaintHandler);
            this.graphComponent.getGraphControl().addComponentListener(this.componentHandler);
            this.graphComponent.getHorizontalScrollBar().addAdjustmentListener(this.adjustmentHandler);
            this.graphComponent.getVerticalScrollBar().addAdjustmentListener(this.adjustmentHandler);
        }
        if (this.updateScaleAndTranslate()) {
            this.repaintBuffer = true;
            this.repaint();
        }
        this.firePropertyChange("graphComponent", oldValue, graphComponent);
    }

    public void checkTripleBuffer() {
        if (this.tripleBuffer != null && (this.tripleBuffer.getWidth() != this.getWidth() || this.tripleBuffer.getHeight() != this.getHeight())) {
            this.destroyTripleBuffer();
        }
        if (this.tripleBuffer == null) {
            this.createTripleBuffer(this.getWidth(), this.getHeight());
        }
    }

    protected void createTripleBuffer(int width, int height) {
        try {
            this.tripleBuffer = mxUtils.createBufferedImage(width, height, null);
            this.tripleBufferGraphics = this.tripleBuffer.createGraphics();
            this.repaintTripleBuffer(null);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            // empty catch block
        }
    }

    public void destroyTripleBuffer() {
        if (this.tripleBuffer != null) {
            this.tripleBuffer = null;
            this.tripleBufferGraphics.dispose();
            this.tripleBufferGraphics = null;
        }
    }

    public void repaintTripleBuffer(Rectangle clip) {
        if (this.tripleBuffered && this.tripleBufferGraphics != null) {
            if (clip == null) {
                clip = new Rectangle(this.tripleBuffer.getWidth(), this.tripleBuffer.getHeight());
            }
            mxUtils.clearRect(this.tripleBufferGraphics, clip, null);
            this.tripleBufferGraphics.setClip(clip);
            this.paintGraph(this.tripleBufferGraphics);
            this.tripleBufferGraphics.setClip(null);
            this.repaintBuffer = false;
            this.repaintClip = null;
        }
    }

    public void updateFinder(boolean repaint) {
        Rectangle rect = this.graphComponent.getViewport().getViewRect();
        int x = (int)Math.round((double)rect.x * this.scale);
        int y = (int)Math.round((double)rect.y * this.scale);
        int w = (int)Math.round((double)(rect.x + rect.width) * this.scale) - x;
        int h = (int)Math.round((double)(rect.y + rect.height) * this.scale) - y;
        this.updateFinderBounds(new Rectangle(x + this.translate.x, y + this.translate.y, w + 1, h + 1), repaint);
    }

    public void updateFinderBounds(Rectangle bounds, boolean repaint) {
        if (bounds != null && !bounds.equals(this.finderBounds)) {
            Rectangle old = new Rectangle(this.finderBounds);
            this.finderBounds = bounds;
            if (repaint) {
                old = old.union(this.finderBounds);
                old.grow(3, 3);
                this.repaint(old);
            }
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.paintBackground(g);
        if (this.graphComponent != null) {
            if (this.tripleBuffered) {
                this.checkTripleBuffer();
            } else if (this.tripleBuffer != null) {
                this.destroyTripleBuffer();
            }
            if (this.tripleBuffer != null) {
                if (this.repaintBuffer) {
                    this.repaintTripleBuffer(null);
                } else if (this.repaintClip != null) {
                    this.repaintClip.grow(1.0 / this.scale);
                    this.repaintClip.setX(this.repaintClip.getX() * this.scale + (double)this.translate.x);
                    this.repaintClip.setY(this.repaintClip.getY() * this.scale + (double)this.translate.y);
                    this.repaintClip.setWidth(this.repaintClip.getWidth() * this.scale);
                    this.repaintClip.setHeight(this.repaintClip.getHeight() * this.scale);
                    this.repaintTripleBuffer(this.repaintClip.getRectangle());
                }
                mxUtils.drawImageClip(g, this.tripleBuffer, this);
            } else {
                this.paintGraph(g);
            }
            this.paintForeground(g);
        }
    }

    protected void paintBackground(Graphics g) {
        if (this.graphComponent != null) {
            Graphics2D g2 = (Graphics2D)g;
            AffineTransform tx = g2.getTransform();
            try {
                g.setColor(this.graphComponent.getPageBackgroundColor());
                mxUtils.fillClippedRect(g, 0, 0, this.getWidth(), this.getHeight());
                g2.translate(this.translate.x, this.translate.y);
                g2.scale(this.scale, this.scale);
                if (!this.graphComponent.isPageVisible()) {
                    g.setColor(this.graphComponent.getBackground());
                    Dimension size = this.graphComponent.getGraphControl().getSize();
                    mxUtils.fillClippedRect(g, 0, 0, size.width, size.height);
                    g.setColor(g.getColor().darker().darker());
                    g.drawRect(0, 0, size.width, size.height);
                }
                this.graphComponent.paintBackgroundPage(g);
            }
            finally {
                g2.setTransform(tx);
            }
        } else {
            g.setColor(this.getBackground());
            mxUtils.fillClippedRect(g, 0, 0, this.getWidth(), this.getHeight());
        }
    }

    public void paintGraph(Graphics g) {
        if (this.graphComponent != null) {
            Graphics2D g2 = (Graphics2D)g;
            AffineTransform tx = g2.getTransform();
            try {
                g2.translate(this.translate.x, this.translate.y);
                g2.scale(this.scale, this.scale);
                this.graphComponent.getGraphControl().drawGraph(g2, this.drawLabels);
            }
            finally {
                g2.setTransform(tx);
            }
        }
    }

    protected void paintForeground(Graphics g) {
        if (this.graphComponent != null) {
            Graphics2D g2 = (Graphics2D)g;
            Stroke stroke = g2.getStroke();
            g.setColor(Color.BLUE);
            g2.setStroke(new BasicStroke(3.0f));
            g.drawRect(this.finderBounds.x, this.finderBounds.y, this.finderBounds.width, this.finderBounds.height);
            g2.setStroke(stroke);
            g.setColor(DEFAULT_ZOOMHANDLE_FILL);
            g.fillRect(this.finderBounds.x + this.finderBounds.width - 6, this.finderBounds.y + this.finderBounds.height - 6, 8, 8);
            g.setColor(Color.BLACK);
            g.drawRect(this.finderBounds.x + this.finderBounds.width - 6, this.finderBounds.y + this.finderBounds.height - 6, 8, 8);
        }
    }

    public boolean updateScaleAndTranslate() {
        double newScale = 1.0;
        int dx = 0;
        int dy = 0;
        if (this.graphComponent != null) {
            Dimension graphSize = this.graphComponent.getGraphControl().getSize();
            Dimension outlineSize = this.getSize();
            int gw = (int)graphSize.getWidth();
            int gh = (int)graphSize.getHeight();
            if (gw > 0 && gh > 0) {
                boolean magnifyPage = this.graphComponent.isPageVisible() && this.isFitPage() && this.graphComponent.getHorizontalScrollBar().isVisible() && this.graphComponent.getVerticalScrollBar().isVisible();
                double graphScale = this.graphComponent.getGraph().getView().getScale();
                mxPoint trans = this.graphComponent.getGraph().getView().getTranslate();
                int w = (int)outlineSize.getWidth() - 2 * this.outlineBorder;
                int h = (int)outlineSize.getHeight() - 2 * this.outlineBorder;
                if (magnifyPage) {
                    gw = (int)((long)gw - 2L * Math.round(trans.getX() * graphScale));
                    gh = (int)((long)gh - 2L * Math.round(trans.getY() * graphScale));
                }
                newScale = Math.min((double)w / (double)gw, (double)h / (double)gh);
                dx += (int)Math.round((outlineSize.getWidth() - (double)gw * newScale) / 2.0);
                dy += (int)Math.round((outlineSize.getHeight() - (double)gh * newScale) / 2.0);
                if (magnifyPage) {
                    dx = (int)((long)dx - Math.round(trans.getX() * newScale * graphScale));
                    dy = (int)((long)dy - Math.round(trans.getY() * newScale * graphScale));
                }
            }
        }
        if (newScale != this.scale || this.translate.x != dx || this.translate.y != dy) {
            this.scale = newScale;
            this.translate.setLocation(dx, dy);
            return true;
        }
        return false;
    }

    public class MouseTracker
    implements MouseListener,
    MouseMotionListener {
        protected Point start = null;

        @Override
        public void mousePressed(MouseEvent e) {
            mxGraphOutline.this.zoomGesture = this.hitZoomHandle(e.getX(), e.getY());
            if (mxGraphOutline.this.graphComponent != null && !e.isConsumed() && !e.isPopupTrigger() && (mxGraphOutline.this.finderBounds.contains(e.getPoint()) || mxGraphOutline.this.zoomGesture)) {
                this.start = e.getPoint();
            }
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (mxGraphOutline.this.isEnabled() && this.start != null) {
                if (mxGraphOutline.this.zoomGesture) {
                    Rectangle bounds = mxGraphOutline.this.graphComponent.getViewport().getViewRect();
                    double viewRatio = bounds.getWidth() / bounds.getHeight();
                    bounds = new Rectangle(mxGraphOutline.this.finderBounds);
                    bounds.width = (int)Math.max(0.0, (double)e.getX() - bounds.getX());
                    bounds.height = (int)Math.max(0.0, bounds.getWidth() / viewRatio);
                    mxGraphOutline.this.updateFinderBounds(bounds, true);
                } else {
                    int dx = (int)(((double)e.getX() - this.start.getX()) / mxGraphOutline.this.scale);
                    int dy = (int)(((double)e.getY() - this.start.getY()) / mxGraphOutline.this.scale);
                    this.start = e.getPoint();
                    mxGraphOutline.this.graphComponent.getHorizontalScrollBar().setValue(mxGraphOutline.this.graphComponent.getHorizontalScrollBar().getValue() + dx);
                    mxGraphOutline.this.graphComponent.getVerticalScrollBar().setValue(mxGraphOutline.this.graphComponent.getVerticalScrollBar().getValue() + dy);
                }
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (this.start != null) {
                if (mxGraphOutline.this.zoomGesture) {
                    double dx = (double)e.getX() - this.start.getX();
                    double w = mxGraphOutline.this.finderBounds.getWidth();
                    JScrollBar hs = mxGraphOutline.this.graphComponent.getHorizontalScrollBar();
                    double sx = hs != null ? (double)hs.getValue() / (double)hs.getMaximum() : 0.0;
                    JScrollBar vs = mxGraphOutline.this.graphComponent.getVerticalScrollBar();
                    double sy = vs != null ? (double)vs.getValue() / (double)vs.getMaximum() : 0.0;
                    mxGraphView view = mxGraphOutline.this.graphComponent.getGraph().getView();
                    double scale = view.getScale();
                    double newScale = scale - dx * scale / w;
                    double factor = newScale / scale;
                    view.setScale(newScale);
                    if (hs != null) {
                        hs.setValue((int)(sx * (double)hs.getMaximum() * factor));
                    }
                    if (vs != null) {
                        vs.setValue((int)(sy * (double)vs.getMaximum() * factor));
                    }
                }
                mxGraphOutline.this.zoomGesture = false;
                this.start = null;
            }
        }

        public boolean hitZoomHandle(int x, int y) {
            return new Rectangle(mxGraphOutline.this.finderBounds.x + mxGraphOutline.this.finderBounds.width - 6, mxGraphOutline.this.finderBounds.y + mxGraphOutline.this.finderBounds.height - 6, 8, 8).contains(x, y);
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            if (this.hitZoomHandle(e.getX(), e.getY())) {
                mxGraphOutline.this.setCursor(new Cursor(12));
            } else if (mxGraphOutline.this.finderBounds.contains(e.getPoint())) {
                mxGraphOutline.this.setCursor(new Cursor(13));
            } else {
                mxGraphOutline.this.setCursor(new Cursor(0));
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }
    }
}

