/*
 * Decompiled with CFR 0.152.
 */
package com.mxgraph.swing.handler;

import com.mxgraph.model.mxGeometry;
import com.mxgraph.model.mxIGraphModel;
import com.mxgraph.swing.handler.mxCellHandler;
import com.mxgraph.swing.handler.mxCellMarker;
import com.mxgraph.swing.mxGraphComponent;
import com.mxgraph.util.mxConstants;
import com.mxgraph.util.mxPoint;
import com.mxgraph.view.mxCellState;
import com.mxgraph.view.mxConnectionConstraint;
import com.mxgraph.view.mxGraph;
import com.mxgraph.view.mxGraphView;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import java.awt.geom.Line2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class mxEdgeHandler
extends mxCellHandler {
    protected boolean cloneEnabled = true;
    protected Point[] p;
    protected transient String error;
    protected transient boolean gridEnabledEvent = false;
    protected transient boolean constrainedEvent = false;
    protected mxCellMarker marker = new mxCellMarker(this.graphComponent){
        private static final long serialVersionUID = 8826073441093831764L;

        @Override
        protected Object getCell(MouseEvent e) {
            mxGraph graph = this.graphComponent.getGraph();
            mxIGraphModel model = graph.getModel();
            Object cell = super.getCell(e);
            if (cell == mxEdgeHandler.this.state.getCell() || !graph.isConnectableEdges() && model.isEdge(cell)) {
                cell = null;
            }
            return cell;
        }

        @Override
        protected boolean isValidState(mxCellState state) {
            mxIGraphModel model = this.graphComponent.getGraph().getModel();
            Object edge = mxEdgeHandler.this.state.getCell();
            boolean isSource = mxEdgeHandler.this.isSource(mxEdgeHandler.this.index);
            Object other = model.getTerminal(edge, !isSource);
            Object source = isSource ? state.getCell() : other;
            Object target = isSource ? other : state.getCell();
            mxEdgeHandler.this.error = mxEdgeHandler.this.validateConnection(source, target);
            return mxEdgeHandler.this.error == null;
        }
    };

    public mxEdgeHandler(mxGraphComponent graphComponent, mxCellState state) {
        super(graphComponent, state);
    }

    public void setCloneEnabled(boolean cloneEnabled) {
        this.cloneEnabled = cloneEnabled;
    }

    public boolean isCloneEnabled() {
        return this.cloneEnabled;
    }

    @Override
    protected boolean isIgnoredEvent(MouseEvent e) {
        return !this.isFlipEvent(e) && super.isIgnoredEvent(e);
    }

    protected boolean isFlipEvent(MouseEvent e) {
        return false;
    }

    public String validateConnection(Object source, Object target) {
        return this.graphComponent.getGraph().getEdgeValidationError(this.state.getCell(), source, target);
    }

    public boolean isSource(int index) {
        return index == 0;
    }

    public boolean isTarget(int index) {
        return index == this.getHandleCount() - 2;
    }

    @Override
    protected boolean isHandleVisible(int index) {
        return super.isHandleVisible(index) && (index != 1 || this.isCellBendable());
    }

    protected boolean isCellBendable() {
        return this.graphComponent.getGraph().isCellBendable(this.state.getCell());
    }

    @Override
    protected Rectangle[] createHandles() {
        this.p = this.createPoints(this.state);
        Rectangle[] h = new Rectangle[this.p.length + 1];
        int i = 0;
        while (i < h.length - 1) {
            h[i] = this.createHandle(this.p[i]);
            ++i;
        }
        h[this.p.length] = this.createHandle(this.state.getAbsoluteOffset().getPoint(), mxConstants.LABEL_HANDLE_SIZE);
        return h;
    }

    @Override
    protected Color getHandleFillColor(int index) {
        mxGraph graph;
        Object terminal;
        boolean source = this.isSource(index);
        if ((source || this.isTarget(index)) && (terminal = (graph = this.graphComponent.getGraph()).getModel().getTerminal(this.state.getCell(), source)) != null) {
            return this.graphComponent.getGraph().isCellDisconnectable(this.state.getCell(), terminal, source) ? mxConstants.CONNECT_HANDLE_FILLCOLOR : mxConstants.LOCKED_HANDLE_FILLCOLOR;
        }
        return super.getHandleFillColor(index);
    }

    @Override
    public int getIndexAt(int x, int y) {
        int index = super.getIndexAt(x, y);
        if (index < 0 && this.handles != null && this.handlesVisible && this.isLabelMovable() && this.state.getLabelBounds().getRectangle().contains(x, y)) {
            index = this.handles.length - 1;
        }
        return index;
    }

    protected Rectangle createHandle(Point center) {
        return this.createHandle(center, mxConstants.HANDLE_SIZE);
    }

    protected Rectangle createHandle(Point center, int size) {
        return new Rectangle(center.x - size / 2, center.y - size / 2, size, size);
    }

    protected Point[] createPoints(mxCellState s) {
        Point[] pts = new Point[s.getAbsolutePointCount()];
        int i = 0;
        while (i < pts.length) {
            pts[i] = s.getAbsolutePoint(i).getPoint();
            ++i;
        }
        return pts;
    }

    @Override
    protected JComponent createPreview() {
        JPanel preview = new JPanel(){
            private static final long serialVersionUID = -894546588972313020L;

            @Override
            public void paint(Graphics g) {
                super.paint(g);
                if (!mxEdgeHandler.this.isLabel(mxEdgeHandler.this.index) && mxEdgeHandler.this.p != null) {
                    ((Graphics2D)g).setStroke(mxConstants.PREVIEW_STROKE);
                    if (mxEdgeHandler.this.isSource(mxEdgeHandler.this.index) || mxEdgeHandler.this.isTarget(mxEdgeHandler.this.index)) {
                        if (mxEdgeHandler.this.marker.hasValidState() || mxEdgeHandler.this.graphComponent.getGraph().isAllowDanglingEdges()) {
                            g.setColor(mxConstants.DEFAULT_VALID_COLOR);
                        } else {
                            g.setColor(mxConstants.DEFAULT_INVALID_COLOR);
                        }
                    } else {
                        g.setColor(Color.BLACK);
                    }
                    Point origin = this.getLocation();
                    Point last = mxEdgeHandler.this.p[0];
                    int i = 1;
                    while (i < mxEdgeHandler.this.p.length) {
                        g.drawLine(last.x - origin.x, last.y - origin.y, mxEdgeHandler.this.p[i].x - origin.x, mxEdgeHandler.this.p[i].y - origin.y);
                        last = mxEdgeHandler.this.p[i];
                        ++i;
                    }
                }
            }
        };
        if (this.isLabel(this.index)) {
            preview.setBorder(mxConstants.PREVIEW_BORDER);
        }
        preview.setOpaque(false);
        preview.setVisible(false);
        return preview;
    }

    protected mxPoint convertPoint(mxPoint point, boolean gridEnabled) {
        mxGraph graph = this.graphComponent.getGraph();
        double scale = graph.getView().getScale();
        mxPoint trans = graph.getView().getTranslate();
        double x = point.getX() / scale - trans.getX();
        double y = point.getY() / scale - trans.getY();
        if (gridEnabled) {
            x = graph.snap(x);
            y = graph.snap(y);
        }
        point.setX(x - this.state.getOrigin().getX());
        point.setY(y - this.state.getOrigin().getY());
        return point;
    }

    protected Rectangle getPreviewBounds() {
        Rectangle bounds = null;
        if (this.isLabel(this.index)) {
            bounds = this.state.getLabelBounds().getRectangle();
        } else {
            bounds = new Rectangle(this.p[0]);
            int i = 0;
            while (i < this.p.length) {
                bounds.add(this.p[i]);
                ++i;
            }
            ++bounds.height;
            ++bounds.width;
        }
        return bounds;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        super.mousePressed(e);
        if (this.isSource(this.index) || this.isTarget(this.index)) {
            mxGraph graph = this.graphComponent.getGraph();
            mxIGraphModel model = graph.getModel();
            Object terminal = model.getTerminal(this.state.getCell(), this.isSource(this.index));
            if (!graph.isCellDisconnectable(this.state.getCell(), terminal, this.isSource(this.index))) {
                this.first = null;
            }
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (!e.isConsumed() && this.first != null) {
            this.gridEnabledEvent = this.graphComponent.isGridEnabledEvent(e);
            this.constrainedEvent = this.graphComponent.isConstrainedEvent(e);
            boolean isSource = this.isSource(this.index);
            boolean isTarget = this.isTarget(this.index);
            Object source = null;
            Object target = null;
            if (this.isLabel(this.index)) {
                mxPoint abs = this.state.getAbsoluteOffset();
                double dx = abs.getX() - (double)this.first.x;
                double dy = abs.getY() - (double)this.first.y;
                mxPoint pt = new mxPoint(e.getPoint());
                if (this.gridEnabledEvent) {
                    pt = this.graphComponent.snapScaledPoint(pt, dx, dy);
                }
                if (this.constrainedEvent) {
                    if (Math.abs(e.getX() - this.first.x) > Math.abs(e.getY() - this.first.y)) {
                        pt.setY(abs.getY());
                    } else {
                        pt.setX(abs.getX());
                    }
                }
                Rectangle rect = this.getPreviewBounds();
                rect.translate((int)Math.round(pt.getX() - (double)this.first.x), (int)Math.round(pt.getY() - (double)this.first.y));
                this.preview.setBounds(rect);
            } else {
                mxGeometry geometry = this.graphComponent.getGraph().getCellGeometry(this.state.getCell());
                mxCellState clone = (mxCellState)this.state.clone();
                List<mxPoint> points = geometry.getPoints();
                mxGraphView view = clone.getView();
                if (isSource || isTarget) {
                    this.marker.process(e);
                    mxCellState currentState = this.marker.getValidState();
                    target = view.getVisibleTerminal(this.state.getCell(), !isSource);
                    if (currentState != null) {
                        source = currentState.getCell();
                    } else {
                        mxPoint pt = new mxPoint(e.getPoint());
                        if (this.gridEnabledEvent) {
                            pt = this.graphComponent.snapScaledPoint(pt);
                        }
                        clone.setAbsoluteTerminalPoint(pt, isSource);
                    }
                    if (!isSource) {
                        Object tmp = source;
                        source = target;
                        target = tmp;
                    }
                } else {
                    mxPoint point = this.convertPoint(new mxPoint(e.getPoint()), this.gridEnabledEvent);
                    if (points == null) {
                        points = Arrays.asList(point);
                    } else if (this.index - 1 < points.size()) {
                        points = new ArrayList<mxPoint>(points);
                        points.set(this.index - 1, point);
                    }
                    source = view.getVisibleTerminal(this.state.getCell(), true);
                    target = view.getVisibleTerminal(this.state.getCell(), false);
                }
                mxCellState sourceState = view.getState(source);
                mxCellState targetState = view.getState(target);
                mxConnectionConstraint sourceConstraint = this.graphComponent.getGraph().getConnectionConstraint(clone, sourceState, true);
                mxConnectionConstraint targetConstraint = this.graphComponent.getGraph().getConnectionConstraint(clone, targetState, false);
                if (!isSource || sourceState != null) {
                    view.updateFixedTerminalPoint(clone, sourceState, true, sourceConstraint);
                }
                if (!isTarget || targetState != null) {
                    view.updateFixedTerminalPoint(clone, targetState, false, targetConstraint);
                }
                view.updatePoints(clone, points, sourceState, targetState);
                view.updateFloatingTerminalPoints(clone, sourceState, targetState);
                this.p = this.createPoints(clone);
                this.preview.setBounds(this.getPreviewBounds());
            }
            if (!this.preview.isVisible() && this.graphComponent.isSignificant(e.getX() - this.first.x, e.getY() - this.first.y)) {
                this.preview.setVisible(true);
            } else if (this.preview.isVisible()) {
                this.preview.repaint();
            }
            e.consume();
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        double dy;
        double dx;
        mxGraph graph = this.graphComponent.getGraph();
        if (!e.isConsumed() && this.first != null && this.graphComponent.isSignificant(dx = (double)(e.getX() - this.first.x), dy = (double)(e.getY() - this.first.y))) {
            if (this.error != null) {
                if (this.error.length() > 0) {
                    JOptionPane.showMessageDialog(this.graphComponent, this.error);
                }
            } else if (this.isLabel(this.index)) {
                mxPoint abs = this.state.getAbsoluteOffset();
                dx = abs.getX() - (double)this.first.x;
                dy = abs.getY() - (double)this.first.y;
                mxPoint pt = new mxPoint(e.getPoint());
                if (this.gridEnabledEvent) {
                    pt = this.graphComponent.snapScaledPoint(pt, dx, dy);
                }
                if (this.constrainedEvent) {
                    if (Math.abs(e.getX() - this.first.x) > Math.abs(e.getY() - this.first.y)) {
                        pt.setY(abs.getY());
                    } else {
                        pt.setX(abs.getX());
                    }
                }
                this.moveLabelTo(this.state, pt.getX() + dx, pt.getY() + dy);
            } else if (this.marker.hasValidState() && (this.isSource(this.index) || this.isTarget(this.index))) {
                this.connect(this.state.getCell(), this.marker.getValidState().getCell(), this.isSource(this.index), this.graphComponent.isCloneEvent(e) && this.isCloneEnabled());
            } else if (!this.isSource(this.index) && !this.isTarget(this.index) || this.graphComponent.getGraph().isAllowDanglingEdges()) {
                this.movePoint(this.state.getCell(), this.index, this.convertPoint(new mxPoint(e.getPoint()), this.gridEnabledEvent));
            }
            e.consume();
        }
        if (!e.isConsumed() && this.isFlipEvent(e)) {
            graph.flipEdge(this.state.getCell());
            e.consume();
        }
        super.mouseReleased(e);
    }

    @Override
    public void reset() {
        super.reset();
        this.marker.reset();
        this.error = null;
    }

    protected void movePoint(Object edge, int pointIndex, mxPoint point) {
        mxIGraphModel model = this.graphComponent.getGraph().getModel();
        mxGeometry geometry = model.getGeometry(edge);
        if (geometry != null) {
            model.beginUpdate();
            try {
                geometry = (mxGeometry)geometry.clone();
                if (this.isSource(this.index) || this.isTarget(this.index)) {
                    this.connect(edge, null, this.isSource(this.index), false);
                    geometry.setTerminalPoint(point, this.isSource(this.index));
                } else {
                    List<mxPoint> pts = geometry.getPoints();
                    if (pts == null) {
                        pts = new ArrayList<mxPoint>();
                        geometry.setPoints(pts);
                    }
                    if (pointIndex <= pts.size()) {
                        pts.set(pointIndex - 1, point);
                    } else if (pointIndex - 1 <= pts.size()) {
                        pts.add(pointIndex - 1, point);
                    }
                }
                model.setGeometry(edge, geometry);
            }
            finally {
                model.endUpdate();
            }
        }
    }

    protected void connect(Object edge, Object terminal, boolean isSource, boolean isClone) {
        mxGraph graph = this.graphComponent.getGraph();
        mxIGraphModel model = graph.getModel();
        model.beginUpdate();
        try {
            if (isClone) {
                Object clone = graph.cloneCells(new Object[]{edge})[0];
                Object parent = model.getParent(edge);
                graph.addCells(new Object[]{clone}, parent);
                Object other = model.getTerminal(edge, !isSource);
                graph.connectCell(clone, other, !isSource);
                graph.setSelectionCell(clone);
                edge = clone;
            }
            graph.connectCell(edge, terminal, isSource, new mxConnectionConstraint());
        }
        finally {
            model.endUpdate();
        }
    }

    protected void moveLabelTo(mxCellState edgeState, double x, double y) {
        mxGraph graph = this.graphComponent.getGraph();
        mxIGraphModel model = graph.getModel();
        mxGeometry geometry = model.getGeometry(this.state.getCell());
        if (geometry != null) {
            geometry = (mxGeometry)geometry.clone();
            mxPoint pt = graph.getView().getRelativePoint(edgeState, x, y);
            geometry.setX(pt.getX());
            geometry.setY(pt.getY());
            double scale = graph.getView().getScale();
            geometry.setOffset(new mxPoint(0.0, 0.0));
            pt = graph.getView().getPoint(edgeState, geometry);
            geometry.setOffset(new mxPoint(Math.round((x - pt.getX()) / scale), Math.round((y - pt.getY()) / scale)));
            model.setGeometry(edgeState.getCell(), geometry);
        }
    }

    @Override
    protected Cursor getCursor(MouseEvent e, int index) {
        Cursor cursor = null;
        cursor = this.isLabel(index) ? new Cursor(13) : new Cursor(12);
        return cursor;
    }

    @Override
    public Color getSelectionColor() {
        return mxConstants.EDGE_SELECTION_COLOR;
    }

    @Override
    public Stroke getSelectionStroke() {
        return mxConstants.EDGE_SELECTION_STROKE;
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        Stroke stroke = g2.getStroke();
        g2.setStroke(this.getSelectionStroke());
        g.setColor(this.getSelectionColor());
        Point last = this.state.getAbsolutePoint(0).getPoint();
        int i = 1;
        while (i < this.state.getAbsolutePointCount()) {
            Point current = this.state.getAbsolutePoint(i).getPoint();
            Line2D.Float line = new Line2D.Float(last.x, last.y, current.x, current.y);
            Rectangle bounds = g2.getStroke().createStrokedShape(line).getBounds();
            if (g.hitClip(bounds.x, bounds.y, bounds.width, bounds.height)) {
                g2.draw(line);
            }
            last = current;
            ++i;
        }
        g2.setStroke(stroke);
        super.paint(g);
    }
}

