/*
 * Decompiled with CFR 0.152.
 */
package com.mxgraph.shape;

import com.mxgraph.canvas.mxGraphics2DCanvas;
import com.mxgraph.shape.mxITextShape;
import com.mxgraph.util.mxConstants;
import com.mxgraph.util.mxUtils;
import com.mxgraph.view.mxCellState;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.util.Map;

public class mxDefaultTextShape
implements mxITextShape {
    @Override
    public void paintShape(mxGraphics2DCanvas canvas, String text, mxCellState state, Map<String, Object> style) {
        Rectangle rect = state.getLabelBounds().getRectangle();
        Graphics2D g = canvas.getGraphics();
        if (g.getClipBounds() == null || g.getClipBounds().intersects(rect)) {
            String[] lines;
            boolean horizontal = mxUtils.isTrue(style, mxConstants.STYLE_HORIZONTAL, true);
            double scale = canvas.getScale();
            int x = rect.x;
            int y = rect.y;
            int w = rect.width;
            int h = rect.height;
            if (!horizontal) {
                g.rotate(-1.5707963267948966, x + w / 2, y + h / 2);
                g.translate(w / 2 - h / 2, h / 2 - w / 2);
            }
            Color fontColor = mxUtils.getColor(style, mxConstants.STYLE_FONTCOLOR, Color.black);
            g.setColor(fontColor);
            Font scaledFont = mxUtils.getFont(style, scale);
            g.setFont(scaledFont);
            int fontSize = mxUtils.getInt(style, mxConstants.STYLE_FONTSIZE, mxConstants.DEFAULT_FONTSIZE);
            FontMetrics fm = g.getFontMetrics();
            int scaledFontSize = scaledFont.getSize();
            double fontScaleFactor = (double)scaledFontSize / (double)fontSize;
            double fontScaleRatio = fontScaleFactor / scale;
            y = (int)((double)y + ((double)(2 * fm.getMaxAscent() - fm.getHeight()) + (double)mxConstants.LABEL_INSET * scale));
            String vertAlign = mxUtils.getString(style, mxConstants.STYLE_VERTICAL_ALIGN, "middle");
            double vertAlignProportion = 0.5;
            if (vertAlign.equals("top")) {
                vertAlignProportion = 0.0;
            } else if (vertAlign.equals("bottom")) {
                vertAlignProportion = 1.0;
            }
            y = (int)((double)y + (1.0 - fontScaleRatio) * (double)h * vertAlignProportion);
            String align = mxUtils.getString(style, mxConstants.STYLE_ALIGN, "center");
            if (align.equals("left")) {
                x = (int)((double)x + (double)mxConstants.LABEL_INSET * scale);
            } else if (align.equals("right")) {
                x = (int)((double)x - (double)mxConstants.LABEL_INSET * scale);
            }
            if (mxUtils.getString(style, mxConstants.STYLE_WHITE_SPACE, "nowrap").equals("wrap")) {
                Font previousFont = g.getFont();
                g.setFont(mxUtils.getFont(style, 1.0));
                FontMetrics fm2 = g.getFontMetrics();
                lines = mxUtils.wordWrap(text, fm2, (int)(state.getLabelBounds().getWidth() / scale + 0.5) - mxConstants.LABEL_INSET * 2);
                g.setFont(previousFont);
            } else {
                lines = text.split("\n");
            }
            int i = 0;
            while (i < lines.length) {
                int sw;
                int dx = 0;
                if (align.equals("center")) {
                    sw = fm.stringWidth(lines[i]);
                    dx = horizontal ? (w - sw) / 2 : (h - sw) / 2;
                } else if (align.equals("right")) {
                    sw = fm.stringWidth(lines[i]);
                    dx = (horizontal ? w : h) - sw;
                }
                g.drawString(lines[i], x + dx, y);
                this.postProcessLine(text, lines[i], fm, canvas, x + dx, y);
                y += fm.getHeight() + mxConstants.LINESPACING;
                ++i;
            }
        }
    }

    protected void postProcessLine(String text, String line, FontMetrics fm, mxGraphics2DCanvas canvas, int x, int y) {
    }
}

