/*
 * Decompiled with CFR 0.152.
 */
package com.mxgraph.layout;

import com.mxgraph.layout.mxGraphLayout;
import com.mxgraph.model.mxIGraphModel;
import com.mxgraph.util.mxRectangle;
import com.mxgraph.view.mxGraph;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;

public class mxOrganicLayout
extends mxGraphLayout {
    protected boolean isOptimizeEdgeDistance = true;
    protected boolean isOptimizeEdgeCrossing = true;
    protected boolean isOptimizeEdgeLength = true;
    protected boolean isOptimizeBorderLine = true;
    protected boolean isOptimizeNodeDistribution = true;
    protected double minMoveRadius = 2.0;
    protected double moveRadius;
    protected double initialMoveRadius = 0.0;
    protected double radiusScaleFactor = 0.75;
    protected double averageNodeArea = 10000.0;
    protected double fineTuningRadius = 40.0;
    protected int maxIterations = 100;
    protected double edgeDistanceCostFactor = 4000.0;
    protected double edgeCrossingCostFactor = 2000.0;
    protected double nodeDistributionCostFactor = 300000.0;
    protected double borderLineCostFactor = 5.0;
    protected double edgeLengthCostFactor = 0.02;
    protected double boundsX = 0.0;
    protected double boundsY = 0.0;
    protected double boundsWidth = 0.0;
    protected double boundsHeight = 0.0;
    protected int iteration;
    protected int triesPerCell = 8;
    protected double minDistanceLimit = 2.0;
    protected double minDistanceLimitSquared;
    protected double maxDistanceLimit = 100.0;
    protected double maxDistanceLimitSquared;
    protected int unchangedEnergyRoundCount;
    protected int unchangedEnergyRoundTermination = 5;
    protected boolean approxNodeDimensions = true;
    protected CellWrapper[] v;
    protected CellWrapper[] e;
    protected double[] xNormTry;
    protected double[] yNormTry;
    protected boolean isFineTuning = true;

    public mxOrganicLayout(mxGraph graph) {
        super(graph);
    }

    public mxOrganicLayout(mxGraph graph, Rectangle2D bounds) {
        super(graph);
        this.boundsX = bounds.getX();
        this.boundsY = bounds.getY();
        this.boundsWidth = bounds.getWidth();
        this.boundsHeight = bounds.getHeight();
    }

    @Override
    public boolean isVertexIgnored(Object vertex) {
        return false;
    }

    @Override
    public void execute(Object parent) {
        Object[] vertices = this.graph.getChildVertices(parent);
        Object[] edges = this.graph.getChildEdges(parent);
        mxRectangle bounds = this.graph.getBoundsForCells(vertices, false, false, true);
        if (this.averageNodeArea == 0.0) {
            if (this.boundsWidth == 0.0 && bounds != null) {
                this.boundsX = bounds.getX();
                this.boundsY = bounds.getY();
                this.boundsWidth = bounds.getWidth();
                this.boundsHeight = bounds.getHeight();
            }
        } else {
            double newArea = this.averageNodeArea * (double)vertices.length;
            double squareLength = Math.sqrt(newArea);
            if (bounds != null) {
                double centreX = bounds.getX() + bounds.getWidth() / 2.0;
                double centreY = bounds.getY() + bounds.getHeight() / 2.0;
                this.boundsX = centreX - squareLength / 2.0;
                this.boundsY = centreY - squareLength / 2.0;
            } else {
                this.boundsX = 0.0;
                this.boundsY = 0.0;
            }
            this.boundsWidth = squareLength;
            this.boundsHeight = squareLength;
            if (this.boundsX < 0.0 || this.boundsY < 0.0) {
                double maxNegativeAxis = Math.min(this.boundsX, this.boundsY);
                double axisOffset = -maxNegativeAxis;
                this.boundsX += axisOffset;
                this.boundsY += axisOffset;
            }
        }
        if (this.initialMoveRadius == 0.0) {
            this.initialMoveRadius = Math.max(this.boundsWidth, this.boundsHeight) / 2.0;
        }
        this.moveRadius = this.initialMoveRadius;
        this.minDistanceLimitSquared = this.minDistanceLimit * this.minDistanceLimit;
        this.maxDistanceLimitSquared = this.maxDistanceLimit * this.maxDistanceLimit;
        this.unchangedEnergyRoundCount = 0;
        Hashtable<Object, Integer> vertexMap = new Hashtable<Object, Integer>();
        this.v = new CellWrapper[vertices.length];
        int i = 0;
        while (i < vertices.length) {
            this.v[i] = new CellWrapper(vertices[i]);
            vertexMap.put(vertices[i], new Integer(i));
            bounds = this.graph.getCellBounds(vertices[i]);
            double width = bounds.getWidth();
            double height = bounds.getHeight();
            this.v[i].x = bounds.getX() + width / 2.0;
            this.v[i].y = bounds.getY() + height / 2.0;
            if (this.approxNodeDimensions) {
                this.v[i].radiusSquared = Math.min(width, height);
                this.v[i].radiusSquared *= this.v[i].radiusSquared;
            } else {
                this.v[i].radiusSquared = width * width;
                this.v[i].heightSquared = height * height;
            }
            ++i;
        }
        this.e = new CellWrapper[edges.length];
        mxIGraphModel model = this.graph.getModel();
        int i2 = 0;
        while (i2 < this.e.length) {
            this.e[i2] = new CellWrapper(edges[i2]);
            Object sourceCell = model.getTerminal(edges[i2], true);
            Object targetCell = model.getTerminal(edges[i2], false);
            Integer source = null;
            Integer target = null;
            if (sourceCell != null) {
                source = (Integer)vertexMap.get(sourceCell);
            }
            if (targetCell != null) {
                target = (Integer)vertexMap.get(targetCell);
            }
            this.e[i2].source = source != null ? source : -1;
            this.e[i2].target = target != null ? target : -1;
            ++i2;
        }
        i2 = 0;
        while (i2 < this.v.length) {
            this.v[i2].relevantEdges = this.getRelevantEdges(i2);
            this.v[i2].connectedEdges = this.getConnectedEdges(i2);
            ++i2;
        }
        this.xNormTry = new double[this.triesPerCell];
        this.yNormTry = new double[this.triesPerCell];
        i2 = 0;
        while (i2 < this.triesPerCell) {
            double angle = (double)i2 * (Math.PI * 2 / (double)this.triesPerCell);
            this.xNormTry[i2] = Math.cos(angle);
            this.yNormTry[i2] = Math.sin(angle);
            ++i2;
        }
        this.iteration = 0;
        while (this.iteration < this.maxIterations) {
            this.performRound();
            ++this.iteration;
        }
        double[][] result = new double[this.v.length][2];
        int i3 = 0;
        while (i3 < this.v.length) {
            vertices[i3] = this.v[i3].cell;
            bounds = this.graph.getCellBounds(vertices[i3]);
            result[i3][0] = this.v[i3].x - bounds.getWidth() / 2.0;
            result[i3][1] = this.v[i3].y - bounds.getHeight() / 2.0;
            ++i3;
        }
        model.beginUpdate();
        try {
            i3 = 0;
            while (i3 < vertices.length) {
                this.setVertexLocation(vertices[i3], result[i3][0], result[i3][1]);
                ++i3;
            }
        }
        finally {
            model.endUpdate();
        }
    }

    protected void performRound() {
        double newMoveRadius;
        boolean energyHasChanged = false;
        int i = 0;
        while (i < this.v.length) {
            int index = i;
            double oldNodeDistribution = this.getNodeDistribution(index);
            double oldEdgeDistance = this.getEdgeDistanceFromNode(index);
            oldEdgeDistance += this.getEdgeDistanceAffectedNodes(index);
            double oldEdgeCrossing = this.getEdgeCrossingAffectedEdges(index);
            double oldBorderLine = this.getBorderline(index);
            double oldEdgeLength = this.getEdgeLengthAffectedEdges(index);
            double oldAdditionFactors = this.getAdditionFactorsEnergy(index);
            int j = 0;
            while (j < this.triesPerCell) {
                double movex = this.moveRadius * this.xNormTry[j];
                double movey = this.moveRadius * this.yNormTry[j];
                double oldx = this.v[index].x;
                double oldy = this.v[index].y;
                this.v[index].x += movex;
                this.v[index].y += movey;
                double energyDelta = this.calcEnergyDelta(index, oldNodeDistribution, oldEdgeDistance, oldEdgeCrossing, oldBorderLine, oldEdgeLength, oldAdditionFactors);
                if (energyDelta < 0.0) {
                    energyHasChanged = true;
                    break;
                }
                this.v[index].x = oldx;
                this.v[index].y = oldy;
                ++j;
            }
            ++i;
        }
        if (energyHasChanged) {
            this.unchangedEnergyRoundCount = 0;
        } else {
            ++this.unchangedEnergyRoundCount;
            this.moveRadius /= 2.0;
        }
        if (this.unchangedEnergyRoundCount >= this.unchangedEnergyRoundTermination) {
            this.iteration = this.maxIterations;
        }
        if (this.moveRadius - (newMoveRadius = this.moveRadius * this.radiusScaleFactor) < this.minMoveRadius) {
            newMoveRadius = this.moveRadius - this.minMoveRadius;
        }
        if (newMoveRadius <= this.minMoveRadius) {
            this.iteration = this.maxIterations;
        }
        if (newMoveRadius < this.fineTuningRadius) {
            this.isFineTuning = true;
        }
        this.moveRadius = newMoveRadius;
    }

    protected double calcEnergyDelta(int index, double oldNodeDistribution, double oldEdgeDistance, double oldEdgeCrossing, double oldBorderLine, double oldEdgeLength, double oldAdditionalFactorsEnergy) {
        double energyDelta = 0.0;
        energyDelta += this.getNodeDistribution(index) * 2.0;
        energyDelta -= oldNodeDistribution * 2.0;
        energyDelta += this.getBorderline(index);
        energyDelta -= oldBorderLine;
        energyDelta += this.getEdgeDistanceFromNode(index);
        energyDelta += this.getEdgeDistanceAffectedNodes(index);
        energyDelta -= oldEdgeDistance;
        energyDelta -= oldEdgeLength;
        energyDelta += this.getEdgeLengthAffectedEdges(index);
        energyDelta -= oldEdgeCrossing;
        energyDelta += this.getEdgeCrossingAffectedEdges(index);
        energyDelta -= oldAdditionalFactorsEnergy;
        return energyDelta += this.getAdditionFactorsEnergy(index);
    }

    protected double getNodeDistribution(int i) {
        double energy;
        block8: {
            energy = 0.0;
            if (!this.isOptimizeNodeDistribution) break block8;
            if (this.approxNodeDimensions) {
                int j = 0;
                while (j < this.v.length) {
                    if (i != j) {
                        double vx = this.v[i].x - this.v[j].x;
                        double vy = this.v[i].y - this.v[j].y;
                        double distanceSquared = vx * vx + vy * vy;
                        distanceSquared -= this.v[i].radiusSquared;
                        if ((distanceSquared -= this.v[j].radiusSquared) < this.minDistanceLimitSquared) {
                            distanceSquared = this.minDistanceLimitSquared;
                        }
                        energy += this.nodeDistributionCostFactor / distanceSquared;
                    }
                    ++j;
                }
            } else {
                int j = 0;
                while (j < this.v.length) {
                    if (i != j) {
                        double vx = this.v[i].x - this.v[j].x;
                        double vy = this.v[i].y - this.v[j].y;
                        double distanceSquared = vx * vx + vy * vy;
                        distanceSquared -= this.v[i].radiusSquared;
                        if ((distanceSquared -= this.v[j].radiusSquared) < this.minDistanceLimitSquared) {
                            distanceSquared = this.minDistanceLimitSquared;
                        }
                        energy += this.nodeDistributionCostFactor / distanceSquared;
                    }
                    ++j;
                }
            }
        }
        return energy;
    }

    protected double getBorderline(int i) {
        double energy = 0.0;
        if (this.isOptimizeBorderLine) {
            double b;
            double r;
            double t;
            double l = this.v[i].x - this.boundsX;
            if (l < this.minDistanceLimit) {
                l = this.minDistanceLimit;
            }
            if ((t = this.v[i].y - this.boundsY) < this.minDistanceLimit) {
                t = this.minDistanceLimit;
            }
            if ((r = this.boundsX + this.boundsWidth - this.v[i].x) < this.minDistanceLimit) {
                r = this.minDistanceLimit;
            }
            if ((b = this.boundsY + this.boundsHeight - this.v[i].y) < this.minDistanceLimit) {
                b = this.minDistanceLimit;
            }
            energy += this.borderLineCostFactor * (1000000.0 / (t * t) + 1000000.0 / (l * l) + 1000000.0 / (b * b) + 1000000.0 / (r * r));
        }
        return energy;
    }

    protected double getEdgeLengthAffectedEdges(int node) {
        double energy = 0.0;
        int i = 0;
        while (i < this.v[node].connectedEdges.length) {
            energy += this.getEdgeLength(this.v[node].connectedEdges[i]);
            ++i;
        }
        return energy;
    }

    protected double getEdgeLength(int i) {
        if (this.isOptimizeEdgeLength) {
            double edgeLength = Point2D.distance(this.v[this.e[i].source].x, this.v[this.e[i].source].y, this.v[this.e[i].target].x, this.v[this.e[i].target].y);
            return this.edgeLengthCostFactor * edgeLength * edgeLength;
        }
        return 0.0;
    }

    protected double getEdgeCrossingAffectedEdges(int node) {
        double energy = 0.0;
        int i = 0;
        while (i < this.v[node].connectedEdges.length) {
            energy += this.getEdgeCrossing(this.v[node].connectedEdges[i]);
            ++i;
        }
        return energy;
    }

    protected double getEdgeCrossing(int i) {
        int n = 0;
        if (this.isOptimizeEdgeCrossing) {
            double iP1X = this.v[this.e[i].source].x;
            double iP1Y = this.v[this.e[i].source].y;
            double iP2X = this.v[this.e[i].target].x;
            double iP2Y = this.v[this.e[i].target].y;
            int j = 0;
            while (j < this.e.length) {
                double jP1X = this.v[this.e[j].source].x;
                double jP1Y = this.v[this.e[j].source].y;
                double jP2X = this.v[this.e[j].target].x;
                double jP2Y = this.v[this.e[j].target].y;
                if (j != i) {
                    double maxjX;
                    double minjX;
                    double maxiX;
                    double miniX;
                    if (iP1X < iP2X) {
                        miniX = iP1X;
                        maxiX = iP2X;
                    } else {
                        miniX = iP2X;
                        maxiX = iP1X;
                    }
                    if (jP1X < jP2X) {
                        minjX = jP1X;
                        maxjX = jP2X;
                    } else {
                        minjX = jP2X;
                        maxjX = jP1X;
                    }
                    if (!(maxiX < minjX) && !(miniX > maxjX)) {
                        double maxjY;
                        double minjY;
                        double maxiY;
                        double miniY;
                        if (iP1Y < iP2Y) {
                            miniY = iP1Y;
                            maxiY = iP2Y;
                        } else {
                            miniY = iP2Y;
                            maxiY = iP1Y;
                        }
                        if (jP1Y < jP2Y) {
                            minjY = jP1Y;
                            maxjY = jP2Y;
                        } else {
                            minjY = jP2Y;
                            maxjY = jP1Y;
                        }
                        if (!(maxiY < minjY) && !(miniY > maxjY) && iP1X != jP1X && iP1Y != jP1Y && iP1X != jP2X && iP1Y != jP2Y && iP2X != jP1X && iP2Y != jP1Y && iP2X != jP2X && iP2Y != jP2Y) {
                            boolean intersects;
                            boolean bl = intersects = Line2D.relativeCCW(iP1X, iP1Y, iP2X, iP2Y, jP1X, jP1Y) != Line2D.relativeCCW(iP1X, iP1Y, iP2X, iP2Y, jP2X, jP2Y) && Line2D.relativeCCW(jP1X, jP1Y, jP2X, jP2Y, iP1X, iP1Y) != Line2D.relativeCCW(jP1X, jP1Y, jP2X, jP2Y, iP2X, iP2Y);
                            if (intersects) {
                                ++n;
                            }
                        }
                    }
                }
                ++j;
            }
        }
        return this.edgeCrossingCostFactor * (double)n;
    }

    protected double getEdgeDistanceFromNode(int i) {
        double energy = 0.0;
        if (this.isOptimizeEdgeDistance && this.isFineTuning) {
            int[] edges = this.v[i].relevantEdges;
            int j = 0;
            while (j < edges.length) {
                double distSquare = Line2D.ptSegDistSq(this.v[this.e[edges[j]].source].x, this.v[this.e[edges[j]].source].y, this.v[this.e[edges[j]].target].x, this.v[this.e[edges[j]].target].y, this.v[i].x, this.v[i].y);
                if ((distSquare -= this.v[i].radiusSquared) < this.minDistanceLimitSquared) {
                    distSquare = this.minDistanceLimitSquared;
                }
                if (distSquare < this.maxDistanceLimitSquared) {
                    energy += this.edgeDistanceCostFactor / distSquare;
                }
                ++j;
            }
        }
        return energy;
    }

    protected double getEdgeDistanceAffectedNodes(int node) {
        double energy = 0.0;
        int i = 0;
        while (i < this.v[node].connectedEdges.length) {
            energy += this.getEdgeDistanceFromEdge(this.v[node].connectedEdges[i]);
            ++i;
        }
        return energy;
    }

    protected double getEdgeDistanceFromEdge(int i) {
        double energy = 0.0;
        if (this.isOptimizeEdgeDistance && this.isFineTuning) {
            int j = 0;
            while (j < this.v.length) {
                if (this.e[i].source != j && this.e[i].target != j) {
                    double distSquare = Line2D.ptSegDistSq(this.v[this.e[i].source].x, this.v[this.e[i].source].y, this.v[this.e[i].target].x, this.v[this.e[i].target].y, this.v[j].x, this.v[j].y);
                    if ((distSquare -= this.v[j].radiusSquared) < this.minDistanceLimitSquared) {
                        distSquare = this.minDistanceLimitSquared;
                    }
                    if (distSquare < this.maxDistanceLimitSquared) {
                        energy += this.edgeDistanceCostFactor / distSquare;
                    }
                }
                ++j;
            }
        }
        return energy;
    }

    protected double getAdditionFactorsEnergy(int i) {
        return 0.0;
    }

    protected int[] getRelevantEdges(int cellIndex) {
        ArrayList<Integer> relevantEdgeList = new ArrayList<Integer>(this.e.length);
        int i = 0;
        while (i < this.e.length) {
            if (this.e[i].source != cellIndex && this.e[i].target != cellIndex) {
                relevantEdgeList.add(new Integer(i));
            }
            ++i;
        }
        int[] relevantEdgeArray = new int[relevantEdgeList.size()];
        Iterator iter = relevantEdgeList.iterator();
        int i2 = 0;
        while (i2 < relevantEdgeArray.length) {
            if (iter.hasNext()) {
                relevantEdgeArray[i2] = (Integer)iter.next();
            }
            ++i2;
        }
        return relevantEdgeArray;
    }

    protected int[] getConnectedEdges(int cellIndex) {
        ArrayList<Integer> connectedEdgeList = new ArrayList<Integer>(this.e.length);
        int i = 0;
        while (i < this.e.length) {
            if (this.e[i].source == cellIndex || this.e[i].target == cellIndex) {
                connectedEdgeList.add(new Integer(i));
            }
            ++i;
        }
        int[] connectedEdgeArray = new int[connectedEdgeList.size()];
        Iterator iter = connectedEdgeList.iterator();
        int i2 = 0;
        while (i2 < connectedEdgeArray.length) {
            if (iter.hasNext()) {
                connectedEdgeArray[i2] = (Integer)iter.next();
            }
            ++i2;
        }
        return connectedEdgeArray;
    }

    public String toString() {
        return "Organic";
    }

    public double getAverageNodeArea() {
        return this.averageNodeArea;
    }

    public void setAverageNodeArea(double averageNodeArea) {
        this.averageNodeArea = averageNodeArea;
    }

    public double getBorderLineCostFactor() {
        return this.borderLineCostFactor;
    }

    public void setBorderLineCostFactor(double borderLineCostFactor) {
        this.borderLineCostFactor = borderLineCostFactor;
    }

    public double getEdgeCrossingCostFactor() {
        return this.edgeCrossingCostFactor;
    }

    public void setEdgeCrossingCostFactor(double edgeCrossingCostFactor) {
        this.edgeCrossingCostFactor = edgeCrossingCostFactor;
    }

    public double getEdgeDistanceCostFactor() {
        return this.edgeDistanceCostFactor;
    }

    public void setEdgeDistanceCostFactor(double edgeDistanceCostFactor) {
        this.edgeDistanceCostFactor = edgeDistanceCostFactor;
    }

    public double getEdgeLengthCostFactor() {
        return this.edgeLengthCostFactor;
    }

    public void setEdgeLengthCostFactor(double edgeLengthCostFactor) {
        this.edgeLengthCostFactor = edgeLengthCostFactor;
    }

    public double getFineTuningRadius() {
        return this.fineTuningRadius;
    }

    public void setFineTuningRadius(double fineTuningRadius) {
        this.fineTuningRadius = fineTuningRadius;
    }

    public double getInitialMoveRadius() {
        return this.initialMoveRadius;
    }

    public void setInitialMoveRadius(double initialMoveRadius) {
        this.initialMoveRadius = initialMoveRadius;
    }

    public boolean isFineTuning() {
        return this.isFineTuning;
    }

    public void setFineTuning(boolean isFineTuning) {
        this.isFineTuning = isFineTuning;
    }

    public boolean isOptimizeBorderLine() {
        return this.isOptimizeBorderLine;
    }

    public void setOptimizeBorderLine(boolean isOptimizeBorderLine) {
        this.isOptimizeBorderLine = isOptimizeBorderLine;
    }

    public boolean isOptimizeEdgeCrossing() {
        return this.isOptimizeEdgeCrossing;
    }

    public void setOptimizeEdgeCrossing(boolean isOptimizeEdgeCrossing) {
        this.isOptimizeEdgeCrossing = isOptimizeEdgeCrossing;
    }

    public boolean isOptimizeEdgeDistance() {
        return this.isOptimizeEdgeDistance;
    }

    public void setOptimizeEdgeDistance(boolean isOptimizeEdgeDistance) {
        this.isOptimizeEdgeDistance = isOptimizeEdgeDistance;
    }

    public boolean isOptimizeEdgeLength() {
        return this.isOptimizeEdgeLength;
    }

    public void setOptimizeEdgeLength(boolean isOptimizeEdgeLength) {
        this.isOptimizeEdgeLength = isOptimizeEdgeLength;
    }

    public boolean isOptimizeNodeDistribution() {
        return this.isOptimizeNodeDistribution;
    }

    public void setOptimizeNodeDistribution(boolean isOptimizeNodeDistribution) {
        this.isOptimizeNodeDistribution = isOptimizeNodeDistribution;
    }

    public int getMaxIterations() {
        return this.maxIterations;
    }

    public void setMaxIterations(int maxIterations) {
        this.maxIterations = maxIterations;
    }

    public double getMinDistanceLimit() {
        return this.minDistanceLimit;
    }

    public void setMinDistanceLimit(double minDistanceLimit) {
        this.minDistanceLimit = minDistanceLimit;
    }

    public double getMinMoveRadius() {
        return this.minMoveRadius;
    }

    public void setMinMoveRadius(double minMoveRadius) {
        this.minMoveRadius = minMoveRadius;
    }

    public double getNodeDistributionCostFactor() {
        return this.nodeDistributionCostFactor;
    }

    public void setNodeDistributionCostFactor(double nodeDistributionCostFactor) {
        this.nodeDistributionCostFactor = nodeDistributionCostFactor;
    }

    public double getRadiusScaleFactor() {
        return this.radiusScaleFactor;
    }

    public void setRadiusScaleFactor(double radiusScaleFactor) {
        this.radiusScaleFactor = radiusScaleFactor;
    }

    public int getTriesPerCell() {
        return this.triesPerCell;
    }

    public void setTriesPerCell(int triesPerCell) {
        this.triesPerCell = triesPerCell;
    }

    public int getUnchangedEnergyRoundTermination() {
        return this.unchangedEnergyRoundTermination;
    }

    public void setUnchangedEnergyRoundTermination(int unchangedEnergyRoundTermination) {
        this.unchangedEnergyRoundTermination = unchangedEnergyRoundTermination;
    }

    public double getMaxDistanceLimit() {
        return this.maxDistanceLimit;
    }

    public void setMaxDistanceLimit(double maxDistanceLimit) {
        this.maxDistanceLimit = maxDistanceLimit;
    }

    public boolean isApproxNodeDimensions() {
        return this.approxNodeDimensions;
    }

    public void setApproxNodeDimensions(boolean approxNodeDimensions) {
        this.approxNodeDimensions = approxNodeDimensions;
    }

    public class CellWrapper {
        protected Object cell;
        protected int[] relevantEdges = null;
        protected int[] connectedEdges = null;
        protected double x;
        protected double y;
        protected double radiusSquared;
        protected double heightSquared;
        protected int source;
        protected int target;

        public CellWrapper(Object cell) {
            this.cell = cell;
        }

        public int[] getRelevantEdges() {
            return this.relevantEdges;
        }

        public void setRelevantEdges(int[] relevantEdges) {
            this.relevantEdges = relevantEdges;
        }

        public int[] getConnectedEdges() {
            return this.connectedEdges;
        }

        public void setConnectedEdges(int[] connectedEdges) {
            this.connectedEdges = connectedEdges;
        }

        public double getX() {
            return this.x;
        }

        public void setX(double x) {
            this.x = x;
        }

        public double getY() {
            return this.y;
        }

        public void setY(double y) {
            this.y = y;
        }

        public double getRadiusSquared() {
            return this.radiusSquared;
        }

        public void setRadiusSquared(double radiusSquared) {
            this.radiusSquared = radiusSquared;
        }

        public double getHeightSquared() {
            return this.heightSquared;
        }

        public void setHeightSquared(double heightSquared) {
            this.heightSquared = heightSquared;
        }

        public int getSource() {
            return this.source;
        }

        public void setSource(int source) {
            this.source = source;
        }

        public int getTarget() {
            return this.target;
        }

        public void setTarget(int target) {
            this.target = target;
        }

        public Object getCell() {
            return this.cell;
        }
    }
}

