/*
 * Decompiled with CFR 0.152.
 */
package com.mxgraph.layout;

import com.mxgraph.layout.mxIGraphLayout;
import com.mxgraph.model.mxGeometry;
import com.mxgraph.model.mxIGraphModel;
import com.mxgraph.util.mxConstants;
import com.mxgraph.util.mxPoint;
import com.mxgraph.util.mxRectangle;
import com.mxgraph.view.mxCellState;
import com.mxgraph.view.mxGraph;
import java.util.List;
import java.util.Map;

public abstract class mxGraphLayout
implements mxIGraphLayout {
    protected mxGraph graph;
    protected boolean useBoundingBox = true;

    public mxGraphLayout(mxGraph graph) {
        this.graph = graph;
    }

    @Override
    public void moveCell(Object cell, double x, double y) {
    }

    public mxGraph getGraph() {
        return this.graph;
    }

    public Object getConstraint(Object key, Object cell) {
        return this.getConstraint(key, cell, null, false);
    }

    public Object getConstraint(Object key, Object cell, Object edge, boolean source) {
        mxCellState state = this.graph.getView().getState(cell);
        Map<String, Object> style = state != null ? state.getStyle() : this.graph.getCellStyle(cell);
        return style != null ? style.get(key) : null;
    }

    public boolean isUseBoundingBox() {
        return this.useBoundingBox;
    }

    public void setUseBoundingBox(boolean useBoundingBox) {
        this.useBoundingBox = useBoundingBox;
    }

    public boolean isVertexMovable(Object vertex) {
        return this.graph.isCellMovable(vertex);
    }

    public boolean isVertexIgnored(Object vertex) {
        return !this.graph.getModel().isVertex(vertex) || !this.graph.isCellVisible(vertex);
    }

    public boolean isEdgeIgnored(Object edge) {
        mxIGraphModel model = this.graph.getModel();
        return !model.isEdge(edge) || !this.graph.isCellVisible(edge) || model.getTerminal(edge, true) == null || model.getTerminal(edge, false) == null;
    }

    public void setEdgeStyleEnabled(Object edge, boolean value) {
        this.graph.setCellStyles(mxConstants.STYLE_NOEDGESTYLE, value ? "0" : "1", new Object[]{edge});
    }

    public void setOrthogonalEdge(Object edge, boolean value) {
        this.graph.setCellStyles(mxConstants.STYLE_ORTHOGONAL, value ? "1" : "0", new Object[]{edge});
    }

    public void setEdgePoints(Object edge, List<mxPoint> points) {
        mxIGraphModel model = this.graph.getModel();
        mxGeometry geometry = model.getGeometry(edge);
        if (geometry == null) {
            geometry = new mxGeometry();
            geometry.setRelative(true);
        } else {
            geometry = (mxGeometry)geometry.clone();
        }
        geometry.setPoints(points);
        model.setGeometry(edge, geometry);
    }

    public mxRectangle getVertexBounds(Object vertex) {
        mxCellState state;
        mxRectangle geo = this.graph.getModel().getGeometry(vertex);
        if (this.useBoundingBox && (state = this.graph.getView().getState(vertex)) != null) {
            double scale = this.graph.getView().getScale();
            mxRectangle tmp = state.getBoundingBox();
            double dx0 = (tmp.getX() - state.getX()) / scale;
            double dy0 = (tmp.getY() - state.getY()) / scale;
            double dx1 = (tmp.getX() + tmp.getWidth() - state.getX() - state.getWidth()) / scale;
            double dy1 = (tmp.getY() + tmp.getHeight() - state.getY() - state.getHeight()) / scale;
            geo = new mxRectangle(geo.getX() + dx0, geo.getY() + dy0, geo.getWidth() - dx0 + dx1, geo.getHeight() + -dy0 + dy1);
        }
        return new mxRectangle(geo);
    }

    public mxRectangle setVertexLocation(Object vertex, double x, double y) {
        mxIGraphModel model = this.graph.getModel();
        mxGeometry geometry = model.getGeometry(vertex);
        mxRectangle result = null;
        if (geometry != null) {
            mxCellState state;
            result = new mxRectangle(x, y, geometry.getWidth(), geometry.getHeight());
            if (this.useBoundingBox && (state = this.graph.getView().getState(vertex)) != null) {
                double scale = this.graph.getView().getScale();
                mxRectangle box = state.getBoundingBox();
                if (state.getBoundingBox().getX() < state.getX()) {
                    x += (state.getX() - box.getX()) / scale;
                    result.setWidth(box.getWidth());
                }
                if (state.getBoundingBox().getY() < state.getY()) {
                    y += (state.getY() - box.getY()) / scale;
                    result.setHeight(box.getHeight());
                }
            }
            if (geometry.getX() != x || geometry.getY() != y) {
                geometry = (mxGeometry)geometry.clone();
                geometry.setX(x);
                geometry.setY(y);
                model.setGeometry(vertex, geometry);
            }
        }
        return result;
    }
}

