/*
 * Decompiled with CFR 0.152.
 */
package com.mxgraph.layout;

import com.mxgraph.layout.mxGraphLayout;
import com.mxgraph.model.mxGeometry;
import com.mxgraph.model.mxIGraphModel;
import com.mxgraph.util.mxRectangle;
import com.mxgraph.view.mxGraph;
import java.util.ArrayList;
import java.util.Hashtable;

public class mxFastOrganicLayout
extends mxGraphLayout {
    protected boolean useInputOrigin = true;
    protected boolean resetEdges = true;
    protected boolean disableEdgeStyle = true;
    protected double forceConstant = 50.0;
    protected double forceConstantSquared = 0.0;
    protected double minDistanceLimit = 2.0;
    protected double minDistanceLimitSquared = 0.0;
    protected double initialTemp = 200.0;
    protected double temperature = 0.0;
    protected int maxIterations = 0;
    protected int iteration = 0;
    protected Object[] vertexArray;
    protected double[] dispX;
    protected double[] dispY;
    protected double[][] cellLocation;
    protected double[] radius;
    protected double[] radiusSquared;
    protected boolean[] isMoveable;
    protected int[][] neighbours;
    protected boolean allowedToRun = true;
    protected Hashtable<Object, Integer> indices = new Hashtable();

    public mxFastOrganicLayout(mxGraph graph) {
        super(graph);
    }

    @Override
    public boolean isVertexIgnored(Object vertex) {
        return super.isVertexIgnored(vertex) || this.graph.getConnections(vertex).length == 0;
    }

    public boolean isUseInputOrigin() {
        return this.useInputOrigin;
    }

    public void setUseInputOrigin(boolean value) {
        this.useInputOrigin = value;
    }

    public boolean isResetEdges() {
        return this.resetEdges;
    }

    public void setResetEdges(boolean value) {
        this.resetEdges = value;
    }

    public boolean isDisableEdgeStyle() {
        return this.disableEdgeStyle;
    }

    public void setDisableEdgeStyle(boolean value) {
        this.disableEdgeStyle = value;
    }

    public int getMaxIterations() {
        return this.maxIterations;
    }

    public void setMaxIterations(int value) {
        this.maxIterations = value;
    }

    public double getForceConstant() {
        return this.forceConstant;
    }

    public void setForceConstant(double value) {
        this.forceConstant = value;
    }

    public double getMinDistanceLimit() {
        return this.minDistanceLimit;
    }

    public void setMinDistanceLimit(double value) {
        this.minDistanceLimit = value;
    }

    public double getInitialTemp() {
        return this.initialTemp;
    }

    public void setInitialTemp(double value) {
        this.initialTemp = value;
    }

    protected void reduceTemperature() {
        this.temperature = this.initialTemp * (1.0 - (double)(this.iteration / this.maxIterations));
    }

    @Override
    public void moveCell(Object cell, double x, double y) {
    }

    @Override
    public void execute(Object parent) {
        mxIGraphModel model = this.graph.getModel();
        Object[] vertices = this.graph.getChildVertices(parent);
        ArrayList<Object> tmp = new ArrayList<Object>(vertices.length);
        int i = 0;
        while (i < vertices.length) {
            if (!this.isVertexIgnored(vertices[i])) {
                tmp.add(vertices[i]);
            }
            ++i;
        }
        this.vertexArray = tmp.toArray();
        mxRectangle initialBounds = this.useInputOrigin ? this.graph.getBoundsForCells(this.vertexArray, false, false, true) : null;
        int n = this.vertexArray.length;
        this.dispX = new double[n];
        this.dispY = new double[n];
        this.cellLocation = new double[n][];
        this.isMoveable = new boolean[n];
        this.neighbours = new int[n][];
        this.radius = new double[n];
        this.radiusSquared = new double[n];
        this.minDistanceLimitSquared = this.minDistanceLimit * this.minDistanceLimit;
        if (this.forceConstant < 0.001) {
            this.forceConstant = 0.001;
        }
        this.forceConstantSquared = this.forceConstant * this.forceConstant;
        int i2 = 0;
        while (i2 < this.vertexArray.length) {
            Object vertex = this.vertexArray[i2];
            this.cellLocation[i2] = new double[2];
            this.indices.put(vertex, new Integer(i2));
            mxRectangle bounds = this.getVertexBounds(vertex);
            double width = bounds.getWidth();
            double height = bounds.getHeight();
            double x = bounds.getX();
            double y = bounds.getY();
            this.cellLocation[i2][0] = x + width / 2.0;
            this.cellLocation[i2][1] = y + height / 2.0;
            this.radius[i2] = Math.min(width, height);
            this.radiusSquared[i2] = this.radius[i2] * this.radius[i2];
            ++i2;
        }
        model.beginUpdate();
        try {
            double dy;
            i2 = 0;
            while (i2 < n) {
                this.dispX[i2] = 0.0;
                this.dispY[i2] = 0.0;
                this.isMoveable[i2] = this.isVertexMovable(this.vertexArray[i2]);
                Object[] edges = this.graph.getConnections(this.vertexArray[i2], parent);
                int k = 0;
                while (k < edges.length) {
                    if (this.isResetEdges()) {
                        this.graph.resetEdge(edges[k]);
                    }
                    if (this.isDisableEdgeStyle()) {
                        this.setEdgeStyleEnabled(edges[k], false);
                    }
                    ++k;
                }
                Object[] cells = this.graph.getOpposites(edges, this.vertexArray[i2]);
                this.neighbours[i2] = new int[cells.length];
                int j = 0;
                while (j < cells.length) {
                    Integer index = this.indices.get(cells[j]);
                    this.neighbours[i2][j] = index != null ? index : i2;
                    ++j;
                }
                ++i2;
            }
            this.temperature = this.initialTemp;
            if (this.maxIterations == 0) {
                this.maxIterations = (int)(20.0 * Math.sqrt(n));
            }
            this.iteration = 0;
            while (this.iteration < this.maxIterations) {
                if (!this.allowedToRun) {
                    return;
                }
                this.calcRepulsion();
                this.calcAttraction();
                this.calcPositions();
                this.reduceTemperature();
                ++this.iteration;
            }
            Double minx = null;
            Double miny = null;
            int i3 = 0;
            while (i3 < this.vertexArray.length) {
                Object vertex = this.vertexArray[i3];
                mxGeometry geo = model.getGeometry(vertex);
                if (geo != null) {
                    double[] dArray = this.cellLocation[i3];
                    dArray[0] = dArray[0] - geo.getWidth() / 2.0;
                    double[] dArray2 = this.cellLocation[i3];
                    dArray2[1] = dArray2[1] - geo.getHeight() / 2.0;
                    double x = this.graph.snap(this.cellLocation[i3][0]);
                    double y = this.graph.snap(this.cellLocation[i3][1]);
                    this.setVertexLocation(vertex, x, y);
                    minx = minx == null ? new Double(x) : new Double(Math.min(minx, x));
                    miny = miny == null ? new Double(y) : new Double(Math.min(miny, y));
                }
                ++i3;
            }
            double dx = minx != null ? -minx.doubleValue() - 1.0 : 0.0;
            double d = dy = miny != null ? -miny.doubleValue() - 1.0 : 0.0;
            if (initialBounds != null) {
                dx += initialBounds.getX();
                dy += initialBounds.getY();
            }
            this.graph.moveCells(this.vertexArray, dx, dy);
        }
        finally {
            model.endUpdate();
        }
    }

    protected void calcPositions() {
        int index = 0;
        while (index < this.vertexArray.length) {
            if (this.isMoveable[index]) {
                double deltaLength = Math.sqrt(this.dispX[index] * this.dispX[index] + this.dispY[index] * this.dispY[index]);
                if (deltaLength < 0.001) {
                    deltaLength = 0.001;
                }
                double newXDisp = this.dispX[index] / deltaLength * Math.min(deltaLength, this.temperature);
                double newYDisp = this.dispY[index] / deltaLength * Math.min(deltaLength, this.temperature);
                this.dispX[index] = 0.0;
                this.dispY[index] = 0.0;
                double[] dArray = this.cellLocation[index];
                dArray[0] = dArray[0] + newXDisp;
                double[] dArray2 = this.cellLocation[index];
                dArray2[1] = dArray2[1] + newYDisp;
            }
            ++index;
        }
    }

    protected void calcAttraction() {
        int i = 0;
        while (i < this.vertexArray.length) {
            int k = 0;
            while (k < this.neighbours[i].length) {
                int j = this.neighbours[i][k];
                if (i != j) {
                    double xDelta = this.cellLocation[i][0] - this.cellLocation[j][0];
                    double yDelta = this.cellLocation[i][1] - this.cellLocation[j][1];
                    double deltaLengthSquared = xDelta * xDelta + yDelta * yDelta - this.radiusSquared[i] - this.radiusSquared[j];
                    if (deltaLengthSquared < this.minDistanceLimitSquared) {
                        deltaLengthSquared = this.minDistanceLimitSquared;
                    }
                    double deltaLength = Math.sqrt(deltaLengthSquared);
                    double force = deltaLengthSquared / this.forceConstant;
                    double displacementX = xDelta / deltaLength * force;
                    double displacementY = yDelta / deltaLength * force;
                    if (this.isMoveable[i]) {
                        int n = i;
                        this.dispX[n] = this.dispX[n] - displacementX;
                        int n2 = i;
                        this.dispY[n2] = this.dispY[n2] - displacementY;
                    }
                    if (this.isMoveable[j]) {
                        int n = j;
                        this.dispX[n] = this.dispX[n] + displacementX;
                        int n3 = j;
                        this.dispY[n3] = this.dispY[n3] + displacementY;
                    }
                }
                ++k;
            }
            ++i;
        }
    }

    protected void calcRepulsion() {
        int vertexCount = this.vertexArray.length;
        int i = 0;
        while (i < vertexCount) {
            int j = i;
            while (j < vertexCount) {
                if (!this.allowedToRun) {
                    return;
                }
                if (j != i) {
                    double deltaLength;
                    double deltaLengthWithRadius;
                    double xDelta = this.cellLocation[i][0] - this.cellLocation[j][0];
                    double yDelta = this.cellLocation[i][1] - this.cellLocation[j][1];
                    if (xDelta == 0.0) {
                        xDelta = 0.01 + Math.random();
                    }
                    if (yDelta == 0.0) {
                        yDelta = 0.01 + Math.random();
                    }
                    if ((deltaLengthWithRadius = (deltaLength = Math.sqrt(xDelta * xDelta + yDelta * yDelta)) - this.radius[i] - this.radius[j]) < this.minDistanceLimit) {
                        deltaLengthWithRadius = this.minDistanceLimit;
                    }
                    double force = this.forceConstantSquared / deltaLengthWithRadius;
                    double displacementX = xDelta / deltaLength * force;
                    double displacementY = yDelta / deltaLength * force;
                    if (this.isMoveable[i]) {
                        int n = i;
                        this.dispX[n] = this.dispX[n] + displacementX;
                        int n2 = i;
                        this.dispY[n2] = this.dispY[n2] + displacementY;
                    }
                    if (this.isMoveable[j]) {
                        int n = j;
                        this.dispX[n] = this.dispX[n] - displacementX;
                        int n3 = j;
                        this.dispY[n3] = this.dispY[n3] - displacementY;
                    }
                }
                ++j;
            }
            ++i;
        }
    }
}

