/*
 * Decompiled with CFR 0.152.
 */
package com.mxgraph.layout;

import com.mxgraph.layout.mxGraphLayout;
import com.mxgraph.model.mxGeometry;
import com.mxgraph.model.mxIGraphModel;
import com.mxgraph.util.mxPoint;
import com.mxgraph.view.mxCellState;
import com.mxgraph.view.mxGraph;
import com.mxgraph.view.mxGraphView;
import java.awt.Rectangle;
import java.util.ArrayList;

public class mxEdgeLabelLayout
extends mxGraphLayout {
    public mxEdgeLabelLayout(mxGraph graph) {
        super(graph);
    }

    @Override
    public void execute(Object parent) {
        mxGraphView view = this.graph.getView();
        mxIGraphModel model = this.graph.getModel();
        ArrayList<mxCellState> edges = new ArrayList<mxCellState>();
        ArrayList<mxCellState> vertices = new ArrayList<mxCellState>();
        int childCount = model.getChildCount(parent);
        int i = 0;
        while (i < childCount) {
            Object cell = model.getChildAt(parent, i);
            mxCellState state = view.getState(cell);
            if (state != null) {
                if (!this.isVertexIgnored(cell)) {
                    vertices.add(state);
                } else if (!this.isEdgeIgnored(cell)) {
                    edges.add(state);
                }
            }
            ++i;
        }
        this.placeLabels(vertices.toArray(), edges.toArray());
    }

    protected void placeLabels(Object[] v, Object[] e) {
        mxIGraphModel model = this.graph.getModel();
        model.beginUpdate();
        try {
            int i = 0;
            while (i < e.length) {
                mxCellState edge = (mxCellState)e[i];
                if (edge != null && edge.getLabelBounds() != null) {
                    int j = 0;
                    while (j < v.length) {
                        mxCellState vertex = (mxCellState)v[j];
                        if (vertex != null) {
                            this.avoid(edge, vertex);
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        finally {
            model.endUpdate();
        }
    }

    protected void avoid(mxCellState edge, mxCellState vertex) {
        Rectangle vRect;
        mxIGraphModel model = this.graph.getModel();
        Rectangle labRect = edge.getLabelBounds().getRectangle();
        if (labRect.intersects(vRect = vertex.getRectangle())) {
            int dx;
            int dy1 = -labRect.y - labRect.height + vRect.y;
            int dy2 = -labRect.y + vRect.y + vRect.height;
            int dy = Math.abs(dy1) < Math.abs(dy2) ? dy1 : dy2;
            int dx1 = -labRect.x - labRect.width + vRect.x;
            int dx2 = -labRect.x + vRect.x + vRect.width;
            int n = dx = Math.abs(dx1) < Math.abs(dx2) ? dx1 : dx2;
            if (Math.abs(dx) < Math.abs(dy)) {
                dy = 0;
            } else {
                dx = 0;
            }
            mxGeometry g = model.getGeometry(edge.getCell());
            if (g != null) {
                if ((g = (mxGeometry)g.clone()).getOffset() != null) {
                    g.getOffset().setX(g.getOffset().getX() + (double)dx);
                    g.getOffset().setY(g.getOffset().getY() + (double)dy);
                } else {
                    g.setOffset(new mxPoint(dx, dy));
                }
                model.setGeometry(edge.getCell(), g);
            }
        }
    }
}

