/*
 * Decompiled with CFR 0.152.
 */
package com.mxgraph.layout;

import com.mxgraph.layout.mxGraphLayout;
import com.mxgraph.model.mxGeometry;
import com.mxgraph.model.mxIGraphModel;
import com.mxgraph.util.mxRectangle;
import com.mxgraph.view.mxGraph;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class mxCompactTreeLayout
extends mxGraphLayout {
    protected boolean horizontal;
    protected boolean invert;
    protected boolean resizeParent = true;
    protected boolean moveTree = true;
    protected boolean resetEdges = true;
    protected int levelDistance = 10;
    protected int nodeDistance = 20;

    public mxCompactTreeLayout(mxGraph graph) {
        this(graph, true);
    }

    public mxCompactTreeLayout(mxGraph graph, boolean horizontal) {
        this(graph, horizontal, false);
    }

    public mxCompactTreeLayout(mxGraph graph, boolean horizontal, boolean invert) {
        super(graph);
        this.horizontal = horizontal;
        this.invert = invert;
    }

    @Override
    public boolean isVertexIgnored(Object vertex) {
        return super.isVertexIgnored(vertex) || this.graph.getConnections(vertex).length == 0;
    }

    public boolean isHorizontal() {
        return this.horizontal;
    }

    public void setHorizontal(boolean horizontal) {
        this.horizontal = horizontal;
    }

    public boolean isInvert() {
        return this.invert;
    }

    public void setInvert(boolean invert) {
        this.invert = invert;
    }

    public boolean isResizeParent() {
        return this.resizeParent;
    }

    public void setResizeParent(boolean resizeParent) {
        this.resizeParent = resizeParent;
    }

    public boolean isMoveTree() {
        return this.moveTree;
    }

    public void setMoveTree(boolean moveTree) {
        this.moveTree = moveTree;
    }

    public boolean isResetEdges() {
        return this.resetEdges;
    }

    public void setResetEdges(boolean resetEdges) {
        this.resetEdges = resetEdges;
    }

    public int getLevelDistance() {
        return this.levelDistance;
    }

    public void setLevelDistance(int levelDistance) {
        this.levelDistance = levelDistance;
    }

    public int getNodeDistance() {
        return this.nodeDistance;
    }

    public void setNodeDistance(int nodeDistance) {
        this.nodeDistance = nodeDistance;
    }

    @Override
    public void execute(Object parent) {
        this.execute(parent, null);
    }

    public void execute(Object parent, Object root) {
        mxIGraphModel model = this.graph.getModel();
        if (root == null) {
            if (this.graph.getEdges(parent, model.getParent(parent), this.invert, !this.invert, false).length > 0) {
                root = parent;
            } else {
                List<Object> roots = this.graph.findTreeRoots(parent, true, this.invert);
                if (roots.size() > 0) {
                    int i = 0;
                    while (i < roots.size()) {
                        if (!this.isVertexIgnored(roots.get(i)) && this.graph.getEdges(roots.get(i), null, this.invert, !this.invert, false).length > 0) {
                            root = roots.get(i);
                            break;
                        }
                        ++i;
                    }
                }
            }
        }
        if (root != null) {
            parent = model.getParent(root);
            model.beginUpdate();
            try {
                TreeNode node = this.dfs(root, parent, null);
                if (node != null) {
                    mxGeometry g;
                    double x0;
                    this.layout(node);
                    double y0 = x0 = (double)this.graph.getGridSize();
                    if (!(this.moveTree && model.getParent(parent) != model.getRoot() || (g = model.getGeometry(root)) == null)) {
                        x0 = g.getX();
                        y0 = g.getY();
                    }
                    mxRectangle bounds = null;
                    bounds = this.horizontal ? this.horizontalLayout(node, x0, y0, null) : this.verticalLayout(node, null, x0, y0, null);
                    if (bounds != null) {
                        double dx = 0.0;
                        double dy = 0.0;
                        if (bounds.getX() < 0.0) {
                            dx = Math.abs(x0 - bounds.getX());
                        }
                        if (bounds.getY() < 0.0) {
                            dy = Math.abs(y0 - bounds.getY());
                        }
                        if (parent != null) {
                            mxGeometry g2;
                            mxRectangle size = this.graph.getStartSize(parent);
                            dx += size.getWidth();
                            dy += size.getHeight();
                            if (this.resizeParent && !this.graph.isCellCollapsed(parent) && (g2 = model.getGeometry(parent)) != null) {
                                double width = bounds.getWidth() + size.getWidth() - bounds.getX() + 2.0 * x0;
                                double height = bounds.getHeight() + size.getHeight() - bounds.getY() + 2.0 * y0;
                                if ((g2 = (mxGeometry)g2.clone()).getWidth() > width) {
                                    dx += (g2.getWidth() - width) / 2.0;
                                } else {
                                    g2.setWidth(width);
                                }
                                if (g2.getHeight() > height) {
                                    if (this.horizontal) {
                                        dy += (g2.getHeight() - height) / 2.0;
                                    }
                                } else {
                                    g2.setHeight(height);
                                }
                                model.setGeometry(parent, g2);
                            }
                        }
                        this.moveNode(node, dx, dy);
                    }
                }
            }
            finally {
                model.endUpdate();
            }
        }
    }

    protected void moveNode(TreeNode node, double dx, double dy) {
        node.x += dx;
        node.y += dy;
        this.apply(node, null);
        TreeNode child = node.child;
        while (child != null) {
            this.moveNode(child, dx, dy);
            child = child.next;
        }
    }

    protected TreeNode dfs(Object cell, Object parent, Set<Object> visited) {
        if (visited == null) {
            visited = new HashSet<Object>();
        }
        TreeNode node = null;
        if (cell != null && !visited.contains(cell) && !this.isVertexIgnored(cell)) {
            visited.add(cell);
            node = this.createNode(cell);
            mxIGraphModel model = this.graph.getModel();
            TreeNode prev = null;
            Object[] out = this.graph.getEdges(cell, parent, this.invert, !this.invert, false);
            int i = 0;
            while (i < out.length) {
                Object edge = out[i];
                if (!this.isEdgeIgnored(edge)) {
                    Object target;
                    TreeNode tmp;
                    if (this.resetEdges) {
                        this.setEdgePoints(edge, null);
                    }
                    if ((tmp = this.dfs(target = this.graph.getView().getVisibleTerminal(edge, this.invert), parent, visited)) != null && model.getGeometry(target) != null) {
                        if (prev == null) {
                            node.child = tmp;
                        } else {
                            prev.next = tmp;
                        }
                        prev = tmp;
                    }
                }
                ++i;
            }
        }
        return node;
    }

    protected void layout(TreeNode node) {
        if (node != null) {
            TreeNode child = node.child;
            while (child != null) {
                this.layout(child);
                child = child.next;
            }
            if (node.child != null) {
                this.attachParent(node, this.join(node));
            } else {
                this.layoutLeaf(node);
            }
        }
    }

    protected mxRectangle horizontalLayout(TreeNode node, double x0, double y0, mxRectangle bounds) {
        node.x += x0 + node.offsetX;
        node.y += y0 + node.offsetY;
        bounds = this.apply(node, bounds);
        TreeNode child = node.child;
        if (child != null) {
            bounds = this.horizontalLayout(child, node.x, node.y, bounds);
            double siblingOffset = node.y + child.offsetY;
            TreeNode s = child.next;
            while (s != null) {
                bounds = this.horizontalLayout(s, node.x + child.offsetX, siblingOffset, bounds);
                siblingOffset += s.offsetY;
                s = s.next;
            }
        }
        return bounds;
    }

    protected mxRectangle verticalLayout(TreeNode node, Object parent, double x0, double y0, mxRectangle bounds) {
        node.x += x0 + node.offsetY;
        node.y += y0 + node.offsetX;
        bounds = this.apply(node, bounds);
        TreeNode child = node.child;
        if (child != null) {
            bounds = this.verticalLayout(child, node, node.x, node.y, bounds);
            double siblingOffset = node.x + child.offsetY;
            TreeNode s = child.next;
            while (s != null) {
                bounds = this.verticalLayout(s, node, siblingOffset, node.y + child.offsetX, bounds);
                siblingOffset += s.offsetY;
                s = s.next;
            }
        }
        return bounds;
    }

    protected void attachParent(TreeNode node, double height) {
        double x = this.nodeDistance + this.levelDistance;
        double y2 = (height - node.width) / 2.0 - (double)this.nodeDistance;
        double y1 = y2 + node.width + (double)(2 * this.nodeDistance) - height;
        node.child.offsetX = x + node.height;
        node.child.offsetY = y1;
        node.contour.upperHead = this.createLine(node.height, 0.0, this.createLine(x, y1, node.contour.upperHead));
        node.contour.lowerHead = this.createLine(node.height, 0.0, this.createLine(x, y2, node.contour.lowerHead));
    }

    protected void layoutLeaf(TreeNode node) {
        double dist = 2 * this.nodeDistance;
        node.contour.upperHead = node.contour.upperTail = this.createLine(node.height + dist, 0.0, null);
        node.contour.lowerTail = this.createLine(0.0, -node.width - dist, null);
        node.contour.lowerHead = this.createLine(node.height + dist, 0.0, node.contour.lowerTail);
    }

    protected double join(TreeNode node) {
        double h;
        double dist = 2 * this.nodeDistance;
        TreeNode child = node.child;
        node.contour = child.contour;
        double sum = h = child.width + dist;
        child = child.next;
        while (child != null) {
            double d = this.merge(node.contour, child.contour);
            child.offsetY = d + h;
            child.offsetX = 0.0;
            h = child.width + dist;
            sum += d + h;
            child = child.next;
        }
        return sum;
    }

    protected double merge(Polygon p1, Polygon p2) {
        double x = 0.0;
        double y = 0.0;
        double total = 0.0;
        Polyline upper = p1.lowerHead;
        Polyline lower = p2.upperHead;
        while (lower != null && upper != null) {
            double d = this.offset(x, y, lower.dx, lower.dy, upper.dx, upper.dy);
            y += d;
            total += d;
            if (x + lower.dx <= upper.dx) {
                x += lower.dx;
                y += lower.dy;
                lower = lower.next;
                continue;
            }
            x -= upper.dx;
            y -= upper.dy;
            upper = upper.next;
        }
        if (lower != null) {
            Polyline b = this.bridge(p1.upperTail, 0.0, 0.0, lower, x, y);
            p1.upperTail = b.next != null ? p2.upperTail : b;
            p1.lowerTail = p2.lowerTail;
        } else {
            Polyline b = this.bridge(p2.lowerTail, x, y, upper, 0.0, 0.0);
            if (b.next == null) {
                p1.lowerTail = b;
            }
        }
        p1.lowerHead = p2.lowerHead;
        return total;
    }

    protected double offset(double p1, double p2, double a1, double a2, double b1, double b2) {
        double d = 0.0;
        if (b1 <= p1 || p1 + a1 <= 0.0) {
            return 0.0;
        }
        double t = b1 * a2 - a1 * b2;
        if (t > 0.0) {
            if (p1 < 0.0) {
                double s = p1 * a2;
                d = s / a1 - p2;
            } else if (p1 > 0.0) {
                double s = p1 * b2;
                d = s / b1 - p2;
            } else {
                d = -p2;
            }
        } else if (b1 < p1 + a1) {
            double s = (b1 - p1) * a2;
            d = b2 - (p2 + s / a1);
        } else if (b1 > p1 + a1) {
            double s = (a1 + p1) * b2;
            d = s / b1 - (p2 + a2);
        } else {
            d = b2 - (p2 + a2);
        }
        if (d > 0.0) {
            return d;
        }
        return 0.0;
    }

    protected Polyline bridge(Polyline line1, double x1, double y1, Polyline line2, double x2, double y2) {
        double dx = x2 + line2.dx - x1;
        double dy = 0.0;
        double s = 0.0;
        if (line2.dx == 0.0) {
            dy = line2.dy;
        } else {
            s = dx * line2.dy;
            dy = s / line2.dx;
        }
        Polyline r = this.createLine(dx, dy, line2.next);
        line1.next = this.createLine(0.0, y2 + line2.dy - dy - y1, r);
        return r;
    }

    protected TreeNode createNode(Object cell) {
        TreeNode node = new TreeNode(cell);
        mxRectangle geo = this.getVertexBounds(cell);
        if (geo != null) {
            if (this.horizontal) {
                node.width = geo.getHeight();
                node.height = geo.getWidth();
            } else {
                node.width = geo.getWidth();
                node.height = geo.getHeight();
            }
        }
        return node;
    }

    protected mxRectangle apply(TreeNode node, mxRectangle bounds) {
        mxRectangle g = this.graph.getModel().getGeometry(node.cell);
        if (node.cell != null && g != null) {
            if (this.isVertexMovable(node.cell)) {
                g = this.setVertexLocation(node.cell, node.x, node.y);
            }
            bounds = bounds == null ? new mxRectangle(g.getX(), g.getY(), g.getWidth(), g.getHeight()) : new mxRectangle(Math.min(bounds.getX(), g.getX()), Math.min(bounds.getY(), g.getY()), Math.max(bounds.getX() + bounds.getWidth(), g.getX() + g.getWidth()), Math.max(bounds.getY() + bounds.getHeight(), g.getY() + g.getHeight()));
        }
        return bounds;
    }

    protected Polyline createLine(double dx, double dy, Polyline next) {
        return new Polyline(dx, dy, next);
    }

    protected static class Polygon {
        protected Polyline lowerHead;
        protected Polyline lowerTail;
        protected Polyline upperHead;
        protected Polyline upperTail;

        protected Polygon() {
        }
    }

    protected static class Polyline {
        protected double dx;
        protected double dy;
        protected Polyline next;

        protected Polyline(double dx, double dy, Polyline next) {
            this.dx = dx;
            this.dy = dy;
            this.next = next;
        }
    }

    protected static class TreeNode {
        protected Object cell;
        protected double x;
        protected double y;
        protected double width;
        protected double height;
        protected double offsetX;
        protected double offsetY;
        protected TreeNode child;
        protected TreeNode next;
        protected Polygon contour = new Polygon();

        public TreeNode(Object cell) {
            this.cell = cell;
        }
    }
}

