/*
 * Decompiled with CFR 0.152.
 */
package com.mxgraph.layout;

import com.mxgraph.layout.mxGraphLayout;
import com.mxgraph.model.mxIGraphModel;
import com.mxgraph.util.mxRectangle;
import com.mxgraph.view.mxGraph;
import java.util.ArrayList;

public class mxCircleLayout
extends mxGraphLayout {
    protected double radius;
    protected boolean moveCircle = true;
    protected double x0 = 0.0;
    protected double y0 = 0.0;
    protected boolean resetEdges = false;
    protected boolean disableEdgeStyle = true;

    public mxCircleLayout(mxGraph graph) {
        this(graph, 100.0);
    }

    public mxCircleLayout(mxGraph graph, double radius) {
        super(graph);
        this.radius = radius;
    }

    public double getRadius() {
        return this.radius;
    }

    public void setRadius(double radius) {
        this.radius = radius;
    }

    public boolean isMoveCircle() {
        return this.moveCircle;
    }

    public void setMoveCircle(boolean moveCircle) {
        this.moveCircle = moveCircle;
    }

    public double getX0() {
        return this.x0;
    }

    public void setX0(double x0) {
        this.x0 = x0;
    }

    public double getY0() {
        return this.y0;
    }

    public void setY0(double y0) {
        this.y0 = y0;
    }

    public boolean isResetEdges() {
        return this.resetEdges;
    }

    public void setResetEdges(boolean resetEdges) {
        this.resetEdges = resetEdges;
    }

    public boolean isDisableEdgeStyle() {
        return this.disableEdgeStyle;
    }

    public void setDisableEdgeStyle(boolean disableEdgeStyle) {
        this.disableEdgeStyle = disableEdgeStyle;
    }

    @Override
    public void execute(Object parent) {
        mxIGraphModel model = this.graph.getModel();
        model.beginUpdate();
        try {
            double max = 0.0;
            Double top = null;
            Double left = null;
            ArrayList<Object> vertices = new ArrayList<Object>();
            int childCount = model.getChildCount(parent);
            int i = 0;
            while (i < childCount) {
                Object cell = model.getChildAt(parent, i);
                if (!this.isVertexIgnored(cell)) {
                    vertices.add(cell);
                    mxRectangle bounds = this.getVertexBounds(cell);
                    top = top == null ? Double.valueOf(bounds.getY()) : Double.valueOf(Math.min(top, bounds.getY()));
                    left = left == null ? Double.valueOf(bounds.getX()) : Double.valueOf(Math.min(left, bounds.getX()));
                    max = Math.max(max, Math.max(bounds.getWidth(), bounds.getHeight()));
                } else if (!this.isEdgeIgnored(cell)) {
                    if (this.isResetEdges()) {
                        this.graph.resetEdge(cell);
                    }
                    if (this.isDisableEdgeStyle()) {
                        this.setEdgeStyleEnabled(cell, false);
                    }
                }
                ++i;
            }
            int vertexCount = vertices.size();
            double r = Math.max((double)vertexCount * max / Math.PI, this.radius);
            if (this.moveCircle) {
                top = this.x0;
                left = this.y0;
            }
            this.circle(vertices.toArray(), r, left, top);
        }
        finally {
            model.endUpdate();
        }
    }

    public void circle(Object[] vertices, double r, double left, double top) {
        int vertexCount = vertices.length;
        double phi = Math.PI * 2 / (double)vertexCount;
        int i = 0;
        while (i < vertexCount) {
            if (this.isVertexMovable(vertices[i])) {
                this.setVertexLocation(vertices[i], left + r + r * Math.sin((double)i * phi), top + r + r * Math.cos((double)i * phi));
            }
            ++i;
        }
    }
}

