/*
 * Decompiled with CFR 0.152.
 */
package com.mxgraph.layout.hierarchical.stage;

import com.mxgraph.layout.hierarchical.model.mxGraphAbstractHierarchyCell;
import com.mxgraph.layout.hierarchical.model.mxGraphHierarchyModel;
import com.mxgraph.layout.hierarchical.model.mxGraphHierarchyRank;
import com.mxgraph.layout.hierarchical.mxHierarchicalLayout;
import com.mxgraph.layout.hierarchical.stage.mxHierarchicalLayoutStage;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;

public class mxMedianHybridCrossingReduction
implements mxHierarchicalLayoutStage {
    protected mxHierarchicalLayout layout;
    protected int maxIterations = 24;
    protected mxGraphAbstractHierarchyCell[][] nestedBestRanks = null;
    protected int currentBestCrossings = 0;
    protected int iterationsWithoutImprovement = 0;
    protected int maxNoImprovementIterations = 2;

    public mxMedianHybridCrossingReduction(mxHierarchicalLayout layout) {
        this.layout = layout;
    }

    @Override
    public void execute(Object parent) {
        mxGraphHierarchyModel model = this.layout.getModel();
        this.nestedBestRanks = new mxGraphAbstractHierarchyCell[model.ranks.size()][];
        int i = 0;
        while (i < this.nestedBestRanks.length) {
            mxGraphHierarchyRank rank = model.ranks.get(new Integer(i));
            this.nestedBestRanks[i] = new mxGraphAbstractHierarchyCell[rank.size()];
            rank.toArray(this.nestedBestRanks[i]);
            ++i;
        }
        this.iterationsWithoutImprovement = 0;
        this.currentBestCrossings = this.calculateCrossings(model);
        i = 0;
        while (i < this.maxIterations && this.iterationsWithoutImprovement < this.maxNoImprovementIterations) {
            mxGraphAbstractHierarchyCell cell;
            int k;
            Iterator iter;
            mxGraphHierarchyRank rank;
            int j;
            this.weightedMedian(i, model);
            this.transpose(i, model);
            int candidateCrossings = this.calculateCrossings(model);
            if (candidateCrossings < this.currentBestCrossings) {
                this.currentBestCrossings = candidateCrossings;
                this.iterationsWithoutImprovement = 0;
                j = 0;
                while (j < this.nestedBestRanks.length) {
                    rank = model.ranks.get(new Integer(j));
                    iter = rank.iterator();
                    k = 0;
                    while (k < rank.size()) {
                        this.nestedBestRanks[j][cell.getGeneralPurposeVariable((int)j)] = cell = (mxGraphAbstractHierarchyCell)iter.next();
                        ++k;
                    }
                    ++j;
                }
            } else {
                ++this.iterationsWithoutImprovement;
                j = 0;
                while (j < this.nestedBestRanks.length) {
                    rank = model.ranks.get(new Integer(j));
                    iter = rank.iterator();
                    k = 0;
                    while (k < rank.size()) {
                        cell = (mxGraphAbstractHierarchyCell)iter.next();
                        cell.setGeneralPurposeVariable(j, k);
                        ++k;
                    }
                    ++j;
                }
            }
            if (this.currentBestCrossings == 0) break;
            ++i;
        }
        LinkedHashMap<Integer, mxGraphHierarchyRank> ranks = new LinkedHashMap<Integer, mxGraphHierarchyRank>(model.maxRank + 1);
        mxGraphHierarchyRank[] rankList = new mxGraphHierarchyRank[model.maxRank + 1];
        int i2 = 0;
        while (i2 < model.maxRank + 1) {
            rankList[i2] = new mxGraphHierarchyRank();
            ranks.put(new Integer(i2), rankList[i2]);
            ++i2;
        }
        i2 = 0;
        while (i2 < this.nestedBestRanks.length) {
            int j = 0;
            while (j < this.nestedBestRanks[i2].length) {
                rankList[i2].add(this.nestedBestRanks[i2][j]);
                ++j;
            }
            ++i2;
        }
        model.ranks = ranks;
    }

    private int calculateCrossings(mxGraphHierarchyModel model) {
        int numRanks = model.ranks.size();
        int totalCrossings = 0;
        int i = 1;
        while (i < numRanks) {
            totalCrossings += this.calculateRankCrossing(i, model);
            ++i;
        }
        return totalCrossings;
    }

    protected int calculateRankCrossing(int i, mxGraphHierarchyModel model) {
        int totalCrossings = 0;
        mxGraphHierarchyRank rank = model.ranks.get(new Integer(i));
        mxGraphHierarchyRank previousRank = model.ranks.get(new Integer(i - 1));
        int currentRankSize = rank.size();
        int previousRankSize = previousRank.size();
        int[][] connections = new int[currentRankSize][previousRankSize];
        for (mxGraphAbstractHierarchyCell cell : rank) {
            int rankPosition = cell.getGeneralPurposeVariable(i);
            List<mxGraphAbstractHierarchyCell> connectedCells = cell.getPreviousLayerConnectedCells(i);
            for (mxGraphAbstractHierarchyCell connectedCell : connectedCells) {
                int otherCellRankPosition = connectedCell.getGeneralPurposeVariable(i - 1);
                connections[rankPosition][otherCellRankPosition] = 201207;
            }
        }
        int j = 0;
        while (j < currentRankSize) {
            int k = 0;
            while (k < previousRankSize) {
                if (connections[j][k] == 201207) {
                    int k2;
                    int j2 = j + 1;
                    while (j2 < currentRankSize) {
                        k2 = 0;
                        while (k2 < k) {
                            if (connections[j2][k2] == 201207) {
                                ++totalCrossings;
                            }
                            ++k2;
                        }
                        ++j2;
                    }
                    j2 = 0;
                    while (j2 < j) {
                        k2 = k + 1;
                        while (k2 < previousRankSize) {
                            if (connections[j2][k2] == 201207) {
                                ++totalCrossings;
                            }
                            ++k2;
                        }
                        ++j2;
                    }
                }
                ++k;
            }
            ++j;
        }
        return totalCrossings / 2;
    }

    private void transpose(int mainLoopIteration, mxGraphHierarchyModel model) {
        boolean improved = true;
        int count = 0;
        int maxCount = 10;
        while (improved && count++ < maxCount) {
            boolean nudge = mainLoopIteration % 2 == 1 && count % 2 == 1;
            improved = false;
            int i = 0;
            while (i < model.ranks.size()) {
                mxGraphHierarchyRank rank = model.ranks.get(new Integer(i));
                mxGraphAbstractHierarchyCell[] orderedCells = new mxGraphAbstractHierarchyCell[rank.size()];
                Iterator iter = rank.iterator();
                int j = 0;
                while (j < orderedCells.length) {
                    mxGraphAbstractHierarchyCell cell;
                    orderedCells[cell.getGeneralPurposeVariable((int)i)] = cell = (mxGraphAbstractHierarchyCell)iter.next();
                    ++j;
                }
                List<mxGraphAbstractHierarchyCell> leftCellAboveConnections = null;
                List<mxGraphAbstractHierarchyCell> leftCellBelowConnections = null;
                List<mxGraphAbstractHierarchyCell> rightCellAboveConnections = null;
                List<mxGraphAbstractHierarchyCell> rightCellBelowConnections = null;
                int[] leftAbovePositions = null;
                int[] leftBelowPositions = null;
                int[] rightAbovePositions = null;
                int[] rightBelowPositions = null;
                mxGraphAbstractHierarchyCell leftCell = null;
                mxGraphAbstractHierarchyCell rightCell = null;
                int j2 = 0;
                while (j2 < rank.size() - 1) {
                    int ik;
                    int k;
                    if (j2 == 0) {
                        leftCell = orderedCells[j2];
                        leftCellAboveConnections = leftCell.getNextLayerConnectedCells(i);
                        leftCellBelowConnections = leftCell.getPreviousLayerConnectedCells(i);
                        leftAbovePositions = new int[leftCellAboveConnections.size()];
                        leftBelowPositions = new int[leftCellBelowConnections.size()];
                        k = 0;
                        while (k < leftAbovePositions.length) {
                            leftAbovePositions[k] = leftCellAboveConnections.get(k).getGeneralPurposeVariable(i + 1);
                            ++k;
                        }
                        k = 0;
                        while (k < leftBelowPositions.length) {
                            leftBelowPositions[k] = leftCellBelowConnections.get(k).getGeneralPurposeVariable(i - 1);
                            ++k;
                        }
                    } else {
                        leftCellAboveConnections = rightCellAboveConnections;
                        leftCellBelowConnections = rightCellBelowConnections;
                        leftAbovePositions = rightAbovePositions;
                        leftBelowPositions = rightBelowPositions;
                        leftCell = rightCell;
                    }
                    rightCell = orderedCells[j2 + 1];
                    rightCellAboveConnections = rightCell.getNextLayerConnectedCells(i);
                    rightCellBelowConnections = rightCell.getPreviousLayerConnectedCells(i);
                    rightAbovePositions = new int[rightCellAboveConnections.size()];
                    rightBelowPositions = new int[rightCellBelowConnections.size()];
                    k = 0;
                    while (k < rightAbovePositions.length) {
                        rightAbovePositions[k] = rightCellAboveConnections.get(k).getGeneralPurposeVariable(i + 1);
                        ++k;
                    }
                    k = 0;
                    while (k < rightBelowPositions.length) {
                        rightBelowPositions[k] = rightCellBelowConnections.get(k).getGeneralPurposeVariable(i - 1);
                        ++k;
                    }
                    int totalCurrentCrossings = 0;
                    int totalSwitchedCrossings = 0;
                    int k2 = 0;
                    while (k2 < leftAbovePositions.length) {
                        ik = 0;
                        while (ik < rightAbovePositions.length) {
                            if (leftAbovePositions[k2] > rightAbovePositions[ik]) {
                                ++totalCurrentCrossings;
                            }
                            if (leftAbovePositions[k2] < rightAbovePositions[ik]) {
                                ++totalSwitchedCrossings;
                            }
                            ++ik;
                        }
                        ++k2;
                    }
                    k2 = 0;
                    while (k2 < leftBelowPositions.length) {
                        ik = 0;
                        while (ik < rightBelowPositions.length) {
                            if (leftBelowPositions[k2] > rightBelowPositions[ik]) {
                                ++totalCurrentCrossings;
                            }
                            if (leftBelowPositions[k2] < rightBelowPositions[ik]) {
                                ++totalSwitchedCrossings;
                            }
                            ++ik;
                        }
                        ++k2;
                    }
                    if (totalSwitchedCrossings < totalCurrentCrossings || totalSwitchedCrossings == totalCurrentCrossings && nudge) {
                        int temp = leftCell.getGeneralPurposeVariable(i);
                        leftCell.setGeneralPurposeVariable(i, rightCell.getGeneralPurposeVariable(i));
                        rightCell.setGeneralPurposeVariable(i, temp);
                        rightCellAboveConnections = leftCellAboveConnections;
                        rightCellBelowConnections = leftCellBelowConnections;
                        rightAbovePositions = leftAbovePositions;
                        rightBelowPositions = leftBelowPositions;
                        rightCell = leftCell;
                        if (!nudge) {
                            improved = true;
                        }
                    }
                    ++j2;
                }
                ++i;
            }
        }
    }

    private void weightedMedian(int iteration, mxGraphHierarchyModel model) {
        boolean downwardSweep;
        boolean bl = downwardSweep = iteration % 2 == 0;
        if (downwardSweep) {
            int j = model.maxRank - 1;
            while (j >= 0) {
                this.medianRank(j, downwardSweep);
                --j;
            }
        } else {
            int j = 1;
            while (j < model.maxRank) {
                this.medianRank(j, downwardSweep);
                ++j;
            }
        }
    }

    private void medianRank(int rankValue, boolean downwardSweep) {
        int numCellsForRank = this.nestedBestRanks[rankValue].length;
        Object[] medianValues = new MedianCellSorter[numCellsForRank];
        int i = 0;
        while (i < numCellsForRank) {
            mxGraphAbstractHierarchyCell cell = this.nestedBestRanks[rankValue][i];
            medianValues[i] = new MedianCellSorter();
            ((MedianCellSorter)medianValues[i]).cell = cell;
            ((MedianCellSorter)medianValues[i]).nudge = !downwardSweep;
            List<mxGraphAbstractHierarchyCell> nextLevelConnectedCells = downwardSweep ? cell.getNextLayerConnectedCells(rankValue) : cell.getPreviousLayerConnectedCells(rankValue);
            int nextRankValue = downwardSweep ? rankValue + 1 : rankValue - 1;
            ((MedianCellSorter)medianValues[i]).medianValue = nextLevelConnectedCells != null && nextLevelConnectedCells.size() != 0 ? this.medianValue(nextLevelConnectedCells, nextRankValue) : -1.0;
            ++i;
        }
        Arrays.sort(medianValues);
        i = 0;
        while (i < numCellsForRank) {
            ((MedianCellSorter)medianValues[i]).cell.setGeneralPurposeVariable(rankValue, i);
            ++i;
        }
    }

    private double medianValue(Collection<mxGraphAbstractHierarchyCell> connectedCells, int rankValue) {
        double[] medianValues = new double[connectedCells.size()];
        int arrayCount = 0;
        Iterator<mxGraphAbstractHierarchyCell> iter = connectedCells.iterator();
        while (iter.hasNext()) {
            medianValues[arrayCount++] = iter.next().getGeneralPurposeVariable(rankValue);
        }
        Arrays.sort(medianValues);
        if (arrayCount % 2 == 1) {
            return medianValues[arrayCount / 2];
        }
        if (arrayCount == 2) {
            return (medianValues[0] + medianValues[1]) / 2.0;
        }
        int medianPoint = arrayCount / 2;
        double leftMedian = medianValues[medianPoint - 1] - medianValues[0];
        double rightMedian = medianValues[arrayCount - 1] - medianValues[medianPoint];
        return (medianValues[medianPoint - 1] * rightMedian + medianValues[medianPoint] * leftMedian) / (leftMedian + rightMedian);
    }

    protected class MedianCellSorter
    implements Comparable<Object> {
        public double medianValue = 0.0;
        public boolean nudge = false;
        mxGraphAbstractHierarchyCell cell = null;

        protected MedianCellSorter() {
        }

        @Override
        public int compareTo(Object arg0) {
            if (arg0 instanceof MedianCellSorter) {
                if (this.medianValue < ((MedianCellSorter)arg0).medianValue) {
                    return -1;
                }
                if (this.medianValue > ((MedianCellSorter)arg0).medianValue) {
                    return 1;
                }
                if (this.nudge) {
                    return -1;
                }
                return 1;
            }
            return 0;
        }
    }
}

