/*
 * Decompiled with CFR 0.152.
 */
package com.mxgraph.layout.hierarchical.stage;

import com.mxgraph.layout.hierarchical.model.mxGraphAbstractHierarchyCell;
import com.mxgraph.layout.hierarchical.model.mxGraphHierarchyEdge;
import com.mxgraph.layout.hierarchical.model.mxGraphHierarchyModel;
import com.mxgraph.layout.hierarchical.model.mxGraphHierarchyNode;
import com.mxgraph.layout.hierarchical.model.mxGraphHierarchyRank;
import com.mxgraph.layout.hierarchical.mxHierarchicalLayout;
import com.mxgraph.layout.hierarchical.stage.mxHierarchicalLayoutStage;
import com.mxgraph.util.mxPoint;
import com.mxgraph.util.mxRectangle;
import com.mxgraph.view.mxGraph;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class mxCoordinateAssignment
implements mxHierarchicalLayoutStage {
    protected mxHierarchicalLayout layout;
    protected double intraCellSpacing = 30.0;
    protected double interRankCellSpacing = 30.0;
    protected double parallelEdgeSpacing = 10.0;
    protected double vertexConnectionBuffer = 0.0;
    protected int maxIterations = 8;
    protected int orientation = 1;
    protected double initialX;
    protected double limitX;
    protected double currentXDelta;
    protected int widestRank;
    protected double[] rankTopY;
    protected double[] rankBottomY;
    protected double widestRankValue;
    protected double[] rankWidths;
    protected double[] rankY;
    protected boolean fineTuning = true;
    protected boolean disableEdgeStyle = true;
    protected HierarchicalEdgeStyle edgeStyle = HierarchicalEdgeStyle.ORTHOGONAL;
    protected mxGraphAbstractHierarchyCell[][] nextLayerConnectedCache;
    protected mxGraphAbstractHierarchyCell[][] previousLayerConnectedCache;
    private static Logger logger = Logger.getLogger("com.jgraph.layout.hierarchical.JGraphCoordinateAssignment");

    public mxCoordinateAssignment(mxHierarchicalLayout layout, double intraCellSpacing, double interRankCellSpacing, int orientation, double initialX, double parallelEdgeSpacing) {
        this.layout = layout;
        this.intraCellSpacing = intraCellSpacing;
        this.interRankCellSpacing = interRankCellSpacing;
        this.orientation = orientation;
        this.initialX = initialX;
        this.parallelEdgeSpacing = parallelEdgeSpacing;
        this.setLoggerLevel(Level.OFF);
    }

    @Override
    public void execute(Object parent) {
        mxGraphHierarchyModel model = this.layout.getModel();
        this.currentXDelta = 0.0;
        this.initialCoords(this.layout.getGraph(), model);
        if (this.fineTuning) {
            this.minNode(model);
        }
        double bestXDelta = 1.0E8;
        if (this.fineTuning) {
            int i = 0;
            while (i < this.maxIterations) {
                mxGraphHierarchyRank rank;
                int j;
                if (i != 0) {
                    this.medianPos(i, model);
                    this.minNode(model);
                }
                if (this.currentXDelta < bestXDelta) {
                    j = 0;
                    while (j < model.ranks.size()) {
                        rank = model.ranks.get(new Integer(j));
                        for (mxGraphAbstractHierarchyCell cell : rank) {
                            cell.setX(j, cell.getGeneralPurposeVariable(j));
                        }
                        ++j;
                    }
                    bestXDelta = this.currentXDelta;
                } else {
                    j = 0;
                    while (j < model.ranks.size()) {
                        rank = model.ranks.get(new Integer(j));
                        for (mxGraphAbstractHierarchyCell cell : rank) {
                            cell.setGeneralPurposeVariable(j, (int)cell.getX(j));
                        }
                        ++j;
                    }
                }
                this.minPath(model);
                this.currentXDelta = 0.0;
                ++i;
            }
        }
        this.setCellLocations(this.layout.getGraph(), model);
    }

    private void minNode(mxGraphHierarchyModel model) {
        LinkedList<WeightedCellSorter> nodeList = new LinkedList<WeightedCellSorter>();
        Hashtable<mxGraphAbstractHierarchyCell, WeightedCellSorter> map = new Hashtable<mxGraphAbstractHierarchyCell, WeightedCellSorter>();
        mxGraphAbstractHierarchyCell[][] rank = new mxGraphAbstractHierarchyCell[model.maxRank + 1][];
        int i = 0;
        while (i <= model.maxRank) {
            mxGraphHierarchyRank rankSet = model.ranks.get(new Integer(i));
            rank[i] = rankSet.toArray(new mxGraphAbstractHierarchyCell[rankSet.size()]);
            int j = 0;
            while (j < rank[i].length) {
                mxGraphAbstractHierarchyCell cell = rank[i][j];
                WeightedCellSorter cellWrapper = new WeightedCellSorter(cell, i);
                cellWrapper.rankIndex = j++;
                cellWrapper.visited = true;
                nodeList.add(cellWrapper);
                map.put(cell, cellWrapper);
            }
            ++i;
        }
        int maxTries = nodeList.size() * 10;
        int count = 0;
        int tolerance = 1;
        while (!nodeList.isEmpty() && count <= maxTries) {
            WeightedCellSorter cellWrapper = (WeightedCellSorter)nodeList.getFirst();
            mxGraphAbstractHierarchyCell cell = cellWrapper.cell;
            int rankValue = cellWrapper.weightedValue;
            int rankIndex = cellWrapper.rankIndex;
            Object[] nextLayerConnectedCells = cell.getNextLayerConnectedCells(rankValue).toArray();
            Object[] previousLayerConnectedCells = cell.getPreviousLayerConnectedCells(rankValue).toArray();
            int numNextLayerConnected = nextLayerConnectedCells.length;
            int numPreviousLayerConnected = previousLayerConnectedCells.length;
            int medianNextLevel = this.medianXValue(nextLayerConnectedCells, rankValue + 1);
            int medianPreviousLevel = this.medianXValue(previousLayerConnectedCells, rankValue - 1);
            int numConnectedNeighbours = numNextLayerConnected + numPreviousLayerConnected;
            int currentPosition = cell.getGeneralPurposeVariable(rankValue);
            double cellMedian = currentPosition;
            if (numConnectedNeighbours > 0) {
                cellMedian = (medianNextLevel * numNextLayerConnected + medianPreviousLevel * numPreviousLayerConnected) / numConnectedNeighbours;
            }
            boolean positionChanged = false;
            if (cellMedian < (double)(currentPosition - tolerance)) {
                if (rankIndex == 0) {
                    cell.setGeneralPurposeVariable(rankValue, (int)cellMedian);
                    positionChanged = true;
                } else {
                    mxGraphAbstractHierarchyCell leftCell = rank[rankValue][rankIndex - 1];
                    int leftLimit = leftCell.getGeneralPurposeVariable(rankValue);
                    if ((double)(leftLimit = leftLimit + (int)leftCell.width / 2 + (int)this.intraCellSpacing + (int)cell.width / 2) < cellMedian) {
                        cell.setGeneralPurposeVariable(rankValue, (int)cellMedian);
                        positionChanged = true;
                    } else if (leftLimit < cell.getGeneralPurposeVariable(rankValue) - tolerance) {
                        cell.setGeneralPurposeVariable(rankValue, leftLimit);
                        positionChanged = true;
                    }
                }
            } else if (cellMedian > (double)(currentPosition + tolerance)) {
                int rankSize = rank[rankValue].length;
                if (rankIndex == rankSize - 1) {
                    cell.setGeneralPurposeVariable(rankValue, (int)cellMedian);
                    positionChanged = true;
                } else {
                    mxGraphAbstractHierarchyCell rightCell = rank[rankValue][rankIndex + 1];
                    int rightLimit = rightCell.getGeneralPurposeVariable(rankValue);
                    if ((double)(rightLimit = rightLimit - (int)rightCell.width / 2 - (int)this.intraCellSpacing - (int)cell.width / 2) > cellMedian) {
                        cell.setGeneralPurposeVariable(rankValue, (int)cellMedian);
                        positionChanged = true;
                    } else if (rightLimit > cell.getGeneralPurposeVariable(rankValue) + tolerance) {
                        cell.setGeneralPurposeVariable(rankValue, rightLimit);
                        positionChanged = true;
                    }
                }
            }
            if (positionChanged) {
                int i2 = 0;
                while (i2 < nextLayerConnectedCells.length) {
                    mxGraphAbstractHierarchyCell connectedCell = (mxGraphAbstractHierarchyCell)nextLayerConnectedCells[i2];
                    WeightedCellSorter connectedCellWrapper = (WeightedCellSorter)map.get(connectedCell);
                    if (connectedCellWrapper != null && !connectedCellWrapper.visited) {
                        connectedCellWrapper.visited = true;
                        nodeList.add(connectedCellWrapper);
                    }
                    ++i2;
                }
                i2 = 0;
                while (i2 < previousLayerConnectedCells.length) {
                    mxGraphAbstractHierarchyCell connectedCell = (mxGraphAbstractHierarchyCell)previousLayerConnectedCells[i2];
                    WeightedCellSorter connectedCellWrapper = (WeightedCellSorter)map.get(connectedCell);
                    if (connectedCellWrapper != null && !connectedCellWrapper.visited) {
                        connectedCellWrapper.visited = true;
                        nodeList.add(connectedCellWrapper);
                    }
                    ++i2;
                }
            }
            nodeList.removeFirst();
            cellWrapper.visited = false;
            ++count;
        }
    }

    private void medianPos(int i, mxGraphHierarchyModel model) {
        boolean downwardSweep;
        boolean bl = downwardSweep = i % 2 == 0;
        if (downwardSweep) {
            int j = model.maxRank;
            while (j > 0) {
                this.rankMedianPosition(j - 1, model, j);
                --j;
            }
        } else {
            int j = 0;
            while (j < model.maxRank - 1) {
                this.rankMedianPosition(j + 1, model, j);
                ++j;
            }
        }
    }

    protected void rankMedianPosition(int rankValue, mxGraphHierarchyModel model, int nextRankValue) {
        mxGraphHierarchyRank rankSet = model.ranks.get(new Integer(rankValue));
        Object[] rank = rankSet.toArray();
        Object[] weightedValues = new WeightedCellSorter[rank.length];
        Hashtable<mxGraphAbstractHierarchyCell, Object> cellMap = new Hashtable<mxGraphAbstractHierarchyCell, Object>(rank.length);
        int i = 0;
        while (i < rank.length) {
            mxGraphAbstractHierarchyCell currentCell = (mxGraphAbstractHierarchyCell)rank[i];
            weightedValues[i] = new WeightedCellSorter();
            ((WeightedCellSorter)weightedValues[i]).cell = currentCell;
            ((WeightedCellSorter)weightedValues[i]).rankIndex = i;
            cellMap.put(currentCell, weightedValues[i]);
            List<mxGraphAbstractHierarchyCell> nextLayerConnectedCells = null;
            nextLayerConnectedCells = nextRankValue < rankValue ? currentCell.getPreviousLayerConnectedCells(rankValue) : currentCell.getNextLayerConnectedCells(rankValue);
            ((WeightedCellSorter)weightedValues[i]).weightedValue = this.calculatedWeightedValue(currentCell, nextLayerConnectedCells);
            ++i;
        }
        Arrays.sort(weightedValues);
        i = 0;
        while (i < weightedValues.length) {
            int numConnectionsNextLevel = 0;
            mxGraphAbstractHierarchyCell cell = ((WeightedCellSorter)weightedValues[i]).cell;
            Object[] nextLayerConnectedCells = null;
            int medianNextLevel = 0;
            nextLayerConnectedCells = nextRankValue < rankValue ? cell.getPreviousLayerConnectedCells(rankValue).toArray() : cell.getNextLayerConnectedCells(rankValue).toArray();
            if (nextLayerConnectedCells != null) {
                numConnectionsNextLevel = nextLayerConnectedCells.length;
                medianNextLevel = numConnectionsNextLevel > 0 ? this.medianXValue(nextLayerConnectedCells, nextRankValue) : cell.getGeneralPurposeVariable(rankValue);
            }
            double leftBuffer = 0.0;
            double leftLimit = -1.0E8;
            int j = ((WeightedCellSorter)weightedValues[i]).rankIndex - 1;
            while (j >= 0) {
                WeightedCellSorter weightedValue = (WeightedCellSorter)cellMap.get(rank[j]);
                if (weightedValue == null) continue;
                mxGraphAbstractHierarchyCell leftCell = weightedValue.cell;
                if (weightedValue.visited) {
                    leftLimit = (double)leftCell.getGeneralPurposeVariable(rankValue) + leftCell.width / 2.0 + this.intraCellSpacing + leftBuffer + cell.width / 2.0;
                    j = -1;
                    continue;
                }
                leftBuffer += leftCell.width + this.intraCellSpacing;
                --j;
            }
            double rightBuffer = 0.0;
            double rightLimit = 1.0E8;
            int j2 = ((WeightedCellSorter)weightedValues[i]).rankIndex + 1;
            while (j2 < weightedValues.length) {
                WeightedCellSorter weightedValue = (WeightedCellSorter)cellMap.get(rank[j2]);
                if (weightedValue == null) continue;
                mxGraphAbstractHierarchyCell rightCell = weightedValue.cell;
                if (weightedValue.visited) {
                    rightLimit = (double)rightCell.getGeneralPurposeVariable(rankValue) - rightCell.width / 2.0 - this.intraCellSpacing - rightBuffer - cell.width / 2.0;
                    j2 = weightedValues.length;
                    continue;
                }
                rightBuffer += rightCell.width + this.intraCellSpacing;
                ++j2;
            }
            if ((double)medianNextLevel >= leftLimit && (double)medianNextLevel <= rightLimit) {
                cell.setGeneralPurposeVariable(rankValue, medianNextLevel);
            } else if ((double)medianNextLevel < leftLimit) {
                cell.setGeneralPurposeVariable(rankValue, (int)leftLimit);
                this.currentXDelta += leftLimit - (double)medianNextLevel;
            } else if ((double)medianNextLevel > rightLimit) {
                cell.setGeneralPurposeVariable(rankValue, (int)rightLimit);
                this.currentXDelta += (double)medianNextLevel - rightLimit;
            }
            ((WeightedCellSorter)weightedValues[i]).visited = true;
            ++i;
        }
    }

    private int calculatedWeightedValue(mxGraphAbstractHierarchyCell currentCell, Collection<mxGraphAbstractHierarchyCell> collection) {
        int totalWeight = 0;
        for (mxGraphAbstractHierarchyCell cell : collection) {
            if (currentCell.isVertex() && cell.isVertex()) {
                ++totalWeight;
                continue;
            }
            if (currentCell.isEdge() && cell.isEdge()) {
                totalWeight += 8;
                continue;
            }
            totalWeight += 2;
        }
        return totalWeight;
    }

    private int medianXValue(Object[] connectedCells, int rankValue) {
        if (connectedCells.length == 0) {
            return 0;
        }
        int[] medianValues = new int[connectedCells.length];
        int i = 0;
        while (i < connectedCells.length) {
            medianValues[i] = ((mxGraphAbstractHierarchyCell)connectedCells[i]).getGeneralPurposeVariable(rankValue);
            ++i;
        }
        Arrays.sort(medianValues);
        if (connectedCells.length % 2 == 1) {
            return medianValues[connectedCells.length / 2];
        }
        int medianPoint = connectedCells.length / 2;
        int leftMedian = medianValues[medianPoint - 1];
        int rightMedian = medianValues[medianPoint];
        return (leftMedian + rightMedian) / 2;
    }

    private void initialCoords(mxGraph facade, mxGraphHierarchyModel model) {
        this.calculateWidestRank(facade, model);
        int i = this.widestRank;
        while (i >= 0) {
            if (i < model.maxRank) {
                this.rankCoordinates(i, facade, model);
            }
            --i;
        }
        i = this.widestRank + 1;
        while (i <= model.maxRank) {
            if (i > 0) {
                this.rankCoordinates(i, facade, model);
            }
            ++i;
        }
    }

    protected void rankCoordinates(int rankValue, mxGraph graph, mxGraphHierarchyModel model) {
        mxGraphHierarchyRank rank = model.ranks.get(new Integer(rankValue));
        double maxY = 0.0;
        double localX = this.initialX + (this.widestRankValue - this.rankWidths[rankValue]) / 2.0;
        boolean boundsWarning = false;
        for (mxGraphAbstractHierarchyCell cell : rank) {
            if (cell.isVertex()) {
                mxGraphHierarchyNode node = (mxGraphHierarchyNode)cell;
                mxRectangle bounds = this.layout.getVertexBounds(node.cell);
                if (bounds != null) {
                    if (this.orientation == 1 || this.orientation == 5) {
                        cell.width = bounds.getWidth();
                        cell.height = bounds.getHeight();
                    } else {
                        cell.width = bounds.getHeight();
                        cell.height = bounds.getWidth();
                    }
                } else {
                    boundsWarning = true;
                }
                maxY = Math.max(maxY, cell.height);
            } else if (cell.isEdge()) {
                mxGraphHierarchyEdge edge = (mxGraphHierarchyEdge)cell;
                int numEdges = 1;
                if (edge.edges != null) {
                    numEdges = edge.edges.size();
                } else {
                    logger.info("edge.edges is null");
                }
                cell.width = (double)(numEdges - 1) * this.parallelEdgeSpacing;
            }
            cell.setX(rankValue, localX += cell.width / 2.0);
            cell.setGeneralPurposeVariable(rankValue, (int)localX);
            localX += cell.width / 2.0;
            localX += this.intraCellSpacing;
        }
        if (boundsWarning) {
            logger.info("At least one cell has no bounds");
        }
    }

    protected void calculateWidestRank(mxGraph graph, mxGraphHierarchyModel model) {
        double y = -this.interRankCellSpacing;
        double lastRankMaxCellHeight = 0.0;
        this.rankWidths = new double[model.maxRank + 1];
        this.rankY = new double[model.maxRank + 1];
        int rankValue = model.maxRank;
        while (rankValue >= 0) {
            double maxCellHeight = 0.0;
            mxGraphHierarchyRank rank = model.ranks.get(new Integer(rankValue));
            double localX = this.initialX;
            boolean boundsWarning = false;
            for (mxGraphAbstractHierarchyCell cell : rank) {
                if (cell.isVertex()) {
                    mxGraphHierarchyNode node = (mxGraphHierarchyNode)cell;
                    mxRectangle bounds = this.layout.getVertexBounds(node.cell);
                    if (bounds != null) {
                        if (this.orientation == 1 || this.orientation == 5) {
                            cell.width = bounds.getWidth();
                            cell.height = bounds.getHeight();
                        } else {
                            cell.width = bounds.getHeight();
                            cell.height = bounds.getWidth();
                        }
                    } else {
                        boundsWarning = true;
                    }
                    maxCellHeight = Math.max(maxCellHeight, cell.height);
                } else if (cell.isEdge()) {
                    mxGraphHierarchyEdge edge = (mxGraphHierarchyEdge)cell;
                    int numEdges = 1;
                    if (edge.edges != null) {
                        numEdges = edge.edges.size();
                    } else {
                        logger.info("edge.edges is null");
                    }
                    cell.width = (double)(numEdges - 1) * this.parallelEdgeSpacing;
                }
                cell.setX(rankValue, localX += cell.width / 2.0);
                cell.setGeneralPurposeVariable(rankValue, (int)localX);
                localX += cell.width / 2.0;
                localX += this.intraCellSpacing;
                if (localX > this.widestRankValue) {
                    this.widestRankValue = localX;
                    this.widestRank = rankValue;
                }
                this.rankWidths[rankValue] = localX;
            }
            if (boundsWarning) {
                logger.info("At least one cell has no bounds");
            }
            this.rankY[rankValue] = y;
            double distanceToNextRank = maxCellHeight / 2.0 + lastRankMaxCellHeight / 2.0 + this.interRankCellSpacing;
            lastRankMaxCellHeight = maxCellHeight;
            y = this.orientation == 1 || this.orientation == 7 ? (y += distanceToNextRank) : (y -= distanceToNextRank);
            for (mxGraphAbstractHierarchyCell cell : rank) {
                cell.setY(rankValue, y);
            }
            --rankValue;
        }
    }

    protected void minPath(mxGraphHierarchyModel model) {
        Map<Object, mxGraphHierarchyEdge> edges = model.getEdgeMapper();
        for (mxGraphAbstractHierarchyCell mxGraphAbstractHierarchyCell2 : edges.values()) {
            double nextX;
            if (mxGraphAbstractHierarchyCell2.maxRank <= mxGraphAbstractHierarchyCell2.minRank + 2) continue;
            int numEdgeLayers = mxGraphAbstractHierarchyCell2.maxRank - mxGraphAbstractHierarchyCell2.minRank - 1;
            int referenceX = mxGraphAbstractHierarchyCell2.getGeneralPurposeVariable(mxGraphAbstractHierarchyCell2.minRank + 1);
            boolean edgeStraight = true;
            int refSegCount = 0;
            int i = mxGraphAbstractHierarchyCell2.minRank + 2;
            while (i < mxGraphAbstractHierarchyCell2.maxRank) {
                int x = mxGraphAbstractHierarchyCell2.getGeneralPurposeVariable(i);
                if (referenceX != x) {
                    edgeStraight = false;
                    referenceX = x;
                } else {
                    ++refSegCount;
                }
                ++i;
            }
            if (edgeStraight) continue;
            int upSegCount = 0;
            int downSegCount = 0;
            double[] upXPositions = new double[numEdgeLayers - 1];
            double[] downXPositions = new double[numEdgeLayers - 1];
            double currentX = mxGraphAbstractHierarchyCell2.getX(mxGraphAbstractHierarchyCell2.minRank + 1);
            int i2 = mxGraphAbstractHierarchyCell2.minRank + 1;
            while (i2 < mxGraphAbstractHierarchyCell2.maxRank - 1) {
                nextX = mxGraphAbstractHierarchyCell2.getX(i2 + 1);
                if (currentX == nextX) {
                    ++upSegCount;
                } else if (this.repositionValid(model, mxGraphAbstractHierarchyCell2, i2 + 1, currentX)) {
                    upXPositions[i2 - mxGraphAbstractHierarchyCell2.minRank - 1] = currentX;
                    ++upSegCount;
                } else {
                    currentX = nextX;
                }
                ++i2;
            }
            currentX = mxGraphAbstractHierarchyCell2.getX(mxGraphAbstractHierarchyCell2.maxRank - 1);
            int i3 = mxGraphAbstractHierarchyCell2.maxRank - 1;
            while (i3 > mxGraphAbstractHierarchyCell2.minRank + 1) {
                nextX = mxGraphAbstractHierarchyCell2.getX(i3 - 1);
                if (currentX == nextX) {
                    ++downSegCount;
                } else if (this.repositionValid(model, mxGraphAbstractHierarchyCell2, i3 - 1, currentX)) {
                    downXPositions[i3 - mxGraphAbstractHierarchyCell2.minRank - 2] = currentX;
                    ++downSegCount;
                } else {
                    currentX = nextX;
                }
                --i3;
            }
            if (downSegCount <= refSegCount && upSegCount <= refSegCount) continue;
            if (downSegCount > upSegCount) {
                i3 = mxGraphAbstractHierarchyCell2.maxRank - 2;
                while (i3 > mxGraphAbstractHierarchyCell2.minRank) {
                    mxGraphAbstractHierarchyCell2.setX(i3, (int)downXPositions[i3 - mxGraphAbstractHierarchyCell2.minRank - 1]);
                    --i3;
                }
                continue;
            }
            if (upSegCount <= downSegCount) continue;
            i3 = mxGraphAbstractHierarchyCell2.minRank + 2;
            while (i3 < mxGraphAbstractHierarchyCell2.maxRank) {
                mxGraphAbstractHierarchyCell2.setX(i3, (int)upXPositions[i3 - mxGraphAbstractHierarchyCell2.minRank - 2]);
                ++i3;
            }
        }
    }

    protected boolean repositionValid(mxGraphHierarchyModel model, mxGraphAbstractHierarchyCell cell, int rank, double position) {
        mxGraphHierarchyRank rankSet = model.ranks.get(new Integer(rank));
        mxGraphAbstractHierarchyCell[] rankArray = rankSet.toArray(new mxGraphAbstractHierarchyCell[rankSet.size()]);
        int rankIndex = -1;
        int i = 0;
        while (i < rankArray.length) {
            if (cell == rankArray[i]) {
                rankIndex = i;
                break;
            }
            ++i;
        }
        if (rankIndex < 0) {
            return false;
        }
        int currentX = cell.getGeneralPurposeVariable(rank);
        if (position < (double)currentX) {
            if (rankIndex == 0) {
                return true;
            }
            mxGraphAbstractHierarchyCell leftCell = rankArray[rankIndex - 1];
            int leftLimit = leftCell.getGeneralPurposeVariable(rank);
            return (double)(leftLimit = leftLimit + (int)leftCell.width / 2 + (int)this.intraCellSpacing + (int)cell.width / 2) <= position;
        }
        if (position > (double)currentX) {
            if (rankIndex == rankArray.length - 1) {
                return true;
            }
            mxGraphAbstractHierarchyCell rightCell = rankArray[rankIndex + 1];
            int rightLimit = rightCell.getGeneralPurposeVariable(rank);
            return (double)(rightLimit = rightLimit - (int)rightCell.width / 2 - (int)this.intraCellSpacing - (int)cell.width / 2) >= position;
        }
        return true;
    }

    protected void setCellLocations(mxGraph graph, mxGraphHierarchyModel model) {
        this.rankTopY = new double[model.ranks.size()];
        this.rankBottomY = new double[model.ranks.size()];
        int i = 0;
        while (i < model.ranks.size()) {
            this.rankTopY[i] = Double.MAX_VALUE;
            this.rankBottomY[i] = 0.0;
            ++i;
        }
        Map<Object, mxGraphHierarchyEdge> edges = model.getEdgeMapper();
        Map<Object, mxGraphHierarchyNode> vertices = model.getVertexMapper();
        for (mxGraphAbstractHierarchyCell mxGraphAbstractHierarchyCell2 : vertices.values()) {
            this.setVertexLocation(mxGraphAbstractHierarchyCell2);
        }
        for (mxGraphAbstractHierarchyCell mxGraphAbstractHierarchyCell3 : edges.values()) {
            this.setEdgePosition(mxGraphAbstractHierarchyCell3);
        }
    }

    protected void setEdgePosition(mxGraphAbstractHierarchyCell cell) {
        if (cell.minRank == cell.maxRank) {
            return;
        }
        mxGraphHierarchyEdge edge = (mxGraphHierarchyEdge)cell;
        double offsetX = 0.0;
        if (edge.temp[0] != 101207) {
            for (Object realEdge : edge.edges) {
                ArrayList<mxPoint> newPoints = new ArrayList<mxPoint>(edge.x.length);
                int loopStart = edge.x.length - 1;
                int loopLimit = -1;
                int loopDelta = -1;
                int currentRank = edge.maxRank - 1;
                if (edge.isReversed()) {
                    loopStart = 0;
                    loopLimit = edge.x.length;
                    loopDelta = 1;
                    currentRank = edge.minRank + 1;
                }
                int j = loopStart;
                while (j != loopLimit) {
                    double positionX = edge.x[j] + offsetX;
                    double topChannelY = (this.rankTopY[currentRank] + this.rankBottomY[currentRank + 1]) / 2.0;
                    double bottomChannelY = (this.rankTopY[currentRank - 1] + this.rankBottomY[currentRank]) / 2.0;
                    if (edge.isReversed()) {
                        double tmp = topChannelY;
                        topChannelY = bottomChannelY;
                        bottomChannelY = tmp;
                    }
                    if (this.orientation == 1 || this.orientation == 5) {
                        newPoints.add(new mxPoint(positionX, topChannelY));
                        newPoints.add(new mxPoint(positionX, bottomChannelY));
                    } else {
                        newPoints.add(new mxPoint(topChannelY, positionX));
                        newPoints.add(new mxPoint(bottomChannelY, positionX));
                    }
                    this.limitX = Math.max(this.limitX, positionX);
                    currentRank += loopDelta;
                    j += loopDelta;
                }
                if (edge.isReversed()) {
                    this.processReversedEdge(edge, realEdge);
                }
                this.layout.setEdgePoints(realEdge, newPoints);
                offsetX = offsetX == 0.0 ? this.parallelEdgeSpacing : (offsetX > 0.0 ? -offsetX : -offsetX + this.parallelEdgeSpacing);
            }
            edge.temp[0] = 101207;
        }
    }

    protected void setVertexLocation(mxGraphAbstractHierarchyCell cell) {
        mxGraphHierarchyNode node = (mxGraphHierarchyNode)cell;
        Object realCell = node.cell;
        double positionX = node.x[0] - node.width / 2.0;
        double positionY = node.y[0] - node.height / 2.0;
        this.rankTopY[cell.minRank] = Math.min(this.rankTopY[cell.minRank], positionY);
        this.rankBottomY[cell.minRank] = Math.max(this.rankBottomY[cell.minRank], positionY + node.height);
        if (this.orientation == 1 || this.orientation == 5) {
            this.layout.setVertexLocation(realCell, positionX, positionY);
        } else {
            this.layout.setVertexLocation(realCell, positionY, positionX);
        }
        this.limitX = Math.max(this.limitX, positionX + node.width);
    }

    protected void processReversedEdge(mxGraphHierarchyEdge edge, Object realEdge) {
    }

    public double getInterRankCellSpacing() {
        return this.interRankCellSpacing;
    }

    public void setInterRankCellSpacing(double interRankCellSpacing) {
        this.interRankCellSpacing = interRankCellSpacing;
    }

    public double getIntraCellSpacing() {
        return this.intraCellSpacing;
    }

    public void setIntraCellSpacing(double intraCellSpacing) {
        this.intraCellSpacing = intraCellSpacing;
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void setOrientation(int orientation) {
        this.orientation = orientation;
    }

    public double getLimitX() {
        return this.limitX;
    }

    public void setLimitX(double limitX) {
        this.limitX = limitX;
    }

    public boolean isFineTuning() {
        return this.fineTuning;
    }

    public void setFineTuning(boolean fineTuning) {
        this.fineTuning = fineTuning;
    }

    public void setLoggerLevel(Level level) {
        try {
            logger.setLevel(level);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    protected class AreaSpatialCache
    extends Rectangle2D.Double {
        public Set<Object> cells = new HashSet<Object>();

        protected AreaSpatialCache() {
        }
    }

    static enum HierarchicalEdgeStyle {
        ORTHOGONAL,
        POLYLINE,
        STRAIGHT;

    }

    protected class WeightedCellSorter
    implements Comparable<Object> {
        public int weightedValue = 0;
        public boolean nudge = false;
        public boolean visited = false;
        public int rankIndex;
        public mxGraphAbstractHierarchyCell cell = null;

        public WeightedCellSorter() {
            this(null, 0);
        }

        public WeightedCellSorter(mxGraphAbstractHierarchyCell cell, int weightedValue) {
            this.cell = cell;
            this.weightedValue = weightedValue;
        }

        @Override
        public int compareTo(Object arg0) {
            if (arg0 instanceof WeightedCellSorter) {
                if (this.weightedValue > ((WeightedCellSorter)arg0).weightedValue) {
                    return -1;
                }
                if (this.weightedValue < ((WeightedCellSorter)arg0).weightedValue) {
                    return 1;
                }
                if (this.nudge) {
                    return -1;
                }
                return 1;
            }
            return 0;
        }
    }
}

