/*
 * Decompiled with CFR 0.152.
 */
package com.mxgraph.layout.hierarchical;

import com.mxgraph.layout.hierarchical.model.mxGraphHierarchyModel;
import com.mxgraph.layout.hierarchical.stage.mxCoordinateAssignment;
import com.mxgraph.layout.hierarchical.stage.mxMedianHybridCrossingReduction;
import com.mxgraph.layout.hierarchical.stage.mxMinimumCycleRemover;
import com.mxgraph.layout.mxGraphLayout;
import com.mxgraph.model.mxIGraphModel;
import com.mxgraph.view.mxGraph;
import java.awt.Point;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;

public class mxHierarchicalLayout
extends mxGraphLayout {
    protected List<Object> roots = null;
    protected boolean resizeParent = false;
    protected boolean moveParent = false;
    protected int parentBorder = 0;
    protected double intraCellSpacing = 30.0;
    protected double interRankCellSpacing = 50.0;
    protected double interHierarchySpacing = 60.0;
    protected double parallelEdgeSpacing = 10.0;
    protected int orientation = 1;
    protected boolean disableEdgeStyle = true;
    protected boolean fineTuning = true;
    protected boolean deterministic;
    protected boolean fixRoots = false;
    protected boolean layoutFromSinks = true;
    protected mxGraphHierarchyModel model = null;
    private static Logger logger = Logger.getLogger("com.jgraph.layout.hierarchical.JGraphHierarchicalLayout");

    public mxHierarchicalLayout(mxGraph graph) {
        this(graph, 1);
    }

    public mxHierarchicalLayout(mxGraph graph, int orientation) {
        super(graph);
        this.orientation = orientation;
    }

    public mxGraphHierarchyModel getModel() {
        return this.model;
    }

    @Override
    public void execute(Object parent) {
        this.execute(parent, null);
    }

    public void execute(Object parent, List<Object> roots) {
        if (roots == null) {
            roots = this.graph.findTreeRoots(parent);
        }
        this.roots = roots;
        mxIGraphModel model = this.graph.getModel();
        model.beginUpdate();
        try {
            this.run(parent);
            if (this.isResizeParent() && !this.graph.isCellCollapsed(parent)) {
                this.graph.updateGroupBounds(new Object[]{parent}, this.getParentBorder(), this.isMoveParent());
            }
        }
        finally {
            model.endUpdate();
        }
    }

    public void run(Object parent) {
        Iterator iter;
        ArrayList hierarchyVertices = new ArrayList();
        ArrayList<Object> fixedRoots = null;
        ArrayList<Point> rootLocations = null;
        ArrayList affectedEdges = null;
        if (this.fixRoots) {
            fixedRoots = new ArrayList<Object>();
            rootLocations = new ArrayList<Point>();
            affectedEdges = new ArrayList();
        }
        int i = 0;
        while (i < this.roots.size()) {
            boolean newHierarchy = true;
            iter = hierarchyVertices.iterator();
            while (newHierarchy && iter.hasNext()) {
                if (!((Set)iter.next()).contains(this.roots.get(i))) continue;
                newHierarchy = false;
            }
            if (newHierarchy) {
                Stack<Object> cellsStack = new Stack<Object>();
                cellsStack.push(this.roots.get(i));
                HashSet<Object> edgeSet = null;
                if (this.fixRoots) {
                    fixedRoots.add(this.roots.get(i));
                    Point location = this.getVertexBounds(this.roots.get(i)).getPoint();
                    rootLocations.add(location);
                    edgeSet = new HashSet<Object>();
                }
                HashSet vertexSet = new HashSet();
                while (!cellsStack.isEmpty()) {
                    Object cell = cellsStack.pop();
                    if (vertexSet.contains(cell)) continue;
                    vertexSet.add(cell);
                    if (this.fixRoots) {
                        edgeSet.addAll(Arrays.asList(this.graph.getIncomingEdges(cell, parent)));
                    }
                    Object[] conns = this.graph.getConnections(cell, parent);
                    Object[] cells = this.graph.getOpposites(conns, cell);
                    int j = 0;
                    while (j < cells.length) {
                        if (!vertexSet.contains(cells[j])) {
                            cellsStack.push(cells[j]);
                        }
                        ++j;
                    }
                }
                hierarchyVertices.add(vertexSet);
                if (this.fixRoots) {
                    affectedEdges.add(edgeSet);
                }
            }
            ++i;
        }
        double initialX = 0.0;
        iter = hierarchyVertices.iterator();
        int i2 = 0;
        while (iter.hasNext()) {
            Set vertexSet = (Set)iter.next();
            this.model = new mxGraphHierarchyModel(this, vertexSet.toArray(), this.roots, parent, false, this.deterministic, this.layoutFromSinks);
            this.cycleStage(parent);
            this.layeringStage();
            this.crossingStage(parent);
            initialX = this.placementStage(initialX, parent);
            if (!this.fixRoots) continue;
            Object root = fixedRoots.get(i2);
            Point2D oldLocation = (Point2D)rootLocations.get(i2);
            Point newLocation = this.graph.getModel().getGeometry(root).getPoint();
            double diffX = oldLocation.getX() - ((Point2D)newLocation).getX();
            double diffY = oldLocation.getY() - ((Point2D)newLocation).getY();
            this.graph.moveCells(vertexSet.toArray(), diffX, diffY);
            Set connectedEdges = (Set)affectedEdges.get(i2++);
            this.graph.moveCells(connectedEdges.toArray(), diffX, diffY);
        }
    }

    public void cycleStage(Object parent) {
        mxMinimumCycleRemover cycleStage = new mxMinimumCycleRemover(this);
        cycleStage.execute(parent);
    }

    public void layeringStage() {
        this.model.initialRank();
        this.model.fixRanks();
    }

    public void crossingStage(Object parent) {
        mxMedianHybridCrossingReduction crossingStage = new mxMedianHybridCrossingReduction(this);
        crossingStage.execute(parent);
    }

    public double placementStage(double initialX, Object parent) {
        mxCoordinateAssignment placementStage = new mxCoordinateAssignment(this, this.intraCellSpacing, this.interRankCellSpacing, this.orientation, initialX, this.parallelEdgeSpacing);
        placementStage.setFineTuning(this.fineTuning);
        placementStage.execute(parent);
        return placementStage.getLimitX() + this.interHierarchySpacing;
    }

    public boolean isResizeParent() {
        return this.resizeParent;
    }

    public void setResizeParent(boolean value) {
        this.resizeParent = value;
    }

    public boolean isMoveParent() {
        return this.moveParent;
    }

    public void setMoveParent(boolean value) {
        this.moveParent = value;
    }

    public int getParentBorder() {
        return this.parentBorder;
    }

    public void setParentBorder(int value) {
        this.parentBorder = value;
    }

    public double getIntraCellSpacing() {
        return this.intraCellSpacing;
    }

    public void setIntraCellSpacing(double intraCellSpacing) {
        this.intraCellSpacing = intraCellSpacing;
    }

    public double getInterRankCellSpacing() {
        return this.interRankCellSpacing;
    }

    public void setInterRankCellSpacing(double interRankCellSpacing) {
        this.interRankCellSpacing = interRankCellSpacing;
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void setOrientation(int orientation) {
        this.orientation = orientation;
    }

    public double getInterHierarchySpacing() {
        return this.interHierarchySpacing;
    }

    public void setInterHierarchySpacing(double interHierarchySpacing) {
        this.interHierarchySpacing = interHierarchySpacing;
    }

    public double getParallelEdgeSpacing() {
        return this.parallelEdgeSpacing;
    }

    public void setParallelEdgeSpacing(double parallelEdgeSpacing) {
        this.parallelEdgeSpacing = parallelEdgeSpacing;
    }

    public boolean isFineTuning() {
        return this.fineTuning;
    }

    public void setFineTuning(boolean fineTuning) {
        this.fineTuning = fineTuning;
    }

    public boolean isDisableEdgeStyle() {
        return this.disableEdgeStyle;
    }

    public void setDisableEdgeStyle(boolean disableEdgeStyle) {
        this.disableEdgeStyle = disableEdgeStyle;
    }

    public boolean isDeterministic() {
        return this.deterministic;
    }

    public void setDeterministic(boolean deterministic) {
        this.deterministic = deterministic;
    }

    public boolean isFixRoots() {
        return this.fixRoots;
    }

    public void setFixRoots(boolean fixRoots) {
        this.fixRoots = fixRoots;
    }

    public boolean isLayoutFromSinks() {
        return this.layoutFromSinks;
    }

    public void setLayoutFromSinks(boolean layoutFromSinks) {
        this.layoutFromSinks = layoutFromSinks;
    }

    public void setLoggerLevel(Level level) {
        try {
            logger.setLevel(level);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    public String toString() {
        return "Hierarchical";
    }
}

