/*
 * Decompiled with CFR 0.152.
 */
package com.mxgraph.layout.hierarchical.model;

import com.mxgraph.layout.hierarchical.model.mxGraphHierarchyEdge;
import com.mxgraph.layout.hierarchical.model.mxGraphHierarchyNode;
import com.mxgraph.layout.hierarchical.model.mxGraphHierarchyRank;
import com.mxgraph.layout.hierarchical.mxHierarchicalLayout;
import com.mxgraph.view.mxGraph;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class mxGraphHierarchyModel {
    protected boolean scanRanksFromSinks = true;
    public int maxRank;
    protected Map<Object, mxGraphHierarchyNode> vertexMapper = null;
    protected Map<Object, mxGraphHierarchyEdge> edgeMapper = null;
    public Map<Integer, mxGraphHierarchyRank> ranks = null;
    public List<Object> roots;
    public Object parent = null;
    protected int dfsCount = 0;
    protected boolean deterministic = false;
    private final int SOURCESCANSTARTRANK = 100000000;

    public mxGraphHierarchyModel(mxHierarchicalLayout layout, Object[] vertices, List<Object> roots, Object parent, boolean ordered, boolean deterministic, boolean scanRanksFromSinks) {
        mxGraph graph = layout.getGraph();
        this.deterministic = deterministic;
        this.scanRanksFromSinks = scanRanksFromSinks;
        this.roots = roots;
        this.parent = parent;
        if (vertices == null) {
            vertices = graph.getChildVertices(parent);
        }
        if (ordered) {
            this.formOrderedHierarchy(layout, vertices, parent);
        } else {
            this.vertexMapper = new Hashtable<Object, mxGraphHierarchyNode>(vertices.length);
            this.edgeMapper = new Hashtable<Object, mxGraphHierarchyEdge>(vertices.length);
            this.maxRank = scanRanksFromSinks ? 0 : 100000000;
            mxGraphHierarchyNode[] internalVertices = new mxGraphHierarchyNode[vertices.length];
            this.createInternalCells(layout, vertices, internalVertices);
            int i = 0;
            while (i < vertices.length) {
                Collection<mxGraphHierarchyEdge> edges = internalVertices[i].connectsAsSource;
                for (mxGraphHierarchyEdge internalEdge : edges) {
                    List<Object> realEdges = internalEdge.edges;
                    Iterator iter2 = realEdges.iterator();
                    if (!iter2.hasNext()) continue;
                    Object realEdge = iter2.next();
                    Object targetCell = graph.getView().getVisibleTerminal(realEdge, false);
                    mxGraphHierarchyNode internalTargetCell = this.vertexMapper.get(targetCell);
                    if (internalTargetCell == null || internalVertices[i] == internalTargetCell) continue;
                    internalEdge.target = internalTargetCell;
                    if (internalTargetCell.connectsAsTarget.size() == 0) {
                        internalTargetCell.connectsAsTarget = new LinkedHashSet<mxGraphHierarchyEdge>(4);
                    }
                    internalTargetCell.connectsAsTarget.add(internalEdge);
                }
                internalVertices[i].temp[0] = 1;
                ++i;
            }
        }
    }

    public void formOrderedHierarchy(mxHierarchicalLayout layout, Object[] vertices, Object parent) {
        mxGraph graph = layout.getGraph();
        this.vertexMapper = new Hashtable<Object, mxGraphHierarchyNode>(vertices.length * 2);
        this.edgeMapper = new Hashtable<Object, mxGraphHierarchyEdge>(vertices.length);
        this.maxRank = 0;
        mxGraphHierarchyNode[] internalVertices = new mxGraphHierarchyNode[vertices.length];
        this.createInternalCells(layout, vertices, internalVertices);
        ArrayList<mxGraphHierarchyEdge> tempList = new ArrayList<mxGraphHierarchyEdge>();
        int i = 0;
        while (i < vertices.length) {
            Collection<mxGraphHierarchyEdge> edges = internalVertices[i].connectsAsSource;
            for (mxGraphHierarchyEdge internalEdge : edges) {
                List<Object> realEdges = internalEdge.edges;
                Iterator iter2 = realEdges.iterator();
                if (!iter2.hasNext()) continue;
                Object realEdge = iter2.next();
                Object targetCell = graph.getView().getVisibleTerminal(realEdge, false);
                mxGraphHierarchyNode internalTargetCell = this.vertexMapper.get(targetCell);
                if (internalTargetCell == null || internalVertices[i] == internalTargetCell) continue;
                internalEdge.target = internalTargetCell;
                if (internalTargetCell.connectsAsTarget.size() == 0) {
                    internalTargetCell.connectsAsTarget = new ArrayList<mxGraphHierarchyEdge>(4);
                }
                if (internalTargetCell.temp[0] == 1) {
                    internalEdge.invert();
                    internalTargetCell.connectsAsSource.add(internalEdge);
                    tempList.add(internalEdge);
                    internalVertices[i].connectsAsTarget.add(internalEdge);
                    continue;
                }
                internalTargetCell.connectsAsTarget.add(internalEdge);
            }
            Iterator iter2 = tempList.iterator();
            while (iter2.hasNext()) {
                internalVertices[i].connectsAsSource.remove(iter2.next());
            }
            tempList.clear();
            internalVertices[i].temp[0] = 1;
            ++i;
        }
    }

    protected void createInternalCells(mxHierarchicalLayout layout, Object[] vertices, mxGraphHierarchyNode[] internalVertices) {
        mxGraph graph = layout.getGraph();
        int i = 0;
        while (i < vertices.length) {
            internalVertices[i] = new mxGraphHierarchyNode(vertices[i]);
            this.vertexMapper.put(vertices[i], internalVertices[i]);
            Object[] conns = graph.getConnections(vertices[i], this.parent);
            List<Object> outgoingCells = Arrays.asList(graph.getOpposites(conns, vertices[i]));
            internalVertices[i].connectsAsSource = new LinkedHashSet<mxGraphHierarchyEdge>(outgoingCells.size());
            for (Object cell : outgoingCells) {
                Object[] edges;
                if (cell == vertices[i] || !graph.getModel().isVertex(cell) || layout.isVertexIgnored(cell) || (edges = graph.getEdgesBetween(vertices[i], cell, true)) == null || edges.length <= 0) continue;
                ArrayList<Object> listEdges = new ArrayList<Object>(edges.length);
                int j = 0;
                while (j < edges.length) {
                    listEdges.add(edges[j]);
                    ++j;
                }
                mxGraphHierarchyEdge internalEdge = new mxGraphHierarchyEdge(listEdges);
                for (Object edge : listEdges) {
                    this.edgeMapper.put(edge, internalEdge);
                    graph.resetEdge(edge);
                    if (!layout.isDisableEdgeStyle()) continue;
                    layout.setEdgeStyleEnabled(edge, false);
                    layout.setOrthogonalEdge(edge, true);
                }
                internalEdge.source = internalVertices[i];
                internalVertices[i].connectsAsSource.add(internalEdge);
            }
            internalVertices[i].temp[0] = 0;
            ++i;
        }
    }

    public void initialRank() {
        Collection<mxGraphHierarchyNode> internalNodes = this.vertexMapper.values();
        LinkedList<mxGraphHierarchyNode> startNodes = new LinkedList<mxGraphHierarchyNode>();
        if (!this.scanRanksFromSinks && this.roots != null) {
            Iterator<Object> iter = this.roots.iterator();
            while (iter.hasNext()) {
                mxGraphHierarchyNode internalNode = this.vertexMapper.get(iter.next());
                if (internalNode == null) continue;
                startNodes.add(internalNode);
            }
        }
        if (this.scanRanksFromSinks) {
            for (mxGraphHierarchyNode internalNode : internalNodes) {
                if (internalNode.connectsAsSource != null && !internalNode.connectsAsSource.isEmpty()) continue;
                startNodes.add(internalNode);
            }
        }
        if (startNodes.isEmpty()) {
            for (mxGraphHierarchyNode internalNode : internalNodes) {
                if (internalNode.connectsAsTarget != null && !internalNode.connectsAsTarget.isEmpty()) continue;
                startNodes.add(internalNode);
            }
        }
        for (mxGraphHierarchyNode internalNode : internalNodes) {
            internalNode.temp[0] = -1;
        }
        ArrayList startNodesCopy = new ArrayList(startNodes);
        while (!startNodes.isEmpty()) {
            Collection<mxGraphHierarchyEdge> edgesToBeMarked;
            Collection<mxGraphHierarchyEdge> layerDeterminingEdges;
            mxGraphHierarchyNode internalNode = (mxGraphHierarchyNode)startNodes.getFirst();
            if (this.scanRanksFromSinks) {
                layerDeterminingEdges = internalNode.connectsAsSource;
                edgesToBeMarked = internalNode.connectsAsTarget;
            } else {
                layerDeterminingEdges = internalNode.connectsAsTarget;
                edgesToBeMarked = internalNode.connectsAsSource;
            }
            boolean allEdgesScanned = true;
            Iterator<mxGraphHierarchyEdge> iter2 = layerDeterminingEdges.iterator();
            int minimumLayer = 0;
            if (!this.scanRanksFromSinks) {
                minimumLayer = 100000000;
            }
            while (allEdgesScanned && iter2.hasNext()) {
                mxGraphHierarchyEdge internalEdge = iter2.next();
                if (internalEdge.temp[0] == 5270620) {
                    mxGraphHierarchyNode otherNode = this.scanRanksFromSinks ? internalEdge.target : internalEdge.source;
                    if (this.scanRanksFromSinks) {
                        minimumLayer = Math.max(minimumLayer, otherNode.temp[0] + 1);
                        continue;
                    }
                    minimumLayer = Math.min(minimumLayer, otherNode.temp[0] - 1);
                    continue;
                }
                allEdgesScanned = false;
            }
            if (allEdgesScanned) {
                internalNode.temp[0] = minimumLayer;
                this.maxRank = this.scanRanksFromSinks ? Math.max(this.maxRank, minimumLayer) : Math.min(this.maxRank, minimumLayer);
                if (edgesToBeMarked != null) {
                    for (mxGraphHierarchyEdge internalEdge : edgesToBeMarked) {
                        internalEdge.temp[0] = 5270620;
                        mxGraphHierarchyNode otherNode = this.scanRanksFromSinks ? internalEdge.source : internalEdge.target;
                        if (otherNode.temp[0] != -1) continue;
                        startNodes.addLast(otherNode);
                        otherNode.temp[0] = -2;
                    }
                }
                startNodes.removeFirst();
                continue;
            }
            Object removedCell = startNodes.removeFirst();
            startNodes.addLast(internalNode);
            if (removedCell == internalNode && startNodes.size() == 1) break;
        }
        if (this.scanRanksFromSinks) {
            int i = 0;
            while (i < startNodesCopy.size()) {
                mxGraphHierarchyNode internalNode = (mxGraphHierarchyNode)startNodesCopy.get(i);
                int currentMinLayer = 1000000;
                for (mxGraphHierarchyEdge internalEdge : internalNode.connectsAsTarget) {
                    mxGraphHierarchyNode otherNode = internalEdge.source;
                    internalNode.temp[0] = Math.min(currentMinLayer, otherNode.temp[0] - 1);
                    currentMinLayer = internalNode.temp[0];
                }
                ++i;
            }
        } else {
            for (mxGraphHierarchyNode internalNode : internalNodes) {
                internalNode.temp[0] = internalNode.temp[0] - this.maxRank;
            }
            this.maxRank = 100000000 - this.maxRank;
        }
    }

    public void fixRanks() {
        final mxGraphHierarchyRank[] rankList = new mxGraphHierarchyRank[this.maxRank + 1];
        this.ranks = new LinkedHashMap<Integer, mxGraphHierarchyRank>(this.maxRank + 1);
        int i = 0;
        while (i < this.maxRank + 1) {
            rankList[i] = new mxGraphHierarchyRank();
            this.ranks.put(new Integer(i), rankList[i]);
            ++i;
        }
        mxGraphHierarchyNode[] rootsArray = null;
        if (this.roots != null) {
            Object[] oldRootsArray = this.roots.toArray();
            rootsArray = new mxGraphHierarchyNode[oldRootsArray.length];
            int i2 = 0;
            while (i2 < oldRootsArray.length) {
                mxGraphHierarchyNode internalNode;
                Object node = oldRootsArray[i2];
                rootsArray[i2] = internalNode = this.vertexMapper.get(node);
                ++i2;
            }
        }
        this.visit(new CellVisitor(){

            @Override
            public void visit(mxGraphHierarchyNode parent, mxGraphHierarchyNode cell, mxGraphHierarchyEdge connectingEdge, int layer, int seen) {
                int parentToCellRankDifference;
                mxGraphHierarchyNode node = cell;
                if (seen == 0 && node.maxRank < 0 && node.minRank < 0) {
                    rankList[node.temp[0]].add(cell);
                    node.maxRank = node.temp[0];
                    node.minRank = node.temp[0];
                    node.temp[0] = rankList[node.maxRank].size() - 1;
                }
                if (parent != null && connectingEdge != null && (parentToCellRankDifference = parent.maxRank - node.maxRank) > 1) {
                    mxGraphHierarchyEdge edge = connectingEdge;
                    edge.maxRank = parent.maxRank;
                    edge.minRank = cell.maxRank;
                    edge.temp = new int[parentToCellRankDifference - 1];
                    edge.x = new double[parentToCellRankDifference - 1];
                    edge.y = new double[parentToCellRankDifference - 1];
                    int i = edge.minRank + 1;
                    while (i < edge.maxRank) {
                        rankList[i].add(edge);
                        edge.setGeneralPurposeVariable(i, rankList[i].size() - 1);
                        ++i;
                    }
                }
            }
        }, rootsArray, false, null);
    }

    public void visit(CellVisitor visitor, mxGraphHierarchyNode[] dfsRoots, boolean trackAncestors, Set<mxGraphHierarchyNode> seenNodes) {
        if (dfsRoots != null) {
            int i = 0;
            while (i < dfsRoots.length) {
                mxGraphHierarchyNode internalNode = dfsRoots[i];
                if (internalNode != null) {
                    if (seenNodes == null) {
                        seenNodes = new HashSet<mxGraphHierarchyNode>();
                    }
                    if (trackAncestors) {
                        internalNode.hashCode = new int[2];
                        internalNode.hashCode[0] = this.dfsCount;
                        internalNode.hashCode[1] = i;
                        this.dfs(null, internalNode, null, visitor, seenNodes, internalNode.hashCode, i, 0);
                    } else {
                        this.dfs(null, internalNode, null, visitor, seenNodes, 0);
                    }
                }
                ++i;
            }
            ++this.dfsCount;
        }
    }

    public void dfs(mxGraphHierarchyNode parent, mxGraphHierarchyNode root, mxGraphHierarchyEdge connectingEdge, CellVisitor visitor, Set<mxGraphHierarchyNode> seen, int layer) {
        if (root != null) {
            if (!seen.contains(root)) {
                visitor.visit(parent, root, connectingEdge, layer, 0);
                seen.add(root);
                Object[] outgoingEdges = root.connectsAsSource.toArray();
                int i = 0;
                while (i < outgoingEdges.length) {
                    mxGraphHierarchyEdge internalEdge = (mxGraphHierarchyEdge)outgoingEdges[i];
                    mxGraphHierarchyNode targetNode = internalEdge.target;
                    this.dfs(root, targetNode, internalEdge, visitor, seen, layer + 1);
                    ++i;
                }
            } else {
                visitor.visit(parent, root, connectingEdge, layer, 1);
            }
        }
    }

    public void dfs(mxGraphHierarchyNode parent, mxGraphHierarchyNode root, mxGraphHierarchyEdge connectingEdge, CellVisitor visitor, Set<mxGraphHierarchyNode> seen, int[] ancestors, int childHash, int layer) {
        if (root != null) {
            if (parent != null && (root.hashCode == null || root.hashCode[0] != parent.hashCode[0])) {
                int hashCodeLength = parent.hashCode.length + 1;
                root.hashCode = new int[hashCodeLength];
                System.arraycopy(parent.hashCode, 0, root.hashCode, 0, parent.hashCode.length);
                root.hashCode[hashCodeLength - 1] = childHash;
            }
            if (!seen.contains(root)) {
                visitor.visit(parent, root, connectingEdge, layer, 0);
                seen.add(root);
                Object[] outgoingEdges = root.connectsAsSource.toArray();
                int i = 0;
                while (i < outgoingEdges.length) {
                    mxGraphHierarchyEdge internalEdge = (mxGraphHierarchyEdge)outgoingEdges[i];
                    mxGraphHierarchyNode targetNode = internalEdge.target;
                    this.dfs(root, targetNode, internalEdge, visitor, seen, root.hashCode, i, layer + 1);
                    ++i;
                }
            } else {
                visitor.visit(parent, root, connectingEdge, layer, 1);
            }
        }
    }

    public Map<Object, mxGraphHierarchyNode> getVertexMapper() {
        if (this.vertexMapper == null) {
            this.vertexMapper = new Hashtable<Object, mxGraphHierarchyNode>();
        }
        return this.vertexMapper;
    }

    public void setVertexMapper(Map<Object, mxGraphHierarchyNode> vertexMapping) {
        this.vertexMapper = vertexMapping;
    }

    public Map<Object, mxGraphHierarchyEdge> getEdgeMapper() {
        return this.edgeMapper;
    }

    public void setEdgeMapper(Map<Object, mxGraphHierarchyEdge> edgeMapper) {
        this.edgeMapper = edgeMapper;
    }

    public int getDfsCount() {
        return this.dfsCount;
    }

    public void setDfsCount(int dfsCount) {
        this.dfsCount = dfsCount;
    }

    public boolean isDeterministic() {
        return this.deterministic;
    }

    public void setDeterministic(boolean deterministic) {
        this.deterministic = deterministic;
    }

    public static interface CellVisitor {
        public void visit(mxGraphHierarchyNode var1, mxGraphHierarchyNode var2, mxGraphHierarchyEdge var3, int var4, int var5);
    }
}

