/*
 * Decompiled with CFR 0.152.
 */
package com.mxgraph.io.vdx;

import com.mxgraph.io.vdx.PageShapeIDKey;
import com.mxgraph.util.mxPoint;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class mxVdxUtils {
    private static double screenCoordinatesPerCm = 40.0;
    private static final double CENTIMETERS_PER_INCHES = 2.54;

    public static boolean nodeListHasTag(NodeList nl, String tag) {
        boolean has = false;
        if (nl != null) {
            int length = nl.getLength();
            int i = 0;
            while (i < length && !has) {
                has = nl.item(i).getNodeName().equals(tag);
                ++i;
            }
        }
        return has;
    }

    public static Element nodeListTag(NodeList nl, String tag) {
        if (nl != null) {
            int length = nl.getLength();
            boolean has = false;
            int i = 0;
            while (i < length && !has) {
                has = nl.item(i).getNodeName().equals(tag);
                if (has) {
                    return (Element)nl.item(i);
                }
                ++i;
            }
        }
        return null;
    }

    public static Element nodeListTagIndexed(NodeList nl, String tag, String ix) {
        if (nl != null) {
            int length = nl.getLength();
            boolean has = false;
            int i = 0;
            while (i < length && !has) {
                boolean bl = has = nl.item(i).getNodeName().equals(tag) && ((Element)nl.item(i)).getAttribute("IX").equals(ix);
                if (has) {
                    return (Element)nl.item(i);
                }
                ++i;
            }
        }
        return null;
    }

    public static List<Element> nodeListTags(NodeList nl, String tag) {
        ArrayList<Element> ret = new ArrayList<Element>();
        if (nl != null) {
            int length = nl.getLength();
            int i = 0;
            while (i < length) {
                if (tag.equals(nl.item(i).getNodeName())) {
                    ret.add((Element)nl.item(i));
                }
                ++i;
            }
        }
        return ret;
    }

    public static List<Node> copyNodeList(NodeList nodeList) {
        ArrayList<Node> copy = new ArrayList<Node>();
        int length = nodeList.getLength();
        int i = 0;
        while (i < length) {
            copy.add(nodeList.item(i));
            ++i;
        }
        return copy;
    }

    public static double conversionFactor() {
        double ret = 0.0;
        ret = screenCoordinatesPerCm * 2.54;
        return ret;
    }

    public static mxPoint adjustConstraint(mxPoint constraint) {
        constraint.setX(Math.max(0.0, constraint.getX()));
        constraint.setY(Math.max(0.0, constraint.getY()));
        constraint.setX(Math.min(1.0, constraint.getX()));
        constraint.setY(Math.min(1.0, constraint.getY()));
        return constraint;
    }

    public static String getStyleString(Map<String, Object> styleMap, String asig) {
        String style = "";
        Iterator<Object> it = styleMap.values().iterator();
        for (String key : styleMap.keySet()) {
            Object value = it.next();
            style = String.valueOf(style) + key + asig + value + ";";
        }
        return style;
    }

    public static String surroundedByTags(String text, String tag) {
        return "<" + tag + ">" + text + "</" + tag + ">";
    }

    public static String toInitialCapital(String text) {
        String[] words = text.split(" ");
        String ret = "";
        String[] stringArray = words;
        int n = words.length;
        int n2 = 0;
        while (n2 < n) {
            String word = stringArray[n2];
            String begin = word.substring(0, 1);
            word = word.substring(1);
            begin = begin.toUpperCase();
            ret = String.valueOf(ret) + begin + word;
            ++n2;
        }
        return ret.substring(0, ret.length());
    }

    public static String toSmallCaps(String text, String size) {
        String ret = "";
        if (!size.equals(ret)) {
            char[] letters;
            char a = 'a';
            char z = 'z';
            char[] cArray = letters = text.toCharArray();
            int n = letters.length;
            int n2 = 0;
            while (n2 < n) {
                char c = cArray[n2];
                if (c >= a && c <= z) {
                    String s = String.valueOf(c);
                    s = s.toUpperCase();
                    ret = String.valueOf(ret) + "<font style=\"font-size:" + Double.valueOf(size) / 1.28 + "px\">" + s + "</font>";
                } else {
                    ret = String.valueOf(ret) + c;
                }
                ++n2;
            }
        } else {
            ret = text;
        }
        return ret;
    }

    public static HashMap<String, Object> getStyleMap(String style, String asig) {
        String[] entries;
        HashMap<String, Object> styleMap = new HashMap<String, Object>();
        String[] stringArray = entries = style.split(";");
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            String entry = stringArray[n2];
            int index = entry.indexOf(asig);
            String key = entry.substring(0, index);
            String value = entry.substring(index + 1);
            styleMap.put(key, value);
            ++n2;
        }
        return styleMap;
    }

    public static void printPointList(List<mxPoint> list) {
        int i = 0;
        for (mxPoint p : list) {
            System.out.println("Point " + ++i + " X=" + p.getX() + ", Y=" + p.getY());
        }
    }

    public static Object[] getOrderArray(List<PageShapeIDKey> orderList, HashMap<PageShapeIDKey, Object> map) {
        int length = orderList.size();
        Object[] array = new Object[length];
        int i = 0;
        for (PageShapeIDKey key : orderList) {
            array[i] = map.get(key);
            ++i;
        }
        return array;
    }
}

