/*
 * Decompiled with CFR 0.152.
 */
package com.mxgraph.io.vdx;

import com.mxgraph.io.vdx.mxMasterShape;
import com.mxgraph.io.vdx.mxPropertiesManager;
import com.mxgraph.io.vdx.mxStyleSheet;
import com.mxgraph.io.vdx.mxVdxShape;
import com.mxgraph.io.vdx.mxVdxUtils;
import com.mxgraph.util.mxUtils;
import java.util.HashMap;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class mxVdxTextParser {
    mxVdxShape shape;
    mxMasterShape masterShape;
    mxStyleSheet styleSheet;
    mxStyleSheet defaultStyle;
    String cp = "";
    String pp = "";
    String tp = "";
    String fld = "";

    public mxVdxTextParser(mxVdxShape shape, mxMasterShape masterShape, mxStyleSheet styleSheet) {
        this.shape = shape;
        this.masterShape = masterShape;
        this.styleSheet = styleSheet;
        this.defaultStyle = mxPropertiesManager.getInstance().getTextStyle();
    }

    public String getHtmlTextContent() {
        List<Node> child = null;
        String ret = "";
        if (this.shape.hasText()) {
            child = this.shape.getTextChildrens();
        } else if (this.masterShape != null && this.masterShape.hasText()) {
            child = this.masterShape.getTextChildrens();
        }
        boolean first = true;
        if (child != null) {
            for (Node e : child) {
                Element elem;
                if (e.getNodeName().equals("cp")) {
                    elem = (Element)e;
                    this.cp = elem.getAttribute("IX");
                    continue;
                }
                if (e.getNodeName().equals("tp")) {
                    elem = (Element)e;
                    this.tp = elem.getAttribute("IX");
                    continue;
                }
                if (e.getNodeName().equals("pp")) {
                    elem = (Element)e;
                    this.pp = elem.getAttribute("IX");
                    if (first) {
                        first = false;
                    } else {
                        ret = String.valueOf(ret) + "</p>";
                    }
                    String para = "<p>";
                    ret = String.valueOf(ret) + this.getTextParagraphFormated(para);
                    continue;
                }
                if (e.getNodeName().equals("fld")) {
                    elem = (Element)e;
                    this.fld = elem.getAttribute("IX");
                    String text = elem.getTextContent();
                    text = this.textToList(text, this.pp);
                    text = text.replaceAll("\n", "<br/>");
                    ret = String.valueOf(ret) + this.getTextCharFormated(text);
                    continue;
                }
                if (!e.getNodeName().equals("#text")) continue;
                String text = e.getNodeValue();
                text = this.textToList(text, this.pp);
                text = mxUtils.htmlEntities(text);
                text = text.replaceAll("\n", "<br/>");
                ret = String.valueOf(ret) + this.getTextCharFormated(text);
            }
        }
        String end = first ? "" : "</p>";
        ret = String.valueOf(ret) + end;
        if (!this.shape.hasXForm1D()) {
            ret = mxVdxUtils.surroundedByTags(ret, "div");
            HashMap<String, Object> styleMap = new HashMap<String, Object>();
            styleMap.put("width", String.valueOf(this.shape.getDimentions().getX() * 0.71) + "px");
            styleMap.put("max-width", String.valueOf(this.shape.getDimentions().getX() * 0.71) + "px");
            ret = this.insertAttributes(ret, styleMap);
        }
        return ret;
    }

    public String textToList(String text, String pp) {
        String bullet;
        if (!pp.equals("") && !(bullet = this.getBulletValue(pp)).equals("0")) {
            String[] entries = text.split("\n");
            String ret = "";
            String[] stringArray = entries;
            int n = entries.length;
            int n2 = 0;
            while (n2 < n) {
                String entry = stringArray[n2];
                ret = String.valueOf(ret) + mxVdxUtils.surroundedByTags(entry, "li");
                ++n2;
            }
            ret = mxVdxUtils.surroundedByTags(ret, "ul");
            HashMap<String, Object> styleMap = new HashMap<String, Object>();
            if (bullet.equals("4")) {
                styleMap.put("list-style-type", "square");
            } else {
                styleMap.put("list-style-type", "disc");
            }
            ret = this.insertAttributes(ret, styleMap);
            return ret;
        }
        return text;
    }

    public String getBulletValue(String index) {
        String bullet = "0";
        if (this.shape.hasBullet(index)) {
            bullet = this.shape.getBullet(index);
        } else if (this.masterShape != null && this.masterShape.hasBullet(index)) {
            bullet = this.masterShape.getBullet(index);
        } else if (this.styleSheet != null && this.styleSheet.hasBullet(index)) {
            bullet = this.styleSheet.getBullet(index);
        } else if (this.defaultStyle != null && this.defaultStyle.hasBullet(index)) {
            bullet = this.defaultStyle.getBullet(index);
        }
        return bullet;
    }

    public String getTextParagraphFormated(String para) {
        String ret = "";
        HashMap<String, Object> styleMap = new HashMap<String, Object>();
        styleMap.put("text-align", this.getHorzAlign(this.pp));
        styleMap.put("text-indent", this.getIndFirst(this.pp));
        styleMap.put("margin-left", this.getIndLeft(this.pp));
        styleMap.put("margin-right", this.getIndRight(this.pp));
        styleMap.put("margin-top", String.valueOf(this.getSpcBefore(this.pp)) + "px");
        styleMap.put("margin-bottom", String.valueOf(this.getSpcAfter(this.pp)) + "px");
        styleMap.put("line-height", this.getSpcLine(this.pp));
        styleMap.put("direction", this.getTextDirection(this.pp));
        ret = String.valueOf(ret) + this.insertAttributes(para, styleMap);
        return ret;
    }

    public String getTextDirection(String index) {
        String direction = "ltr";
        if (this.shape.hasFlags(index)) {
            direction = this.shape.getFlags(index);
        } else if (this.masterShape != null && this.masterShape.hasFlags(index)) {
            direction = this.masterShape.getFlags(index);
        } else if (this.styleSheet != null && this.styleSheet.hasFlags(index)) {
            direction = this.styleSheet.getFlags(index);
        } else if (this.defaultStyle != null && this.defaultStyle.hasFlags(index)) {
            direction = this.defaultStyle.getFlags(index);
        }
        if (direction.equals("0")) {
            direction = "ltr";
        } else if (direction.equals("1")) {
            direction = "rtl";
        }
        return direction;
    }

    public String getSpcLine(String index) {
        String ret = "0";
        boolean isPercent = false;
        double space = 0.0;
        if (this.shape.hasSpLine(index)) {
            space = this.shape.getSpLine(index);
        } else if (this.masterShape != null && this.masterShape.hasSpLine(index)) {
            space = this.masterShape.getSpLine(index);
        } else if (this.styleSheet != null && this.styleSheet.hasSpLine(index)) {
            space = this.styleSheet.getSpLine(index);
        } else if (this.defaultStyle != null && this.defaultStyle.hasSpLine(index)) {
            space = this.defaultStyle.getSpLine(index);
        }
        if (space > 0.0) {
            space *= mxVdxUtils.conversionFactor();
        } else if (space == 0.0) {
            space = 100.0;
            isPercent = true;
        } else {
            space = Math.abs(space) * 100.0;
            isPercent = true;
        }
        ret = String.valueOf(space);
        ret = String.valueOf(ret) + (isPercent ? "%" : "px");
        return ret;
    }

    public String getSpcBefore(String index) {
        String ret = "0";
        if (this.shape.hasSpBefore(index)) {
            ret = this.shape.getSpBefore(index);
        } else if (this.masterShape != null && this.masterShape.hasSpBefore(index)) {
            ret = this.masterShape.getSpBefore(index);
        } else if (this.styleSheet != null && this.styleSheet.hasSpBefore(index)) {
            ret = this.styleSheet.getSpBefore(index);
        } else if (this.defaultStyle != null && this.defaultStyle.hasSpBefore(index)) {
            ret = this.defaultStyle.getSpBefore(index);
        }
        return ret;
    }

    public String getSpcAfter(String index) {
        String ret = "0";
        if (this.shape.hasSpAfter(index)) {
            ret = this.shape.getSpAfter(index);
        } else if (this.masterShape != null && this.masterShape.hasSpAfter(index)) {
            ret = this.masterShape.getSpAfter(index);
        } else if (this.styleSheet != null && this.styleSheet.hasSpAfter(index)) {
            ret = this.styleSheet.getSpAfter(index);
        } else if (this.defaultStyle != null && this.defaultStyle.hasSpAfter(index)) {
            ret = this.defaultStyle.getSpAfter(index);
        }
        return ret;
    }

    public String getIndLeft(String index) {
        String ret = "0";
        if (this.shape.hasIndentLeft(index)) {
            ret = this.shape.getIndentLeft(index);
        } else if (this.masterShape != null && this.masterShape.hasIndentLeft(index)) {
            ret = this.masterShape.getIndentLeft(index);
        } else if (this.styleSheet != null && this.styleSheet.hasIndentLeft(index)) {
            ret = this.styleSheet.getIndentLeft(index);
        } else if (this.defaultStyle != null && this.defaultStyle.hasIndentLeft(index)) {
            ret = this.defaultStyle.getIndentLeft(index);
        }
        return ret;
    }

    public String getIndRight(String index) {
        String ret = "0";
        if (this.shape.hasIndentRight(index)) {
            ret = this.shape.getIndentRight(index);
        } else if (this.masterShape != null && this.masterShape.hasIndentRight(index)) {
            ret = this.masterShape.getIndentRight(index);
        } else if (this.styleSheet != null && this.styleSheet.hasIndentRight(index)) {
            ret = this.styleSheet.getIndentRight(index);
        } else if (this.defaultStyle != null && this.defaultStyle.hasIndentRight(index)) {
            ret = this.defaultStyle.getIndentRight(index);
        }
        return ret;
    }

    public String getIndFirst(String index) {
        String ret = "0";
        if (this.shape.hasIndentFirst(index)) {
            ret = this.shape.getIndentFirst(index);
        } else if (this.masterShape != null && this.masterShape.hasIndentFirst(index)) {
            ret = this.masterShape.getIndentFirst(index);
        } else if (this.styleSheet != null && this.styleSheet.hasIndentFirst(index)) {
            ret = this.styleSheet.getIndentFirst(index);
        } else if (this.defaultStyle != null && this.defaultStyle.hasIndentFirst(index)) {
            ret = this.defaultStyle.getIndentFirst(index);
        }
        return ret;
    }

    public String getHorzAlign(String index) {
        String ret = "center";
        int align = 0;
        if (this.shape.hasHorizontalAlign(index)) {
            align = this.shape.getHorizontalAlign(index);
        } else if (this.masterShape != null && this.masterShape.hasHorizontalAlign(index)) {
            align = this.masterShape.getHorizontalAlign(index);
        } else if (this.styleSheet != null && this.styleSheet.hasHorizontalAlign(index)) {
            align = this.styleSheet.getHorizontalAlign(index);
        } else if (this.defaultStyle != null && this.defaultStyle.hasHorizontalAlign(index)) {
            align = this.defaultStyle.getHorizontalAlign(index);
        }
        switch (align) {
            case 0: {
                ret = "left";
                break;
            }
            case 1: {
                ret = "center";
                break;
            }
            case 2: {
                ret = "right";
                break;
            }
            case 3: {
                ret = "justify";
            }
        }
        return ret;
    }

    public String insertAttributes(String text, HashMap<String, Object> attr) {
        int i = text.indexOf(">");
        String tail = text.substring(i);
        String head = text.substring(0, i);
        String style = " style=\"" + mxVdxUtils.getStyleString(attr, ":") + "\"";
        return String.valueOf(head) + style + tail;
    }

    public String getTextCharFormated(String text) {
        String ret = "";
        String color = "color:" + this.getTextColor(this.cp) + ";";
        String size = "font-size:" + this.getTextSize(this.cp) + "px;";
        String font = "font-family:" + this.getTextFont(this.cp) + ";";
        String direction = "direction:" + this.getCharDirection(this.cp) + ";";
        String space = "letter-spacing:" + this.getCharSpace(this.cp) + "px;";
        int pos = this.getPos(this.cp);
        boolean bold = this.isBold(this.cp);
        boolean italic = this.isItalic(this.cp);
        boolean underline = this.isUnderline(this.cp);
        boolean strike = this.isStrikeThru(this.cp);
        boolean smallCap = this.isSmallCaps(this.cp);
        int tCase = this.getCase(this.cp);
        if (tCase == 1) {
            text = text.toUpperCase();
        } else if (tCase == 2) {
            text = mxVdxUtils.toInitialCapital(text);
        }
        if (smallCap) {
            text = mxVdxUtils.toSmallCaps(text, this.getTextSize(this.cp));
        }
        if (pos == 1) {
            text = mxVdxUtils.surroundedByTags(text, "sup");
        } else if (pos == 2) {
            text = mxVdxUtils.surroundedByTags(text, "sub");
        }
        if (bold) {
            text = mxVdxUtils.surroundedByTags(text, "b");
        }
        if (italic) {
            text = mxVdxUtils.surroundedByTags(text, "i");
        }
        if (underline) {
            text = mxVdxUtils.surroundedByTags(text, "u");
        }
        if (strike) {
            text = mxVdxUtils.surroundedByTags(text, "s");
        }
        ret = String.valueOf(ret) + "<font style=\"" + size + font + color + direction + space + "\">" + text + "</font>";
        return ret;
    }

    public String getCharSpace(String index) {
        String space = "0";
        if (this.shape.hasLetterSpace(index)) {
            space = this.shape.getLetterSpace(index);
        } else if (this.masterShape != null && this.masterShape.hasLetterSpace(index)) {
            space = this.masterShape.getLetterSpace(index);
        } else if (this.styleSheet != null && this.styleSheet.hasLetterSpace(index)) {
            space = this.styleSheet.getLetterSpace(index);
        } else if (this.defaultStyle != null && this.defaultStyle.hasLetterSpace(index)) {
            space = this.defaultStyle.getLetterSpace(index);
        }
        return space;
    }

    public String getCharDirection(String index) {
        String direction = "ltr";
        if (this.shape.hasRTLText(index)) {
            direction = this.shape.getRTLText(index);
        } else if (this.masterShape != null && this.masterShape.hasRTLText(index)) {
            direction = this.masterShape.getRTLText(index);
        } else if (this.styleSheet != null && this.styleSheet.hasRTLText(index)) {
            direction = this.styleSheet.getRTLText(index);
        } else if (this.defaultStyle != null && this.defaultStyle.hasRTLText(index)) {
            direction = this.defaultStyle.getRTLText(index);
        }
        if (direction.equals("0")) {
            direction = "ltr";
        } else if (direction.equals("1")) {
            direction = "rtl";
        }
        return direction;
    }

    public int getCase(String index) {
        int tCase = 0;
        if (this.shape.hasTextStyle(index)) {
            tCase = this.shape.getTextCase(index);
        } else if (this.masterShape != null && this.masterShape.hasTextCase(index)) {
            tCase = this.masterShape.getTextCase(index);
        } else if (this.styleSheet != null && this.styleSheet.hasTextCase(index)) {
            tCase = this.styleSheet.getTextCase(index);
        } else if (this.defaultStyle != null && this.defaultStyle.hasTextCase(index)) {
            tCase = this.defaultStyle.getTextCase(index);
        }
        return tCase;
    }

    public int getPos(String index) {
        int pos = 0;
        if (this.shape.hasTextPos(index)) {
            pos = this.shape.getTextPos(index);
        } else if (this.masterShape != null && this.masterShape.hasTextPos(index)) {
            pos = this.masterShape.getTextPos(index);
        } else if (this.styleSheet != null && this.styleSheet.hasTextPos(index)) {
            pos = this.styleSheet.getTextPos(index);
        } else if (this.defaultStyle != null && this.defaultStyle.hasTextPos(index)) {
            pos = this.defaultStyle.getTextPos(index);
        }
        return pos;
    }

    public boolean isBold(String index) {
        boolean isBold = false;
        String style = "";
        if (this.shape.hasTextStyle(index)) {
            style = this.shape.getTextStyle(index);
        } else if (this.masterShape != null && this.masterShape.hasTextStyle(index)) {
            style = this.masterShape.getTextStyle(index);
        } else if (this.styleSheet != null && this.styleSheet.hasTextStyle(index)) {
            style = this.styleSheet.getTextStyle(index);
        } else if (this.defaultStyle != null && this.defaultStyle.hasTextStyle(index)) {
            style = this.defaultStyle.getTextStyle(index);
        }
        if (!style.equals("")) {
            int value = Integer.parseInt(style);
            isBold = (value & 1) == 1;
        }
        return isBold;
    }

    public boolean isItalic(String index) {
        boolean isItalic = false;
        String style = "";
        if (this.shape.hasTextStyle(index)) {
            style = this.shape.getTextStyle(index);
        } else if (this.masterShape != null && this.masterShape.hasTextStyle(index)) {
            style = this.masterShape.getTextStyle(index);
        } else if (this.styleSheet != null && this.styleSheet.hasTextStyle(index)) {
            style = this.styleSheet.getTextStyle(index);
        } else if (this.defaultStyle != null && this.defaultStyle.hasTextStyle(index)) {
            style = this.defaultStyle.getTextStyle(index);
        }
        if (!style.equals("")) {
            int value = Integer.parseInt(style);
            isItalic = (value & 2) == 2;
        }
        return isItalic;
    }

    public boolean isUnderline(String index) {
        boolean isUnderline = false;
        String style = "";
        if (this.shape.hasTextStyle(index)) {
            style = this.shape.getTextStyle(index);
        } else if (this.masterShape != null && this.masterShape.hasTextStyle(index)) {
            style = this.masterShape.getTextStyle(index);
        } else if (this.styleSheet != null && this.styleSheet.hasTextStyle(index)) {
            style = this.styleSheet.getTextStyle(index);
        } else if (this.defaultStyle != null && this.defaultStyle.hasTextStyle(index)) {
            style = this.defaultStyle.getTextStyle(index);
        }
        if (!style.equals("")) {
            int value = Integer.parseInt(style);
            isUnderline = (value & 4) == 4;
        }
        return isUnderline;
    }

    public boolean isSmallCaps(String index) {
        boolean isSmallCaps = false;
        String style = "";
        if (this.shape.hasTextStyle(index)) {
            style = this.shape.getTextStyle(index);
        } else if (this.masterShape != null && this.masterShape.hasTextStyle(index)) {
            style = this.masterShape.getTextStyle(index);
        } else if (this.styleSheet != null && this.styleSheet.hasTextStyle(index)) {
            style = this.styleSheet.getTextStyle(index);
        } else if (this.defaultStyle != null && this.defaultStyle.hasTextStyle(index)) {
            style = this.defaultStyle.getTextStyle(index);
        }
        if (!style.equals("")) {
            int value = Integer.parseInt(style);
            isSmallCaps = (value & 8) == 8;
        }
        return isSmallCaps;
    }

    public boolean isStrikeThru(String index) {
        boolean isStrikeThru = false;
        if (this.shape.hasTextStrike(index)) {
            isStrikeThru = this.shape.getTextStrike(index);
        } else if (this.masterShape != null && this.masterShape.hasTextStrike(index)) {
            isStrikeThru = this.masterShape.getTextStrike(index);
        } else if (this.styleSheet != null && this.styleSheet.hasTextStrike(index)) {
            isStrikeThru = this.styleSheet.getTextStrike(index);
        } else if (this.defaultStyle != null && this.defaultStyle.hasTextStrike(index)) {
            isStrikeThru = this.defaultStyle.getTextStrike(index);
        }
        return isStrikeThru;
    }

    public String getTextFont(String index) {
        String font = "";
        if (this.shape.hasTextFont(index)) {
            font = this.shape.getTextFont(index);
        } else if (this.masterShape != null && this.masterShape.hasTextFont(index)) {
            font = this.masterShape.getTextFont(index);
        } else if (this.styleSheet != null && this.styleSheet.hasTextFont(index)) {
            font = this.styleSheet.getTextFont(index);
        } else if (this.defaultStyle != null && this.defaultStyle.hasTextFont(index)) {
            font = this.defaultStyle.getTextFont(index);
        }
        return font;
    }

    private String getTextSize(String index) {
        String size = "12";
        if (this.shape.hasTextSize(index)) {
            size = this.shape.getTextSize(index);
        } else if (this.masterShape != null && this.masterShape.hasTextSize(index)) {
            size = this.masterShape.getTextSize(index);
        } else if (this.styleSheet != null && this.styleSheet.hasTextSize(index)) {
            size = this.styleSheet.getTextSize(index);
        } else if (this.defaultStyle != null && this.defaultStyle.hasTextSize(index)) {
            size = this.defaultStyle.getTextSize(index);
        }
        double s = Double.valueOf(size) * 0.71;
        return String.valueOf(s);
    }

    private String getTextColor(String index) {
        String color = "#000000";
        if (this.shape.hasTextColor(index)) {
            color = this.shape.getTextColor(index);
        } else if (this.masterShape != null && this.masterShape.hasTextColor(index)) {
            color = this.masterShape.getTextColor(index);
        } else if (this.styleSheet != null && this.styleSheet.hasTextColor(index)) {
            color = this.styleSheet.getTextColor(index);
        } else if (this.defaultStyle != null && this.defaultStyle.hasTextColor(index)) {
            color = this.defaultStyle.getTextColor(index);
        }
        return color;
    }
}

