/*
 * Decompiled with CFR 0.152.
 */
package com.mxgraph.io.vdx;

import com.mxgraph.io.vdx.mxStyleSheet;
import com.mxgraph.io.vdx.mxStyleSheetManager;
import com.mxgraph.io.vdx.mxVdxConstants;
import java.util.HashMap;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class mxPropertiesManager {
    private HashMap<String, String> colorElementMap = new HashMap();
    private HashMap<String, String> fontElementMap = new HashMap();
    private mxStyleSheet textStyle;
    private mxStyleSheet lineStyle;
    private mxStyleSheet fillStyle;
    private static mxPropertiesManager propertiesManager = null;

    private mxPropertiesManager() {
    }

    public static mxPropertiesManager getInstance() {
        if (propertiesManager == null) {
            propertiesManager = new mxPropertiesManager();
        }
        return propertiesManager;
    }

    public void initialise(Document doc) {
        NodeList vdxDocumentStyle;
        NodeList vdxFonts;
        NodeList vdxColors = doc.getElementsByTagName(mxVdxConstants.COLORS);
        if (vdxColors.getLength() > 0) {
            Element colors = (Element)vdxColors.item(0);
            NodeList colorList = colors.getElementsByTagName(mxVdxConstants.COLOR_ENTRY);
            int colorLength = colorList.getLength();
            int i = 0;
            while (i < colorLength) {
                Element color = (Element)colorList.item(i);
                String colorId = color.getAttribute(mxVdxConstants.INDEX);
                String colorValue = color.getAttribute(mxVdxConstants.RGB);
                this.colorElementMap.put(colorId, colorValue);
                ++i;
            }
        }
        if ((vdxFonts = doc.getElementsByTagName(mxVdxConstants.FACE_NAMES)).getLength() > 0) {
            Element fonts = (Element)vdxFonts.item(0);
            NodeList fontList = fonts.getElementsByTagName(mxVdxConstants.FACE_NAME);
            int fontLength = fontList.getLength();
            int i = 0;
            while (i < fontLength) {
                Element font = (Element)fontList.item(i);
                String fontId = font.getAttribute(mxVdxConstants.ID);
                String fontValue = font.getAttribute(mxVdxConstants.FONT_NAME);
                this.fontElementMap.put(fontId, fontValue);
                ++i;
            }
        }
        if ((vdxDocumentStyle = doc.getElementsByTagName(mxVdxConstants.DOCUMENT_SHEET)).getLength() > 0) {
            Element defaultStyle = (Element)vdxDocumentStyle.item(0);
            String lineId = defaultStyle.getAttribute(mxVdxConstants.LINE_STYLE);
            String fillId = defaultStyle.getAttribute(mxVdxConstants.FILL_STYLE);
            String textId = defaultStyle.getAttribute(mxVdxConstants.TEXT_STYLE);
            mxStyleSheetManager ssm = mxStyleSheetManager.getInstance();
            this.lineStyle = ssm.getSheet(lineId);
            this.fillStyle = ssm.getSheet(fillId);
            this.textStyle = ssm.getSheet(textId);
        }
    }

    public String getColor(String ix) {
        String color = this.colorElementMap.get(ix);
        if (color == null) {
            return "";
        }
        return color;
    }

    public String getFont(String id) {
        String font = this.fontElementMap.get(id);
        if (font == null) {
            return "";
        }
        return font;
    }

    public mxStyleSheet getFillStyle() {
        return this.fillStyle;
    }

    public mxStyleSheet getLineStyle() {
        return this.lineStyle;
    }

    public mxStyleSheet getTextStyle() {
        return this.textStyle;
    }
}

