/*
 * Decompiled with CFR 0.152.
 */
package com.mxgraph.io;

import com.mxgraph.io.vdx.PageShapeIDKey;
import com.mxgraph.io.vdx.mxMastersManager;
import com.mxgraph.io.vdx.mxPropertiesManager;
import com.mxgraph.io.vdx.mxStyleSheetManager;
import com.mxgraph.io.vdx.mxVdxConstants;
import com.mxgraph.io.vdx.mxVdxShape;
import com.mxgraph.io.vdx.mxVdxUtils;
import com.mxgraph.model.mxCell;
import com.mxgraph.model.mxGeometry;
import com.mxgraph.util.mxPoint;
import com.mxgraph.view.mxCellState;
import com.mxgraph.view.mxConnectionConstraint;
import com.mxgraph.view.mxGraph;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class mxVdxCodec {
    private static HashMap<PageShapeIDKey, mxCell> vertexMap = new HashMap();
    private static HashMap<PageShapeIDKey, mxVdxShape> edgeShapeMap = new HashMap();
    private static HashMap<PageShapeIDKey, mxVdxShape> vertexShapeMap = new HashMap();
    private static HashMap<PageShapeIDKey, Object> parentsMap = new HashMap();
    private static HashMap<String, Element> backgroundsMap = new HashMap();
    private static HashMap<PageShapeIDKey, Object> cellsMap = new HashMap();
    private static ArrayList<PageShapeIDKey> shapeIDList = new ArrayList();
    private static double pageHeight = 0.0;
    private static double actualPageHeight = 0.0;
    private static int pageNumber = 0;
    private static boolean htmlLabelsEnable = true;

    public static boolean isHtmlLabelsEnable() {
        return htmlLabelsEnable;
    }

    public static void setHtmlLabelsEnable(boolean htmlLabelsEnable) {
        mxVdxCodec.htmlLabelsEnable = htmlLabelsEnable;
    }

    private static void cleanMaps() {
        vertexMap.clear();
        edgeShapeMap.clear();
        vertexShapeMap.clear();
        parentsMap.clear();
        backgroundsMap.clear();
        pageHeight = 0.0;
        actualPageHeight = 0.0;
    }

    private static mxPoint getPageDimentions(Element page) {
        Element pHeight = (Element)page.getElementsByTagName(mxVdxConstants.PAGE_HEIGHT).item(0);
        double pageH = Double.valueOf(pHeight.getTextContent()) * mxVdxUtils.conversionFactor();
        Element pageWidth = (Element)page.getElementsByTagName(mxVdxConstants.PAGE_WIDTH).item(0);
        double pageW = Double.valueOf(pageWidth.getTextContent()) * mxVdxUtils.conversionFactor();
        return new mxPoint(pageW, pageH);
    }

    private static mxPoint calculateAbsolutePoint(mxCell cellParent, mxGraph graph, mxPoint point) {
        mxCellState state;
        if (cellParent != null && (state = graph.getView().getState(cellParent)) != null) {
            point.setX(point.getX() + state.getX());
            point.setY(point.getY() + state.getY());
        }
        return point;
    }

    private static mxCell addShape(mxGraph graph, Object parent, Element shp, double parentHeight) {
        mxVdxShape shape = new mxVdxShape(shp);
        if (shp.getAttribute(mxVdxConstants.TYPE).equals(mxVdxConstants.TYPE_SHAPE) || shp.getAttribute(mxVdxConstants.TYPE).equals(mxVdxConstants.TYPE_GROUP)) {
            String id = shape.getId();
            shapeIDList.add(new PageShapeIDKey(pageNumber, id));
            if (shape.isVertexShape()) {
                mxCell v1 = null;
                v1 = shape.isComplexShape() ? shape.addComplexShapeToGraph(graph, parent, parentHeight) : shape.addSimpleShapeToGraph(graph, parent, parentHeight);
                vertexMap.put(new PageShapeIDKey(pageNumber, id), v1);
                vertexShapeMap.put(new PageShapeIDKey(pageNumber, id), shape);
                cellsMap.put(new PageShapeIDKey(pageNumber, id), v1);
                return v1;
            }
            edgeShapeMap.put(new PageShapeIDKey(pageNumber, id), shape);
        }
        return null;
    }

    private static Object addConectedEdge(mxGraph graph, Element connect, Element sigConnect) {
        mxCell edge = null;
        String shapeConnect = connect.getAttribute(mxVdxConstants.FROM_SHEET);
        mxVdxShape edgeShape = edgeShapeMap.get(new PageShapeIDKey(pageNumber, shapeConnect));
        edgeShapeMap.remove(new PageShapeIDKey(pageNumber, shapeConnect));
        if (edgeShape != null) {
            mxGeometry parentGeometry;
            Object parent = parentsMap.get(new PageShapeIDKey(pageNumber, edgeShape.getId()));
            double parentHeight = pageHeight;
            mxCell parentCell = (mxCell)parent;
            if (parentCell != null && (parentGeometry = parentCell.getGeometry()) != null) {
                parentHeight = parentGeometry.getHeight();
                parentHeight += pageHeight - actualPageHeight;
            }
            mxPoint beginXY = edgeShape.getBeginXY(parentHeight);
            beginXY = mxVdxCodec.calculateAbsolutePoint((mxCell)parent, graph, beginXY);
            mxPoint endXY = edgeShape.getEndXY(parentHeight);
            endXY = mxVdxCodec.calculateAbsolutePoint((mxCell)parent, graph, endXY);
            mxCell source = null;
            mxCell target = null;
            mxPoint fromConstraint = null;
            mxPoint toConstraint = null;
            String textLabel = edgeShape.getTextLabel();
            String from = connect.getAttribute(mxVdxConstants.TO_SHEET);
            mxVdxShape fromShape = vertexShapeMap.get(new PageShapeIDKey(pageNumber, from));
            if (connect.getAttribute(mxVdxConstants.FROM_CELL).equals(mxVdxConstants.END_X) || fromShape == null) {
                source = (mxCell)graph.insertVertex(parent, null, null, beginXY.getX(), beginXY.getY(), 0.0, 0.0);
                fromConstraint = new mxPoint(0.0, 0.0);
                sigConnect = connect;
            } else {
                source = vertexMap.get(new PageShapeIDKey(pageNumber, from));
                mxPoint dimentionFrom = fromShape.getDimentions();
                double height = pageHeight;
                if (source.getParent() != null && source.getParent().getGeometry() != null) {
                    height = source.getParent().getGeometry().getHeight();
                    height += pageHeight - actualPageHeight;
                }
                mxPoint originFrom = fromShape.getOriginPoint(height);
                mxPoint absOriginFrom = mxVdxCodec.calculateAbsolutePoint((mxCell)source.getParent(), graph, originFrom);
                fromConstraint = new mxPoint((beginXY.getX() - absOriginFrom.getX()) / dimentionFrom.getX(), (beginXY.getY() - absOriginFrom.getY()) / dimentionFrom.getY());
            }
            if (sigConnect != null) {
                String to = sigConnect.getAttribute(mxVdxConstants.TO_SHEET);
                mxVdxShape toShape = vertexShapeMap.get(new PageShapeIDKey(pageNumber, to));
                if (toShape != null) {
                    target = vertexMap.get(new PageShapeIDKey(pageNumber, to));
                    mxPoint dimentionTo = toShape.getDimentions();
                    double height = pageHeight;
                    if (target.getParent() != null && target.getParent().getGeometry() != null) {
                        height = target.getParent().getGeometry().getHeight();
                        height += pageHeight - actualPageHeight;
                    }
                    mxPoint originTo = toShape.getOriginPoint(height);
                    mxPoint absOriginTo = mxVdxCodec.calculateAbsolutePoint((mxCell)target.getParent(), graph, originTo);
                    toConstraint = new mxPoint((endXY.getX() - absOriginTo.getX()) / dimentionTo.getX(), (endXY.getY() - absOriginTo.getY()) / dimentionTo.getY());
                } else {
                    target = (mxCell)graph.insertVertex(parent, null, null, endXY.getX(), endXY.getY(), 0.0, 0.0);
                    toConstraint = new mxPoint(0.0, 0.0);
                }
            } else {
                target = (mxCell)graph.insertVertex(parent, null, null, endXY.getX(), endXY.getY(), 0.0, 0.0);
                toConstraint = new mxPoint(0.0, 0.0);
            }
            fromConstraint = mxVdxUtils.adjustConstraint(fromConstraint);
            toConstraint = mxVdxUtils.adjustConstraint(toConstraint);
            String style = edgeShape.getStyleFromEdgeShape(parentHeight);
            edge = (mxCell)graph.insertEdge(parent, null, textLabel, source, target, style);
            graph.setConnectionConstraint(edge, source, true, new mxConnectionConstraint(fromConstraint, false));
            graph.setConnectionConstraint(edge, target, false, new mxConnectionConstraint(toConstraint, false));
            mxGeometry edgeGeometry = edge.getGeometry();
            List<mxPoint> pointList = edgeShape.getRoutingPoints(parentHeight);
            edgeGeometry.setPoints(pointList);
            cellsMap.put(new PageShapeIDKey(pageNumber, shapeConnect), edge);
        }
        return edge;
    }

    private static Object addNotConnectedEdge(mxGraph graph, Object parent, mxVdxShape edgeShape) {
        mxGeometry parentGeometry;
        mxCell edge = null;
        String textLabel = edgeShape.getTextLabel();
        double height = pageHeight;
        mxCell parentCell = (mxCell)parent;
        if (parentCell != null && (parentGeometry = parentCell.getGeometry()) != null) {
            height = parentGeometry.getHeight();
        }
        mxPoint beginXY = edgeShape.getBeginXY(height);
        mxPoint endXY = edgeShape.getEndXY(height);
        mxCell target = (mxCell)graph.insertVertex(parent, null, null, endXY.getX(), endXY.getY(), 0.0, 0.0);
        mxCell source = (mxCell)graph.insertVertex(parent, null, null, beginXY.getX(), beginXY.getY(), 0.0, 0.0);
        String style = edgeShape.getStyleFromEdgeShape(height);
        mxPoint fromConstraint = new mxPoint(0.0, 0.0);
        mxPoint toConstraint = new mxPoint(0.0, 0.0);
        edge = (mxCell)graph.insertEdge(source.getParent(), null, textLabel, source, target, style);
        graph.setConnectionConstraint(edge, source, true, new mxConnectionConstraint(fromConstraint, false));
        graph.setConnectionConstraint(edge, target, false, new mxConnectionConstraint(toConstraint, false));
        mxGeometry edgeGeometry = edge.getGeometry();
        List<mxPoint> pointList = edgeShape.getRoutingPoints(height);
        edgeGeometry.setPoints(pointList);
        cellsMap.put(new PageShapeIDKey(pageNumber, edgeShape.getId()), edge);
        return edge;
    }

    private static Element findSigConnect(List<Node> connectList, Element connect, int index) {
        int length = connectList.size();
        String shapeConn1 = connect.getAttribute(mxVdxConstants.FROM_SHEET);
        Element sigConnect = null;
        boolean end = false;
        int i = index + 1;
        while (i < length && !end) {
            sigConnect = (Element)connectList.get(i);
            String shapeConn2 = sigConnect.getAttribute(mxVdxConstants.FROM_SHEET);
            if (shapeConn1.equals(shapeConn2)) {
                end = true;
            } else {
                sigConnect = null;
            }
            ++i;
        }
        return sigConnect;
    }

    private static void decodeShape(Element shape, mxGraph graph, Object parent) {
        NodeList childs;
        mxVdxShape shp = new mxVdxShape(shape);
        if (!shp.isComplexShape() && mxVdxUtils.nodeListHasTag(childs = shape.getChildNodes(), mxVdxConstants.SHAPES)) {
            Element shapes = mxVdxUtils.nodeListTag(childs, mxVdxConstants.SHAPES);
            NodeList shapeList = shapes.getChildNodes();
            List<Element> shpList = mxVdxUtils.nodeListTags(shapeList, mxVdxConstants.SHAPE);
            int shapeLength = shpList.size();
            double parentHeight = shp.getDimentions().getY();
            int j = 0;
            while (j < shapeLength) {
                Element shapeInside = shpList.get(j);
                String Id = shapeInside.getAttribute(mxVdxConstants.ID);
                parentsMap.put(new PageShapeIDKey(pageNumber, Id), parent);
                mxCell vertex = mxVdxCodec.addShape(graph, parent, shapeInside, parentHeight);
                if (vertex != null) {
                    mxVdxCodec.decodeShape(shapeInside, graph, vertex);
                }
                ++j;
            }
        }
    }

    private static void importPage(Element page, mxGraph graph, Object parent) {
        NodeList shapesList = page.getElementsByTagName(mxVdxConstants.SHAPES);
        ++pageNumber;
        if (shapesList.getLength() > 0) {
            Element shapes = (Element)shapesList.item(0);
            NodeList shapeList = shapes.getChildNodes();
            List<Element> shpList = mxVdxUtils.nodeListTags(shapeList, mxVdxConstants.SHAPE);
            int shapeLength = shpList.size();
            int j = 0;
            while (j < shapeLength) {
                Element shape = shpList.get(j);
                mxCell vertex = mxVdxCodec.addShape(graph, parent, shape, pageHeight);
                mxVdxCodec.decodeShape(shape, graph, vertex);
                ++j;
            }
            NodeList connectsList = page.getElementsByTagName(mxVdxConstants.CONNECTS);
            if (connectsList.getLength() > 0) {
                Element connects = (Element)connectsList.item(0);
                NodeList connectList = connects.getElementsByTagName(mxVdxConstants.CONNECT);
                List<Node> list = mxVdxUtils.copyNodeList(connectList);
                int j2 = 0;
                while (j2 < list.size()) {
                    Element connect = (Element)list.get(j2);
                    Element sigConnect = mxVdxCodec.findSigConnect(list, connect, j2);
                    list.remove(sigConnect);
                    mxVdxCodec.addConectedEdge(graph, connect, sigConnect);
                    ++j2;
                }
            }
            for (mxVdxShape edgeShape : edgeShapeMap.values()) {
                mxVdxCodec.addNotConnectedEdge(graph, parentsMap.get(new PageShapeIDKey(pageNumber, edgeShape.getId())), edgeShape);
            }
        }
    }

    public static void decode(Document document, mxGraph graph) {
        Element pages;
        NodeList pageList;
        Object parent = graph.getDefaultParent();
        graph.getModel().beginUpdate();
        graph.setHtmlLabels(true);
        Document doc = document;
        mxStyleSheetManager.getInstance().initialise(doc);
        mxMastersManager.getInstance().initialise(doc);
        mxPropertiesManager.getInstance().initialise(doc);
        NodeList vdxPages = doc.getElementsByTagName(mxVdxConstants.PAGES);
        if (vdxPages.getLength() > 0 && (pageList = (pages = (Element)vdxPages.item(0)).getElementsByTagName(mxVdxConstants.PAGE)).getLength() > 0) {
            String back;
            Element page;
            int p = 0;
            while (p < pageList.getLength()) {
                page = (Element)pageList.item(p);
                back = page.getAttribute(mxVdxConstants.BACKGROUND);
                if (back != null && back.equals(mxVdxConstants.TRUE)) {
                    String id = page.getAttribute(mxVdxConstants.ID);
                    backgroundsMap.put(id, page);
                }
                ++p;
            }
            p = 0;
            while (p < pageList.getLength()) {
                page = (Element)pageList.item(p);
                back = page.getAttribute(mxVdxConstants.BACKGROUND);
                if (back == null || !back.equals(mxVdxConstants.TRUE)) {
                    actualPageHeight = mxVdxCodec.getPageDimentions(page).getY();
                    pageHeight += actualPageHeight;
                    String backId = page.getAttribute(mxVdxConstants.BACK_PAGE);
                    if (backId != null && !backId.equals("")) {
                        Element background = backgroundsMap.get(backId);
                        mxVdxCodec.importPage(background, graph, parent);
                    }
                    mxVdxCodec.importPage(page, graph, parent);
                }
                ++p;
            }
        }
        Object[] order = mxVdxUtils.getOrderArray(shapeIDList, cellsMap);
        graph.orderCells(false, order);
        graph.getModel().endUpdate();
        mxVdxCodec.cleanMaps();
    }
}

