/*
 * Decompiled with CFR 0.152.
 */
package com.mxgraph.io;

import com.mxgraph.io.gml.mxGmlConstants;
import com.mxgraph.io.gml.mxGmlData;
import com.mxgraph.io.gml.mxGmlEdge;
import com.mxgraph.io.gml.mxGmlGraph;
import com.mxgraph.io.gml.mxGmlKey;
import com.mxgraph.io.gml.mxGmlKeyManager;
import com.mxgraph.io.gml.mxGmlNode;
import com.mxgraph.io.gml.mxGmlShapeEdge;
import com.mxgraph.io.gml.mxGmlShapeNode;
import com.mxgraph.io.gml.mxGmlUtils;
import com.mxgraph.model.mxCell;
import com.mxgraph.util.mxConstants;
import com.mxgraph.util.mxPoint;
import com.mxgraph.util.mxUtils;
import com.mxgraph.view.mxCellState;
import com.mxgraph.view.mxConnectionConstraint;
import com.mxgraph.view.mxGraph;
import com.mxgraph.view.mxGraphView;
import java.util.HashMap;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class mxGmlCodec {
    public static void decode(Document document, mxGraph graph) {
        Object parent = graph.getDefaultParent();
        graph.getModel().beginUpdate();
        mxGmlKeyManager.getInstance().initialise(document);
        NodeList graphs = document.getElementsByTagName(mxGmlConstants.GRAPH);
        if (graphs.getLength() > 0) {
            Element graphElement = (Element)graphs.item(0);
            mxGmlGraph gmlGraph = new mxGmlGraph(graphElement);
            gmlGraph.addGraph(graph, parent);
        }
        graph.getModel().endUpdate();
        mxGmlCodec.cleanMaps();
    }

    private static void cleanMaps() {
        mxGmlKeyManager.getInstance().getKeyMap().clear();
    }

    public static Document encodeXML(mxGmlGraph gmlGraph) {
        Document doc = mxUtils.createDocument();
        Element graphml = doc.createElement(mxGmlConstants.GRAPHML);
        graphml.setAttribute("xmlns", "http://graphml.graphdrawing.org/xmlns");
        graphml.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        graphml.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:jGraph", mxGmlConstants.JGRAPH_URL);
        graphml.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:schemaLocation", "http://graphml.graphdrawing.org/xmlns http://graphml.graphdrawing.org/xmlns/1.0/graphml.xsd");
        HashMap<String, mxGmlKey> keyMap = mxGmlKeyManager.getInstance().getKeyMap();
        for (mxGmlKey key : keyMap.values()) {
            Element keyElement = key.generateElement(doc);
            graphml.appendChild(keyElement);
        }
        Element graphE = gmlGraph.generateElement(doc);
        graphml.appendChild(graphE);
        doc.appendChild(graphml);
        mxGmlCodec.cleanMaps();
        return doc;
    }

    public static Document encode(mxGraph graph) {
        mxGmlGraph gmlGraph = new mxGmlGraph();
        Object parent = graph.getDefaultParent();
        mxGmlCodec.createKeyElements();
        gmlGraph = mxGmlCodec.decodeGraph(graph, parent, gmlGraph);
        gmlGraph.setEdgedefault(mxGmlConstants.EDGE_DIRECTED);
        Document document = mxGmlCodec.encodeXML(gmlGraph);
        return document;
    }

    private static void createKeyElements() {
        HashMap<String, mxGmlKey> keyMap = mxGmlKeyManager.getInstance().getKeyMap();
        mxGmlKey keyNode = new mxGmlKey(mxGmlConstants.KEY_NODE_ID, mxGmlKey.keyForValues.NODE, mxGmlConstants.KEY_NODE_NAME, mxGmlKey.keyTypeValues.STRING);
        keyMap.put(mxGmlConstants.KEY_NODE_ID, keyNode);
        mxGmlKey keyEdge = new mxGmlKey(mxGmlConstants.KEY_EDGE_ID, mxGmlKey.keyForValues.EDGE, mxGmlConstants.KEY_EDGE_NAME, mxGmlKey.keyTypeValues.STRING);
        keyMap.put(mxGmlConstants.KEY_EDGE_ID, keyEdge);
        mxGmlKeyManager.getInstance().setKeyMap(keyMap);
    }

    public static mxGmlGraph decodeGraph(mxGraph graph, Object parent, mxGmlGraph gmlGraph) {
        Object[] vertexes = graph.getChildVertices(parent);
        List<mxGmlEdge> gmlEdges = gmlGraph.getEdges();
        gmlEdges = mxGmlCodec.encodeEdges(gmlEdges, parent, graph);
        gmlGraph.setEdges(gmlEdges);
        Object[] objectArray = vertexes;
        int n = vertexes.length;
        int n2 = 0;
        while (n2 < n) {
            Object vertex = objectArray[n2];
            List<mxGmlNode> Gmlnodes = gmlGraph.getNodes();
            mxCell v = (mxCell)vertex;
            String id = v.getId();
            mxGmlNode gmlNode = new mxGmlNode(id, null);
            mxGmlCodec.addNodeData(gmlNode, v);
            Gmlnodes.add(gmlNode);
            gmlGraph.setNodes(Gmlnodes);
            mxGmlGraph gmlGraphx = new mxGmlGraph();
            gmlGraphx = mxGmlCodec.decodeGraph(graph, vertex, gmlGraphx);
            if (!gmlGraphx.isEmpty()) {
                List<mxGmlGraph> nodeGraphs = gmlNode.getNodeGraph();
                nodeGraphs.add(gmlGraphx);
                gmlNode.setNodeGraph(nodeGraphs);
            }
            ++n2;
        }
        return gmlGraph;
    }

    public static void addNodeData(mxGmlNode gmlNode, mxCell v) {
        mxGmlData data = new mxGmlData();
        mxGmlShapeNode dataShapeNode = new mxGmlShapeNode();
        data.setDataKey(mxGmlConstants.KEY_NODE_ID);
        dataShapeNode.setDataHeight(String.valueOf(v.getGeometry().getHeight()));
        dataShapeNode.setDataWidth(String.valueOf(v.getGeometry().getWidth()));
        dataShapeNode.setDataX(String.valueOf(v.getGeometry().getX()));
        dataShapeNode.setDataY(String.valueOf(v.getGeometry().getY()));
        dataShapeNode.setDataLabel(v.getValue() != null ? v.getValue().toString() : "");
        dataShapeNode.setDataStyle(v.getStyle() != null ? v.getStyle() : "");
        data.setDataShapeNode(dataShapeNode);
        gmlNode.setNodeData(data);
    }

    public static void addEdgeData(mxGmlEdge gmlEdge, mxCell v) {
        mxGmlData data = new mxGmlData();
        mxGmlShapeEdge dataShapeEdge = new mxGmlShapeEdge();
        data.setDataKey(mxGmlConstants.KEY_EDGE_ID);
        dataShapeEdge.setText(v.getValue() != null ? v.getValue().toString() : "");
        dataShapeEdge.setStyle(v.getStyle() != null ? v.getStyle() : "");
        data.setDataShapeEdge(dataShapeEdge);
        gmlEdge.setEdgeData(data);
    }

    private static String pointToPortString(mxPoint point) {
        String port = "";
        if (point != null) {
            double x = point.getX();
            double y = point.getY();
            port = x == 0.0 && y == 0.0 ? "NorthWest" : (x == 0.5 && y == 0.0 ? "North" : (x == 1.0 && y == 0.0 ? "NorthEast" : (x == 1.0 && y == 0.5 ? "East" : (x == 1.0 && y == 1.0 ? "SouthEast" : (x == 0.5 && y == 1.0 ? "South" : (x == 0.0 && y == 1.0 ? "SouthWest" : (x == 0.0 && y == 0.5 ? "West" : x + "," + y)))))));
        }
        return port;
    }

    private static List<mxGmlEdge> encodeEdges(List<mxGmlEdge> Gmledges, Object parent, mxGraph graph) {
        Object[] edges;
        Object[] objectArray = edges = graph.getChildEdges(parent);
        int n = edges.length;
        int n2 = 0;
        while (n2 < n) {
            HashMap<String, Object> styleMap;
            String endArrow;
            Object edge = objectArray[n2];
            mxCell e = (mxCell)edge;
            mxCell source = (mxCell)e.getSource();
            mxCell target = (mxCell)e.getTarget();
            String sourceName = "";
            String targetName = "";
            String sourcePort = "";
            String targetPort = "";
            sourceName = source != null ? source.getId() : "";
            targetName = target != null ? target.getId() : "";
            mxGraphView view = graph.getView();
            mxPoint sourceConstraint = null;
            mxPoint targetConstraint = null;
            if (view != null) {
                mxCellState targetState;
                mxConnectionConstraint tcc;
                mxCellState sourceState;
                mxCellState edgeState = view.getState(edge);
                mxConnectionConstraint scc = graph.getConnectionConstraint(edgeState, sourceState = view.getState(source), true);
                if (scc != null) {
                    sourceConstraint = scc.getPoint();
                }
                if ((tcc = graph.getConnectionConstraint(edgeState, targetState = view.getState(target), false)) != null) {
                    targetConstraint = tcc.getPoint();
                }
            }
            targetPort = mxGmlCodec.pointToPortString(targetConstraint);
            sourcePort = mxGmlCodec.pointToPortString(sourceConstraint);
            mxGmlEdge Gmledge = new mxGmlEdge(sourceName, targetName, sourcePort, targetPort);
            String style = e.getStyle();
            if (style == null) {
                style = "horizontal";
            }
            if ((endArrow = (String)(styleMap = mxGmlUtils.getStyleMap(style, "=")).get(mxConstants.STYLE_ENDARROW)) != null && !endArrow.equals(mxConstants.NONE) || endArrow == null) {
                Gmledge.setEdgeDirected("true");
            } else {
                Gmledge.setEdgeDirected("false");
            }
            mxGmlCodec.addEdgeData(Gmledge, e);
            Gmledges.add(Gmledge);
            ++n2;
        }
        return Gmledges;
    }
}

