/*
 * Decompiled with CFR 0.152.
 */
package com.mxgraph.io;

import com.mxgraph.io.gd.mxGdDocument;
import com.mxgraph.io.gd.mxGdEdge;
import com.mxgraph.io.gd.mxGdNode;
import com.mxgraph.model.mxCell;
import com.mxgraph.model.mxGeometry;
import com.mxgraph.util.mxConstants;
import com.mxgraph.util.mxPoint;
import com.mxgraph.view.mxGraph;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class mxGdCodec {
    private static HashMap<String, Object> cellsMap = new HashMap();

    private static mxPoint getOriginPoint(mxGdNode node) {
        mxPoint coord = node.getCoordinates();
        mxPoint dim = node.getDimentions();
        double x = coord.getX() - dim.getX() / 2.0;
        double y = coord.getY() - dim.getY() / 2.0;
        return new mxPoint(x, y);
    }

    private static mxCell addNode(mxGraph graph, Object parent, mxGdNode node) {
        mxPoint cordenates = mxGdCodec.getOriginPoint(node);
        mxPoint dimentions = node.getDimentions();
        String label = node.getName();
        String id = node.getName();
        mxCell v1 = (mxCell)graph.insertVertex(parent, id, label, cordenates.getX(), cordenates.getY(), dimentions.getX(), dimentions.getY());
        cellsMap.put(node.getName(), v1);
        return v1;
    }

    private static String getStyleString(Map<String, Object> styleMap, String asig) {
        String style = "";
        Iterator<Object> it = styleMap.values().iterator();
        for (String key : styleMap.keySet()) {
            Object value = it.next();
            style = String.valueOf(style) + key + asig + value + ";";
        }
        return style;
    }

    private static String getEdgeStyle() {
        Hashtable<String, Object> styleMap = new Hashtable<String, Object>();
        styleMap.put(mxConstants.STYLE_ROUNDED, false);
        return mxGdCodec.getStyleString(styleMap, "=");
    }

    private static mxCell addEdge(mxGraph graph, Object parent, mxGdEdge edge) {
        Object source = cellsMap.get(edge.getSourceName());
        Object target = cellsMap.get(edge.getTargetName());
        String style = mxGdCodec.getEdgeStyle();
        mxCell e = (mxCell)graph.insertEdge(parent, null, "", source, target, style);
        return e;
    }

    public static void decode(mxGdDocument document, mxGraph graph) {
        Object parent = graph.getDefaultParent();
        graph.getModel().beginUpdate();
        List<mxGdNode> nodes = document.getNodes();
        for (mxGdNode node : nodes) {
            mxGdCodec.addNode(graph, parent, node);
        }
        List<mxGdEdge> edges = document.getEdges();
        for (mxGdEdge edge : edges) {
            mxGdCodec.addEdge(graph, parent, edge);
        }
        graph.getModel().endUpdate();
    }

    private static mxGdDocument encodeNodesAndEdges(mxGdDocument document, Object parent, mxGraph graph, mxPoint parentCoord) {
        Object[] vertexes = graph.getChildVertices(parent);
        List<mxGdEdge> GDedges = document.getEdges();
        GDedges = mxGdCodec.encodeEdges(GDedges, parent, graph);
        document.setEdges(GDedges);
        Object[] objectArray = vertexes;
        int n = vertexes.length;
        int n2 = 0;
        while (n2 < n) {
            Object vertex = objectArray[n2];
            List<mxGdNode> GDnodes = document.getNodes();
            mxCell v = (mxCell)vertex;
            mxGeometry geom = v.getGeometry();
            String id = v.getId();
            mxPoint coord = new mxPoint(parentCoord.getX() + geom.getCenterX(), parentCoord.getY() + geom.getCenterY());
            mxPoint dim = new mxPoint(geom.getWidth(), geom.getHeight());
            mxPoint cornerCoord = new mxPoint(parentCoord.getX() + geom.getX(), parentCoord.getY() + geom.getY());
            mxGdNode GDnode = new mxGdNode(id, coord, dim);
            GDnodes.add(GDnode);
            document.setNodes(GDnodes);
            document = mxGdCodec.encodeNodesAndEdges(document, vertex, graph, cornerCoord);
            ++n2;
        }
        return document;
    }

    private static List<mxGdEdge> encodeEdges(List<mxGdEdge> GDedges, Object parent, mxGraph graph) {
        Object[] edges;
        Object[] objectArray = edges = graph.getChildEdges(parent);
        int n = edges.length;
        int n2 = 0;
        while (n2 < n) {
            Object edge = objectArray[n2];
            mxCell e = (mxCell)edge;
            mxCell source = (mxCell)e.getSource();
            mxCell target = (mxCell)e.getTarget();
            String sourceName = "";
            String targetName = "";
            sourceName = source.getId();
            targetName = target.getId();
            mxGdEdge GDedge = new mxGdEdge(sourceName, targetName);
            GDedges.add(GDedge);
            ++n2;
        }
        return GDedges;
    }

    public static mxGdDocument encode(mxGraph graph) {
        Object parent = graph.getDefaultParent();
        mxGdDocument document = new mxGdDocument();
        document = mxGdCodec.encodeNodesAndEdges(document, parent, graph, new mxPoint(0.0, 0.0));
        return document;
    }
}

