/*
 * Decompiled with CFR 0.152.
 */
package com.mxgraph.io.gml;

import com.mxgraph.io.gml.mxGmlConstants;
import com.mxgraph.io.gml.mxGmlData;
import com.mxgraph.io.gml.mxGmlGraph;
import com.mxgraph.io.gml.mxGmlPort;
import com.mxgraph.io.gml.mxGmlUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class mxGmlNode {
    private String nodeId;
    private mxGmlData nodeData;
    private List<mxGmlGraph> nodeGraphList = new ArrayList<mxGmlGraph>();
    private HashMap<String, mxGmlData> nodeDataMap = new HashMap();
    private HashMap<String, mxGmlPort> nodePortMap = new HashMap();

    public mxGmlNode(String nodeId, mxGmlData nodeData) {
        this.nodeId = nodeId;
        this.nodeData = nodeData;
    }

    public mxGmlNode(Element nodeElement) {
        this.nodeId = nodeElement.getAttribute(mxGmlConstants.ID);
        List<Element> dataList = mxGmlUtils.childsTags(nodeElement, mxGmlConstants.DATA);
        for (Element dataElem : dataList) {
            mxGmlData data = new mxGmlData(dataElem);
            String key = data.getDataKey();
            this.nodeDataMap.put(key, data);
        }
        List<Element> graphList = mxGmlUtils.childsTags(nodeElement, mxGmlConstants.GRAPH);
        for (Element graphElem : graphList) {
            mxGmlGraph graph = new mxGmlGraph(graphElem);
            this.nodeGraphList.add(graph);
        }
        List<Element> portList = mxGmlUtils.childsTags(nodeElement, mxGmlConstants.PORT);
        for (Element portElem : portList) {
            mxGmlPort port = new mxGmlPort(portElem);
            String name = port.getName();
            this.nodePortMap.put(name, port);
        }
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public void setNodeId(String nodeId) {
        this.nodeId = nodeId;
    }

    public HashMap<String, mxGmlData> getNodeDataMap() {
        return this.nodeDataMap;
    }

    public void setNodeDataMap(HashMap<String, mxGmlData> nodeDataMap) {
        this.nodeDataMap = nodeDataMap;
    }

    public List<mxGmlGraph> getNodeGraph() {
        return this.nodeGraphList;
    }

    public void setNodeGraph(List<mxGmlGraph> nodeGraph) {
        this.nodeGraphList = nodeGraph;
    }

    public HashMap<String, mxGmlPort> getNodePort() {
        return this.nodePortMap;
    }

    public void setNodePort(HashMap<String, mxGmlPort> nodePort) {
        this.nodePortMap = nodePort;
    }

    public Element generateElement(Document document) {
        Element node = document.createElement(mxGmlConstants.NODE);
        node.setAttribute(mxGmlConstants.ID, this.nodeId);
        Element dataElement = this.nodeData.generateNodeElement(document);
        node.appendChild(dataElement);
        for (mxGmlPort port : this.nodePortMap.values()) {
            Element portElement = port.generateElement(document);
            node.appendChild(portElement);
        }
        for (mxGmlGraph graph : this.nodeGraphList) {
            Element graphElement = graph.generateElement(document);
            node.appendChild(graphElement);
        }
        return node;
    }

    public mxGmlData getNodeData() {
        return this.nodeData;
    }

    public void setNodeData(mxGmlData nodeData) {
        this.nodeData = nodeData;
    }
}

