/*
 * Decompiled with CFR 0.152.
 */
package com.mxgraph.io.gml;

import com.mxgraph.io.gml.mxGmlConstants;
import com.mxgraph.io.gml.mxGmlData;
import com.mxgraph.io.gml.mxGmlEdge;
import com.mxgraph.io.gml.mxGmlKey;
import com.mxgraph.io.gml.mxGmlKeyManager;
import com.mxgraph.io.gml.mxGmlNode;
import com.mxgraph.io.gml.mxGmlShapeEdge;
import com.mxgraph.io.gml.mxGmlUtils;
import com.mxgraph.model.mxCell;
import com.mxgraph.util.mxPoint;
import com.mxgraph.view.mxConnectionConstraint;
import com.mxgraph.view.mxGraph;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class mxGmlGraph {
    private static HashMap<String, Object> cellsMap = new HashMap();
    private String id = "";
    private String edgedefault = "";
    private List<mxGmlNode> nodes = new ArrayList<mxGmlNode>();
    private List<mxGmlEdge> edges = new ArrayList<mxGmlEdge>();

    public mxGmlGraph(String id, String edgedefault) {
        this.id = id;
        this.edgedefault = edgedefault;
    }

    public mxGmlGraph() {
    }

    public mxGmlGraph(Element graphElement) {
        this.id = graphElement.getAttribute(mxGmlConstants.ID);
        this.edgedefault = graphElement.getAttribute(mxGmlConstants.EDGE_DEFAULT);
        List<Element> nodeElements = mxGmlUtils.childsTags(graphElement, mxGmlConstants.NODE);
        for (Element nodeElem : nodeElements) {
            mxGmlNode node = new mxGmlNode(nodeElem);
            this.nodes.add(node);
        }
        List<Element> edgeElements = mxGmlUtils.childsTags(graphElement, mxGmlConstants.EDGE);
        for (Element edgeElem : edgeElements) {
            mxGmlEdge edge = new mxGmlEdge(edgeElem);
            if (edge.getEdgeDirected().equals("")) {
                if (this.edgedefault.equals(mxGmlConstants.EDGE_DIRECTED)) {
                    edge.setEdgeDirected("true");
                } else if (this.edgedefault.equals(mxGmlConstants.EDGE_UNDIRECTED)) {
                    edge.setEdgeDirected("false");
                }
            }
            this.edges.add(edge);
        }
    }

    public void addGraph(mxGraph graph, Object parent) {
        List<mxGmlNode> nodeList = this.getNodes();
        for (mxGmlNode node : nodeList) {
            this.addNode(graph, parent, node);
        }
        List<mxGmlEdge> edgeList = this.getEdges();
        for (mxGmlEdge edge : edgeList) {
            mxGmlGraph.addEdge(graph, parent, edge);
        }
    }

    public static boolean hasData(mxGmlNode node) {
        boolean ret = false;
        ret = node.getNodeDataMap() != null;
        return ret;
    }

    public static mxGmlData dataNodeKey(mxGmlNode node) {
        String keyId = "";
        HashMap<String, mxGmlKey> keyMap = mxGmlKeyManager.getInstance().getKeyMap();
        for (mxGmlKey key : keyMap.values()) {
            if (!key.getKeyName().equals(mxGmlConstants.KEY_NODE_NAME)) continue;
            keyId = key.getKeyId();
        }
        mxGmlData data = null;
        HashMap<String, mxGmlData> nodeDataMap = node.getNodeDataMap();
        data = nodeDataMap.get(keyId);
        return data;
    }

    public static mxGmlData dataEdgeKey(mxGmlEdge edge) {
        String keyId = "";
        HashMap<String, mxGmlKey> keyMap = mxGmlKeyManager.getInstance().getKeyMap();
        for (mxGmlKey key : keyMap.values()) {
            if (!key.getKeyName().equals(mxGmlConstants.KEY_EDGE_NAME)) continue;
            keyId = key.getKeyId();
        }
        mxGmlData data = null;
        HashMap<String, mxGmlData> nodeDataMap = edge.getEdgeDataMap();
        data = nodeDataMap.get(keyId);
        return data;
    }

    private mxCell addNode(mxGraph graph, Object parent, mxGmlNode node) {
        mxCell v1;
        String id = node.getNodeId();
        mxGmlData data = mxGmlGraph.dataNodeKey(node);
        if (data != null && data.getDataShapeNode() != null) {
            Double x = Double.valueOf(data.getDataShapeNode().getDataX());
            Double y = Double.valueOf(data.getDataShapeNode().getDataY());
            Double h = Double.valueOf(data.getDataShapeNode().getDataHeight());
            Double w = Double.valueOf(data.getDataShapeNode().getDataWidth());
            String label = data.getDataShapeNode().getDataLabel();
            String style = data.getDataShapeNode().getDataStyle();
            v1 = (mxCell)graph.insertVertex(parent, id, label, x, y, w, h, style);
        } else {
            v1 = (mxCell)graph.insertVertex(parent, id, "", 0.0, 0.0, 100.0, 100.0);
        }
        cellsMap.put(id, v1);
        List<mxGmlGraph> graphs = node.getNodeGraph();
        for (mxGmlGraph gmlGraph : graphs) {
            gmlGraph.addGraph(graph, v1);
        }
        return v1;
    }

    private static mxPoint portValue(String source) {
        mxPoint fromConstraint = null;
        if (source != null && !source.equals("")) {
            if (source.equals("North")) {
                fromConstraint = new mxPoint(0.5, 0.0);
            } else if (source.equals("South")) {
                fromConstraint = new mxPoint(0.5, 1.0);
            } else if (source.equals("East")) {
                fromConstraint = new mxPoint(1.0, 0.5);
            } else if (source.equals("West")) {
                fromConstraint = new mxPoint(0.0, 0.5);
            } else if (source.equals("NorthWest")) {
                fromConstraint = new mxPoint(0.0, 0.0);
            } else if (source.equals("SouthWest")) {
                fromConstraint = new mxPoint(0.0, 1.0);
            } else if (source.equals("SouthEast")) {
                fromConstraint = new mxPoint(1.0, 1.0);
            } else if (source.equals("NorthEast")) {
                fromConstraint = new mxPoint(1.0, 0.0);
            } else {
                try {
                    String[] s = source.split(",");
                    Double x = Double.valueOf(s[0]);
                    Double y = Double.valueOf(s[1]);
                    fromConstraint = new mxPoint(x, y);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return fromConstraint;
    }

    private static mxCell addEdge(mxGraph graph, Object parent, mxGmlEdge edge) {
        mxPoint fromConstraint = null;
        mxPoint toConstraint = null;
        Object source = cellsMap.get(edge.getEdgeSource());
        Object target = cellsMap.get(edge.getEdgeTarget());
        String sourcePort = edge.getEdgeSourcePort();
        String targetPort = edge.getEdgeTargetPort();
        fromConstraint = mxGmlGraph.portValue(sourcePort);
        toConstraint = mxGmlGraph.portValue(targetPort);
        mxGmlData data = mxGmlGraph.dataEdgeKey(edge);
        String style = "";
        String label = "";
        if (data != null) {
            mxGmlShapeEdge shEdge = data.getDataShapeEdge();
            style = shEdge.getStyle();
            label = shEdge.getText();
        } else {
            style = edge.getEdgeStyle();
        }
        mxCell e = (mxCell)graph.insertEdge(parent, null, label, source, target, style);
        graph.setConnectionConstraint(e, source, true, new mxConnectionConstraint(fromConstraint, false));
        graph.setConnectionConstraint(e, target, false, new mxConnectionConstraint(toConstraint, false));
        return e;
    }

    public String getEdgedefault() {
        return this.edgedefault;
    }

    public void setEdgedefault(String edgedefault) {
        this.edgedefault = edgedefault;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public List<mxGmlNode> getNodes() {
        return this.nodes;
    }

    public void setNodes(List<mxGmlNode> node) {
        this.nodes = node;
    }

    public List<mxGmlEdge> getEdges() {
        return this.edges;
    }

    public void setEdges(List<mxGmlEdge> edge) {
        this.edges = edge;
    }

    public boolean isEmpty() {
        return this.nodes.size() == 0 && this.edges.size() == 0;
    }

    public Element generateElement(Document document) {
        Element graph = document.createElement(mxGmlConstants.GRAPH);
        if (!this.id.equals("")) {
            graph.setAttribute(mxGmlConstants.ID, this.id);
        }
        if (!this.edgedefault.equals("")) {
            graph.setAttribute(mxGmlConstants.EDGE_DEFAULT, this.edgedefault);
        }
        for (mxGmlNode node : this.nodes) {
            Element nodeElement = node.generateElement(document);
            graph.appendChild(nodeElement);
        }
        for (mxGmlEdge edge : this.edges) {
            Element edgeElement = edge.generateElement(document);
            graph.appendChild(edgeElement);
        }
        return graph;
    }
}

