/*
 * Decompiled with CFR 0.152.
 */
package com.mxgraph.io.gml;

import com.mxgraph.io.gml.mxGmlConstants;
import com.mxgraph.io.gml.mxGmlData;
import com.mxgraph.io.gml.mxGmlUtils;
import com.mxgraph.util.mxConstants;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class mxGmlEdge {
    private String edgeId;
    private String edgeSource;
    private String edgeSourcePort;
    private String edgeTarget;
    private String edgeTargetPort;
    private String edgeDirected;
    private mxGmlData edgeData;
    private HashMap<String, mxGmlData> edgeDataMap = new HashMap();

    public mxGmlEdge(String edgeSource, String edgeTarget, String edgeSourcePort, String edgeTargetPort) {
        this.edgeId = "";
        this.edgeSource = edgeSource;
        this.edgeSourcePort = edgeSourcePort;
        this.edgeTarget = edgeTarget;
        this.edgeTargetPort = edgeTargetPort;
        this.edgeDirected = "";
    }

    public mxGmlEdge(Element edgeElement) {
        this.edgeId = edgeElement.getAttribute(mxGmlConstants.ID);
        this.edgeSource = edgeElement.getAttribute(mxGmlConstants.EDGE_SOURCE);
        this.edgeSourcePort = edgeElement.getAttribute(mxGmlConstants.EDGE_SOURCE_PORT);
        this.edgeTarget = edgeElement.getAttribute(mxGmlConstants.EDGE_TARGET);
        this.edgeTargetPort = edgeElement.getAttribute(mxGmlConstants.EDGE_TARGET_PORT);
        this.edgeDirected = edgeElement.getAttribute(mxGmlConstants.EDGE_DIRECTED);
        List<Element> dataList = mxGmlUtils.childsTags(edgeElement, mxGmlConstants.DATA);
        for (Element dataElem : dataList) {
            mxGmlData data = new mxGmlData(dataElem);
            String key = data.getDataKey();
            this.edgeDataMap.put(key, data);
        }
    }

    public String getEdgeDirected() {
        return this.edgeDirected;
    }

    public void setEdgeDirected(String edgeDirected) {
        this.edgeDirected = edgeDirected;
    }

    public String getEdgeId() {
        return this.edgeId;
    }

    public void setEdgeId(String edgeId) {
        this.edgeId = edgeId;
    }

    public String getEdgeSource() {
        return this.edgeSource;
    }

    public void setEdgeSource(String edgeSource) {
        this.edgeSource = edgeSource;
    }

    public String getEdgeSourcePort() {
        return this.edgeSourcePort;
    }

    public void setEdgeSourcePort(String edgeSourcePort) {
        this.edgeSourcePort = edgeSourcePort;
    }

    public String getEdgeTarget() {
        return this.edgeTarget;
    }

    public void setEdgeTarget(String edgeTarget) {
        this.edgeTarget = edgeTarget;
    }

    public String getEdgeTargetPort() {
        return this.edgeTargetPort;
    }

    public void setEdgeTargetPort(String edgeTargetPort) {
        this.edgeTargetPort = edgeTargetPort;
    }

    public HashMap<String, mxGmlData> getEdgeDataMap() {
        return this.edgeDataMap;
    }

    public void setEdgeDataMap(HashMap<String, mxGmlData> nodeEdgeMap) {
        this.edgeDataMap = nodeEdgeMap;
    }

    public mxGmlData getEdgeData() {
        return this.edgeData;
    }

    public void setEdgeData(mxGmlData egdeData) {
        this.edgeData = egdeData;
    }

    public Element generateElement(Document document) {
        Element edge = document.createElement(mxGmlConstants.EDGE);
        if (!this.edgeId.equals("")) {
            edge.setAttribute(mxGmlConstants.ID, this.edgeId);
        }
        edge.setAttribute(mxGmlConstants.EDGE_SOURCE, this.edgeSource);
        edge.setAttribute(mxGmlConstants.EDGE_TARGET, this.edgeTarget);
        if (!this.edgeSourcePort.equals("")) {
            edge.setAttribute(mxGmlConstants.EDGE_SOURCE_PORT, this.edgeSourcePort);
        }
        if (!this.edgeTargetPort.equals("")) {
            edge.setAttribute(mxGmlConstants.EDGE_TARGET_PORT, this.edgeTargetPort);
        }
        if (!this.edgeDirected.equals("")) {
            edge.setAttribute(mxGmlConstants.EDGE_DIRECTED, this.edgeDirected);
        }
        Element dataElement = this.edgeData.generateEdgeElement(document);
        edge.appendChild(dataElement);
        return edge;
    }

    public String getEdgeStyle() {
        String style = "";
        Hashtable<String, Object> styleMap = new Hashtable<String, Object>();
        if (this.edgeDirected.equals("true")) {
            styleMap.put(mxConstants.STYLE_ENDARROW, "classic");
            style = mxGmlUtils.getStyleString(styleMap, "=");
        } else if (this.edgeDirected.equals("false")) {
            styleMap.put(mxConstants.STYLE_ENDARROW, mxConstants.NONE);
            style = mxGmlUtils.getStyleString(styleMap, "=");
        }
        return style;
    }
}

