/*
 * Decompiled with CFR 0.152.
 */
package com.mxgraph.io.gd;

import com.mxgraph.io.gd.mxGdEdge;
import com.mxgraph.io.gd.mxGdNode;
import com.mxgraph.util.mxPoint;
import java.io.BufferedReader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;

public class mxGdDocument {
    private List<mxGdNode> nodes = new ArrayList<mxGdNode>();
    private List<mxGdEdge> edges = new ArrayList<mxGdEdge>();

    public List<mxGdEdge> getEdges() {
        return this.edges;
    }

    public List<mxGdNode> getNodes() {
        return this.nodes;
    }

    public void setEdges(List<mxGdEdge> edges) {
        this.edges = edges;
    }

    public void setNodes(List<mxGdNode> nodes) {
        this.nodes = nodes;
    }

    public void parse(String gd) {
        gd = gd.trim();
        BufferedReader br = new BufferedReader(new StringReader(gd));
        mxGDParseState state = mxGDParseState.START;
        try {
            String line = br.readLine();
            while (line != null) {
                switch (state) {
                    case START: {
                        if (line.startsWith("# Nodes")) {
                            state = mxGDParseState.PARSING_NODES;
                            break;
                        }
                        throw new Exception("Error in parsing");
                    }
                    case PARSING_NODES: {
                        if (line.startsWith("# Edges")) {
                            state = mxGDParseState.PARSING_EDGES;
                            break;
                        }
                        if (line.equals("")) break;
                        String[] items = line.split(",");
                        if (items.length != 5) {
                            throw new Exception("Error in parsing");
                        }
                        double x = Double.valueOf(items[1]);
                        double y = Double.valueOf(items[2]);
                        double width = Double.valueOf(items[3]);
                        double height = Double.valueOf(items[4]);
                        mxGdNode node = new mxGdNode(items[0], new mxPoint(x, y), new mxPoint(width, height));
                        this.nodes.add(node);
                        break;
                    }
                    case PARSING_EDGES: {
                        if (line.equals("")) break;
                        String[] items = line.split(",");
                        if (items.length != 2) {
                            throw new Exception("Error in parsing");
                        }
                        String source = items[0];
                        String target = items[1];
                        mxGdEdge edge = new mxGdEdge(source, target);
                        this.edges.add(edge);
                    }
                }
                line = br.readLine();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getDocumentString() {
        StringBuilder buf = new StringBuilder("# Nodes\n");
        for (mxGdNode node : this.nodes) {
            buf.append(node.getNodeString());
            buf.append("\n");
        }
        buf.append("# Edges\n");
        for (mxGdEdge edge : this.edges) {
            buf.append(edge.getEdgeString());
            buf.append("\n");
        }
        return buf.toString();
    }

    public static enum mxGDParseState {
        START,
        PARSING_NODES,
        PARSING_EDGES;

    }
}

