/*
 * Decompiled with CFR 0.152.
 */
package com.mxgraph.canvas;

import com.mxgraph.canvas.mxBasicCanvas;
import com.mxgraph.util.mxConstants;
import com.mxgraph.util.mxPoint;
import com.mxgraph.util.mxRectangle;
import com.mxgraph.util.mxUtils;
import com.mxgraph.view.mxCellState;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class mxHtmlCanvas
extends mxBasicCanvas {
    protected Document document;

    public mxHtmlCanvas() {
        this(null);
    }

    public mxHtmlCanvas(Document document) {
        this.setDocument(document);
    }

    public void appendHtmlElement(Element node) {
        Node body;
        if (this.document != null && (body = this.document.getDocumentElement().getFirstChild().getNextSibling()) != null) {
            body.appendChild(node);
        }
    }

    public void setDocument(Document document) {
        this.document = document;
    }

    public Document getDocument() {
        return this.document;
    }

    @Override
    public Object drawCell(mxCellState state) {
        Map<String, Object> style = state.getStyle();
        if (state.getAbsolutePointCount() > 1) {
            List<mxPoint> pts = state.getAbsolutePoints();
            pts = mxUtils.translatePoints(pts, this.translate.x, this.translate.y);
            this.drawLine(pts, style);
        } else {
            int x = (int)state.getX() + this.translate.x;
            int y = (int)state.getY() + this.translate.y;
            int w = (int)state.getWidth();
            int h = (int)state.getHeight();
            if (!mxUtils.getString(style, mxConstants.STYLE_SHAPE, "").equals("swimlane")) {
                this.drawShape(x, y, w, h, style);
            } else {
                int start = (int)Math.round((double)mxUtils.getInt(style, mxConstants.STYLE_STARTSIZE, mxConstants.DEFAULT_STARTSIZE) * this.scale);
                Hashtable<String, Object> cloned = new Hashtable<String, Object>(style);
                cloned.remove(mxConstants.STYLE_FILLCOLOR);
                cloned.remove(mxConstants.STYLE_ROUNDED);
                if (mxUtils.isTrue(style, mxConstants.STYLE_HORIZONTAL, true)) {
                    this.drawShape(x, y, w, start, style);
                    this.drawShape(x, y + start, w, h - start, cloned);
                } else {
                    this.drawShape(x, y, start, h, style);
                    this.drawShape(x + start, y, w - start, h, cloned);
                }
            }
        }
        return null;
    }

    @Override
    public Object drawLabel(String label, mxCellState state, boolean html) {
        mxRectangle bounds = state.getLabelBounds();
        if (this.drawLabels && bounds != null) {
            int x = (int)bounds.getX() + this.translate.x;
            int y = (int)bounds.getY() + this.translate.y;
            int w = (int)bounds.getWidth();
            int h = (int)bounds.getHeight();
            Map<String, Object> style = state.getStyle();
            return this.drawText(label, x, y, w, h, style);
        }
        return null;
    }

    public Element drawShape(int x, int y, int w, int h, Map<String, Object> style) {
        String img;
        String fillColor = mxUtils.getString(style, mxConstants.STYLE_FILLCOLOR);
        String strokeColor = mxUtils.getString(style, mxConstants.STYLE_STROKECOLOR);
        float strokeWidth = (float)((double)mxUtils.getFloat(style, mxConstants.STYLE_STROKEWIDTH, 1.0f) * this.scale);
        String shape = mxUtils.getString(style, mxConstants.STYLE_SHAPE);
        Element elem = this.document.createElement("div");
        if (shape.equals("line")) {
            String direction = mxUtils.getString(style, mxConstants.STYLE_DIRECTION, "east");
            if (direction.equals("east") || direction.equals("west")) {
                y = Math.round(y + h / 2);
                h = 1;
            } else {
                x = Math.round(y + w / 2);
                w = 1;
            }
        }
        if (mxUtils.isTrue(style, mxConstants.STYLE_SHADOW, false) && fillColor != null) {
            Element shadow = (Element)elem.cloneNode(true);
            String s = "overflow:hidden;position:absolute;left:" + String.valueOf(x + mxConstants.SHADOW_OFFSETX) + "px;" + "top:" + String.valueOf(y + mxConstants.SHADOW_OFFSETY) + "px;" + "width:" + String.valueOf(w) + "px;" + "height:" + String.valueOf(h) + "px;background:" + mxConstants.W3C_SHADOWCOLOR + ";border-style:solid;border-color:" + mxConstants.W3C_SHADOWCOLOR + ";border-width:" + String.valueOf(Math.round(strokeWidth)) + ";";
            shadow.setAttribute("style", s);
            this.appendHtmlElement(shadow);
        }
        if (shape.equals("image") && (img = this.getImageForStyle(style)) != null) {
            elem = this.document.createElement("img");
            elem.setAttribute("border", "0");
            elem.setAttribute("src", img);
        }
        String s = "overflow:hidden;position:absolute;left:" + String.valueOf(x) + "px;" + "top:" + String.valueOf(y) + "px;" + "width:" + String.valueOf(w) + "px;" + "height:" + String.valueOf(h) + "px;background:" + fillColor + ";" + ";border-style:solid;border-color:" + strokeColor + ";border-width:" + String.valueOf(Math.round(strokeWidth)) + ";";
        elem.setAttribute("style", s);
        this.appendHtmlElement(elem);
        return elem;
    }

    public void drawLine(List<mxPoint> pts, Map<String, Object> style) {
        String strokeColor = mxUtils.getString(style, mxConstants.STYLE_STROKECOLOR);
        int strokeWidth = (int)((double)mxUtils.getInt(style, mxConstants.STYLE_STROKEWIDTH, 1) * this.scale);
        if (strokeColor != null && strokeWidth > 0) {
            mxPoint last = pts.get(0);
            int i = 1;
            while (i < pts.size()) {
                mxPoint pt = pts.get(i);
                this.drawSegment((int)last.getX(), (int)last.getY(), (int)pt.getX(), (int)pt.getY(), strokeColor, strokeWidth);
                last = pt;
                ++i;
            }
        }
    }

    protected void drawSegment(int x0, int y0, int x1, int y1, String strokeColor, int strokeWidth) {
        int tmpX = Math.min(x0, x1);
        int tmpY = Math.min(y0, y1);
        int width = Math.max(x0, x1) - tmpX;
        int height = Math.max(y0, y1) - tmpY;
        x0 = tmpX;
        y0 = tmpY;
        if (width == 0 || height == 0) {
            String s = "overflow:hidden;position:absolute;left:" + String.valueOf(x0) + "px;" + "top:" + String.valueOf(y0) + "px;" + "width:" + String.valueOf(width) + "px;" + "height:" + String.valueOf(height) + "px;" + "border-color:" + strokeColor + ";" + "border-style:solid;" + "border-width:1 1 0 0px;";
            Element elem = this.document.createElement("div");
            elem.setAttribute("style", s);
            this.appendHtmlElement(elem);
        } else {
            int x = x0 + (x1 - x0) / 2;
            this.drawSegment(x0, y0, x, y0, strokeColor, strokeWidth);
            this.drawSegment(x, y0, x, y1, strokeColor, strokeWidth);
            this.drawSegment(x, y1, x1, y1, strokeColor, strokeWidth);
        }
    }

    public Element drawText(String text, int x, int y, int w, int h, Map<String, Object> style) {
        Element table = mxUtils.createTable(this.document, text, x, y, w, h, this.scale, style);
        this.appendHtmlElement(table);
        return table;
    }
}

