/*
 * Decompiled with CFR 0.152.
 */
package com.mxgraph.canvas;

import com.mxgraph.canvas.mxICanvas;
import com.mxgraph.util.mxConstants;
import com.mxgraph.util.mxUtils;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.util.Hashtable;
import java.util.Map;

public abstract class mxBasicCanvas
implements mxICanvas {
    public static boolean PRESERVE_IMAGE_ASPECT = true;
    public static String DEFAULT_IMAGEBASEPATH = "";
    protected String imageBasePath = DEFAULT_IMAGEBASEPATH;
    protected Point translate = new Point();
    protected double scale = 1.0;
    protected boolean drawLabels = true;
    protected Hashtable<String, BufferedImage> imageCache = new Hashtable();

    @Override
    public void setTranslate(int dx, int dy) {
        this.translate = new Point(dx, dy);
    }

    @Override
    public Point getTranslate() {
        return this.translate;
    }

    @Override
    public void setScale(double scale) {
        this.scale = scale;
    }

    @Override
    public double getScale() {
        return this.scale;
    }

    public void setDrawLabels(boolean drawLabels) {
        this.drawLabels = drawLabels;
    }

    public String getImageBasePath() {
        return this.imageBasePath;
    }

    public void setImageBasePath(String imageBasePath) {
        this.imageBasePath = imageBasePath;
    }

    public boolean isDrawLabels() {
        return this.drawLabels;
    }

    public BufferedImage loadImage(String image) {
        BufferedImage img = this.imageCache.get(image);
        if (img == null && (img = mxUtils.loadImage(image)) != null) {
            this.imageCache.put(image, img);
        }
        return img;
    }

    public void flushImageCache() {
        this.imageCache.clear();
    }

    public String getImageForStyle(Map<String, Object> style) {
        String filename = mxUtils.getString(style, mxConstants.STYLE_IMAGE);
        if (filename != null && !filename.startsWith("/")) {
            filename = String.valueOf(this.imageBasePath) + filename;
        }
        return filename;
    }
}

