/*
 * Decompiled with CFR 0.152.
 */
package com.mxgraph.analysis;

import com.mxgraph.analysis.mxFibonacciHeap;
import com.mxgraph.analysis.mxICostFunction;
import com.mxgraph.analysis.mxUnionFind;
import com.mxgraph.view.mxCellState;
import com.mxgraph.view.mxGraph;
import com.mxgraph.view.mxGraphView;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.List;

public class mxGraphAnalysis {
    protected static mxGraphAnalysis instance = new mxGraphAnalysis();

    protected mxGraphAnalysis() {
    }

    public static mxGraphAnalysis getInstance() {
        return instance;
    }

    public static void setInstance(mxGraphAnalysis instance) {
        mxGraphAnalysis.instance = instance;
    }

    public Object[] getShortestPath(mxGraph graph, Object from, Object to, mxICostFunction cf, int steps, boolean directed) {
        mxGraphView view = graph.getView();
        mxFibonacciHeap q = this.createPriorityQueue();
        Hashtable<Object, Object> pred = new Hashtable<Object, Object>();
        q.decreaseKey(q.getNode(from, true), 0.0);
        int j = 0;
        while (j < steps) {
            Object[] e;
            mxFibonacciHeap.Node node = q.removeMin();
            double prio = node.getKey();
            Object obj = node.getUserObject();
            if (obj == to) break;
            Object[] objectArray = e = directed ? graph.getOutgoingEdges(obj) : graph.getConnections(obj);
            if (e != null) {
                int i = 0;
                while (i < e.length) {
                    double oldPrio;
                    double newPrio;
                    Object neighbour;
                    Object[] opp = graph.getOpposites(new Object[]{e[i]}, obj);
                    if (opp != null && opp.length > 0 && (neighbour = opp[0]) != null && neighbour != obj && neighbour != from && (newPrio = prio + (cf != null ? cf.getCost(view.getState(e[i])) : 1.0)) < (oldPrio = (node = q.getNode(neighbour, true)).getKey())) {
                        pred.put(neighbour, e[i]);
                        q.decreaseKey(node, newPrio);
                    }
                    ++i;
                }
            }
            if (q.isEmpty()) break;
            ++j;
        }
        ArrayList<Object> list = new ArrayList<Object>(2 * steps);
        Object obj = to;
        Object edge = pred.get(obj);
        if (edge != null) {
            list.add(obj);
            while (edge != null) {
                list.add(0, edge);
                boolean isSource = view.getVisibleTerminal(edge, true) == obj;
                obj = view.getVisibleTerminal(edge, !isSource);
                list.add(0, obj);
                edge = pred.get(obj);
            }
        }
        return list.toArray();
    }

    public Object[] getMinimumSpanningTree(mxGraph graph, Object[] v, mxICostFunction cf, boolean directed) {
        ArrayList mst = new ArrayList(v.length);
        mxFibonacciHeap q = this.createPriorityQueue();
        Hashtable<Object, Object> pred = new Hashtable<Object, Object>();
        Object u = v[0];
        q.decreaseKey(q.getNode(u, true), 0.0);
        int i = 1;
        while (i < v.length) {
            q.getNode(v[i], true);
            ++i;
        }
        while (!q.isEmpty()) {
            mxFibonacciHeap.Node node = q.removeMin();
            u = node.getUserObject();
            Object edge = pred.get(u);
            if (edge != null) {
                mst.add(edge);
            }
            Object[] e = directed ? graph.getOutgoingEdges(u) : graph.getConnections(u);
            Object[] opp = graph.getOpposites(e, u);
            if (e == null) continue;
            int i2 = 0;
            while (i2 < e.length) {
                double oldPrio;
                double newPrio;
                Object neighbour = opp[i2];
                if (neighbour != null && neighbour != u && (node = q.getNode(neighbour, false)) != null && (newPrio = cf.getCost(graph.getView().getState(e[i2]))) < (oldPrio = node.getKey())) {
                    pred.put(neighbour, e[i2]);
                    q.decreaseKey(node, newPrio);
                }
                ++i2;
            }
        }
        return mst.toArray();
    }

    public Object[] getMinimumSpanningTree(mxGraph graph, Object[] v, Object[] e, mxICostFunction cf) {
        mxGraphView view = graph.getView();
        mxUnionFind uf = this.createUnionFind(v);
        ArrayList<Object> result = new ArrayList<Object>(e.length);
        mxCellState[] edgeStates = this.sort(view.getCellStates(e), cf);
        int i = 0;
        while (i < edgeStates.length) {
            Object edge = edgeStates[i].getCell();
            Object source = view.getVisibleTerminal(edge, true);
            Object target = view.getVisibleTerminal(edge, false);
            mxUnionFind.Node setA = uf.find(uf.getNode(source));
            mxUnionFind.Node setB = uf.find(uf.getNode(target));
            if (setA == null || setB == null || setA != setB) {
                uf.union(setA, setB);
                result.add(edge);
            }
            ++i;
        }
        return result.toArray();
    }

    public mxUnionFind getConnectionComponents(mxGraph graph, Object[] v, Object[] e) {
        mxGraphView view = graph.getView();
        mxUnionFind uf = this.createUnionFind(v);
        int i = 0;
        while (i < e.length) {
            Object source = view.getVisibleTerminal(e[i], true);
            Object target = view.getVisibleTerminal(e[i], false);
            uf.union(uf.find(uf.getNode(source)), uf.find(uf.getNode(target)));
            ++i;
        }
        return uf;
    }

    public mxCellState[] sort(mxCellState[] states, final mxICostFunction cf) {
        List<mxCellState> result = Arrays.asList(states);
        Collections.sort(result, new Comparator<mxCellState>(){

            @Override
            public int compare(mxCellState o1, mxCellState o2) {
                Double d1 = new Double(cf.getCost(o1));
                Double d2 = new Double(cf.getCost(o2));
                return d1.compareTo(d2);
            }
        });
        return (mxCellState[])result.toArray();
    }

    public double sum(mxCellState[] states, mxICostFunction cf) {
        double sum = 0.0;
        int i = 0;
        while (i < states.length) {
            sum += cf.getCost(states[i]);
            ++i;
        }
        return sum;
    }

    protected mxUnionFind createUnionFind(Object[] v) {
        return new mxUnionFind(v);
    }

    protected mxFibonacciHeap createPriorityQueue() {
        return new mxFibonacciHeap();
    }
}

