import java.util.Random;


public class UndergradStudent extends Student
{
	private int[] averageEssayLen = new int[]{40, 30, 25,20};
	private int essayLenRange=10;
	private int schoolYear;
	private String[] wordSet;
	private Random rand = new Random();
	public UndergradStudent(String name, String major, 
			int schoolYear) throws InvalidFieldValueException
	{
		super(name, major);
		if (schoolYear >4 || schoolYear<1)
			throw new InvalidFieldValueException("school year");
		this.schoolYear = schoolYear;
		wordSet = new String[] { "cornell", "college", "study",
				"work", "literature", "english", "science", "chemistry",
				"math", "calculus","winter","summer","break","stress",
				"new", "is", "a", "computer", "biology", "medieval",
				"french", "anthropology", "art", "sculpture", "eclipse",
				"prerequisite", "introduction", "geology", "earth",
				"materials", "engineering", "physics", "electromagnetic",
				"velocity", "assignment", "essay", "test", "prelim", "final",
				"biochemistry", "life", "real", "analysis", "laptop", "program",
				"major", "decisions", "ithaca"};
	}
	
	public int getSchoolYear() {
		return schoolYear;
	}

	public void incrementYear() throws InvalidFieldValueException
	{
		if (schoolYear == 4)
			throw new InvalidFieldValueException("school year");
		this.schoolYear++;
	}
	
	public String[] getWordSet() {
		return wordSet;
	}

	public void setWordSet(String[] wordSet) {
		this.wordSet = wordSet;
	}

	@Override
	public String submitAssignment(int num, String assignDesc) 
	{
		//length of assignment is in inverse proportion to year.
		int assnLen = averageEssayLen[schoolYear-1]-essayLenRange + rand.nextInt(2*essayLenRange+1);
		String s = "";
		for (int i = 0; i<assnLen; i++)
		{
			s+=" "+wordSet[rand.nextInt(wordSet.length)];
		}
		return s;
	}

	public void multiplyAvgEssayLens(double frac)
	{
		for (int i = 0; i<averageEssayLen.length; i++)
		{
			averageEssayLen[i]=(int)(averageEssayLen[i]*frac);
		}
	}
	

}
class InvalidFieldValueException extends Exception{
	public InvalidFieldValueException(String s)
	{
		super("out of bounds "+s);
	}
}