import java.util.Random;


public class ComputerScienceStudent extends UndergradStudent
{
	private static double[] fracWordsFromGenStudies = new double[]{1, .5, .25, 0};
	/**
	 * general constructor.  We will use it to show method
	 * overloading.
	 * @param name
	 * @param major
	 * @param schoolYear
	 * @throws InvalidFieldValueException
	 */
	public ComputerScienceStudent(String name,
			int schoolYear) throws InvalidFieldValueException 
	{
		super(name, "Computer Science", schoolYear);
		
		//update word set to include computer science words.
		//computer scientists' vocabularies in this model shrink!
		//with higher school years, the number of "old words" from
		//general college ed decrease.
		String[] oldWordSet = this.getWordSet();
		String[] addedWordSet = {"computer", "science", "math",
				"algorithms", "data", "structures", "error",
				"computer","science", "cs","problem","estimates",
				"programming","java","cornell", "abstract"};
		Random rand = new Random();
		String[] newWordSet = new String[addedWordSet.length+
		           (int)(fracWordsFromGenStudies[schoolYear-1]*oldWordSet.length)];
		for(int i = 0; i<newWordSet.length;i++){
			if(i<addedWordSet.length) newWordSet[i]=addedWordSet[i];
			else newWordSet[i]=oldWordSet[rand.nextInt(oldWordSet.length)];
		}
		this.setWordSet(newWordSet);
		
	}
	/**
	 * constructor that assumes that the computer science.
	 * student is a freshman.
	 * This is an example of _method overloading_: we 
	 * have 2 constructors with the same name but different 
	 * signatures.
	 * @param name
	 * @param major
	 * @throws InvalidFieldValueException 
	 */
	public ComputerScienceStudent(String name) 
							throws InvalidFieldValueException
	{
		//this allows us to call a constructor in the same class
		this(name, 1);
	}

}
